/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.sprite;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import teamroots.emberroot.EmberRootZoo;
import teamroots.emberroot.config.ConfigSpawnEntity;
import teamroots.emberroot.entity.sprite.ISprite;
import teamroots.emberroot.util.EntityUtil;
import teamroots.emberroot.util.Util;

public class EntitySprite
extends EntityFlying
implements ISprite {
    public static final DataParameter<Float> targetDirectionX = EntityDataManager.func_187226_a(EntitySprite.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> targetDirectionY = EntityDataManager.func_187226_a(EntitySprite.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Integer> dashTimer = EntityDataManager.func_187226_a(EntitySprite.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> happiness = EntityDataManager.func_187226_a(EntitySprite.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> stunned = EntityDataManager.func_187226_a(EntitySprite.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<BlockPos> targetBlock = EntityDataManager.func_187226_a(EntitySprite.class, (DataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<BlockPos> lastTargetBlock = EntityDataManager.func_187226_a(EntitySprite.class, (DataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<BlockPos> lastLastTargetBlock = EntityDataManager.func_187226_a(EntitySprite.class, (DataSerializer)DataSerializers.field_187200_j);
    public static final String NAME = "rootsonesprite";
    private static final double RANGE_ATTACK = 16.0;
    public float range = 64.0f;
    public static ConfigSpawnEntity config = new ConfigSpawnEntity(EntitySprite.class, EnumCreatureType.MONSTER);
    public float addDirectionX = 0.0f;
    public float addDirectionY = 0.0f;
    public float twirlTimer = 0.0f;
    public float prevYaw1 = 0.0f;
    public float prevYaw2 = 0.0f;
    public float prevYaw3 = 0.0f;
    public float prevYaw4 = 0.0f;
    public float prevPitch1 = 0.0f;
    public float prevPitch2 = 0.0f;
    public float prevPitch3 = 0.0f;
    public float prevPitch4 = 0.0f;
    public Vec3d moveVec = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d prevMoveVec = new Vec3d(0.0, 0.0, 0.0);
    Random random = new Random();
    public int offset = this.random.nextInt(25);
    public static SoundEvent ambientSound = new SoundEvent(new ResourceLocation("emberroot", "spiritambient"));
    public static SoundEvent hurtSound = new SoundEvent(new ResourceLocation("emberroot", "spirithurt"));
    public static SoundEvent staffcast = new SoundEvent(new ResourceLocation("emberroot", "staffcast"));

    public EntitySprite(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
        this.func_70105_a(0.75f, 0.75f);
        this.field_70160_al = true;
        this.field_70728_aV = 10;
        this.field_70177_z = this.field_70146_Z.nextInt(240) + 60;
    }

    public int func_70641_bl() {
        return EntitySprite.config.settings.max;
    }

    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        boolean canSpawn = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() != Blocks.field_150350_a && this.field_70170_p.func_175699_k(blockpos) < 7 && super.func_70601_bi() && this.field_70146_Z.nextInt(EntitySprite.config.settings.weightedProb) == 0;
        return canSpawn;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(targetDirectionX, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(targetDirectionY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(dashTimer, (Object)0);
        this.func_184212_Q().func_187214_a(happiness, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(stunned, (Object)false);
        this.func_184212_Q().func_187214_a(targetBlock, (Object)new BlockPos(0, -1, 0));
        this.func_184212_Q().func_187214_a(lastTargetBlock, (Object)new BlockPos(0, -1, 0));
        this.func_184212_Q().func_187214_a(lastLastTargetBlock, (Object)new BlockPos(0, -1, 0));
    }

    public void func_82167_n(Entity entity) {
        if (this.func_70638_az() != null && this.func_110143_aJ() > 0.0f && !((Boolean)this.func_184212_Q().func_187225_a(stunned)).booleanValue() && entity instanceof EntityLivingBase && entity.func_110124_au().compareTo(this.func_70638_az().func_110124_au()) == 0) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (EntityUtil.isCreativePlayer(living)) {
                return;
            }
            living.func_70097_a(DamageSource.field_76377_j, EntitySprite.config.settings.attack);
            float magnitude = (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            living.func_70653_a((Entity)this, 3.0f * magnitude + 0.1f, -this.field_70159_w / (double)magnitude + 0.1, -this.field_70179_y / (double)magnitude + 0.1);
            living.func_70652_k((Entity)this);
            living.func_70604_c((EntityLivingBase)this);
        }
    }

    public void func_70619_bc() {
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (((Float)this.func_184212_Q().func_187225_a(happiness)).floatValue() > 0.0f && this.field_70173_aa % 2 == 0) {
            EmberRootZoo.proxy.spawnParticleMagicSparkleScalableFX(this.func_130014_f_(), 24, this.field_70165_t + (double)(this.field_70130_N * 0.5f * (this.random.nextFloat() - 0.5f)), this.field_70163_u + (double)(this.field_70131_O * 0.5f) + (double)(this.field_70131_O * (this.random.nextFloat() - 0.5f)), this.field_70161_v + (double)(this.field_70130_N * 0.5f * (this.random.nextFloat() - 0.5f)), 0, 0, 0, ((Float)this.func_184212_Q().func_187225_a(happiness)).floatValue() / 20.0f, 107, 255, 28);
        }
        if (((BlockPos)this.func_184212_Q().func_187225_a(targetBlock)).func_177956_o() == -1) {
            this.func_184212_Q().func_187227_b(targetBlock, (Object)this.func_180425_c());
            this.func_184212_Q().func_187217_b(targetBlock);
        }
        this.prevYaw4 = this.prevYaw3;
        this.prevYaw3 = this.prevYaw2;
        this.prevYaw2 = this.prevYaw1;
        this.prevYaw1 = this.field_70177_z;
        this.prevPitch4 = this.prevPitch3;
        this.prevPitch3 = this.prevPitch2;
        this.prevPitch2 = this.prevPitch1;
        this.prevPitch1 = this.field_70125_A;
        if (((Boolean)this.func_184212_Q().func_187225_a(stunned)).booleanValue()) {
            this.func_70624_b(null);
        }
        if (!((Boolean)this.func_184212_Q().func_187225_a(stunned)).booleanValue()) {
            List<EntityPlayer> playersValid;
            if (this.field_70173_aa % 20 == 0 && this.random.nextInt(4) == 0 && !((Boolean)this.func_184212_Q().func_187225_a(stunned)).booleanValue()) {
                this.func_130014_f_().func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ambientSound, SoundCategory.NEUTRAL, this.random.nextFloat() * 0.1f + 0.95f, this.random.nextFloat() * 0.1f + 0.95f, false);
            }
            if (this.twirlTimer > 0.0f) {
                this.twirlTimer -= 1.0f;
            }
            if ((Integer)this.func_184212_Q().func_187225_a(dashTimer) > 0) {
                this.func_184212_Q().func_187227_b(dashTimer, (Object)((Integer)this.func_184212_Q().func_187225_a(dashTimer) - 1));
                this.func_184212_Q().func_187217_b(dashTimer);
            }
            if (this.func_70638_az() != null && !this.func_130014_f_().field_72995_K) {
                if ((Integer)this.func_184212_Q().func_187225_a(dashTimer) <= 0) {
                    this.func_184212_Q().func_187227_b(targetDirectionX, (Object)Float.valueOf((float)Math.toRadians(Util.yawDegreesBetweenPointsSafe(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e() / 2.0, this.func_70638_az().field_70161_v, ((Float)this.func_184212_Q().func_187225_a(targetDirectionX)).doubleValue()))));
                    this.func_184212_Q().func_187227_b(targetDirectionY, (Object)Float.valueOf((float)Math.toRadians(Util.pitchDegreesBetweenPoints(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e() / 2.0, this.func_70638_az().field_70161_v))));
                    this.func_184212_Q().func_187217_b(targetDirectionX);
                    this.func_184212_Q().func_187217_b(targetDirectionY);
                }
                if (this.field_70173_aa % 20 == 0 && this.random.nextInt(3) == 0) {
                    this.func_184212_Q().func_187227_b(dashTimer, (Object)20);
                    this.func_184212_Q().func_187217_b(dashTimer);
                    this.twirlTimer = 20.0f;
                }
            } else if (((BlockPos)this.func_184212_Q().func_187225_a(targetBlock)).func_177956_o() != -1) {
                if (this.field_70173_aa % 40 == 0 && !this.func_130014_f_().field_72995_K) {
                    Vec3d target = new Vec3d((double)((BlockPos)this.func_184212_Q().func_187225_a(targetBlock)).func_177958_n() + 0.5 + (double)((this.random.nextFloat() - 0.5f) * 9.0f), (double)((BlockPos)this.func_184212_Q().func_187225_a(targetBlock)).func_177956_o() + 4.0 + (double)((this.random.nextFloat() - 0.5f) * 9.0f), (double)((BlockPos)this.func_184212_Q().func_187225_a(targetBlock)).func_177952_p() + 0.5 + (double)((this.random.nextFloat() - 0.5f) * 9.0f));
                    this.func_184212_Q().func_187227_b(targetDirectionX, (Object)Float.valueOf((float)Math.toRadians(Util.yawDegreesBetweenPointsSafe(this.field_70165_t, this.field_70163_u, this.field_70161_v, target.field_72450_a, target.field_72448_b, target.field_72449_c, ((Float)this.func_184212_Q().func_187225_a(targetDirectionX)).doubleValue()))));
                    this.func_184212_Q().func_187227_b(targetDirectionY, (Object)Float.valueOf((float)Math.toRadians(Util.pitchDegreesBetweenPoints(this.field_70165_t, this.field_70163_u, this.field_70161_v, target.field_72450_a, target.field_72448_b, target.field_72449_c))));
                    this.func_184212_Q().func_187217_b(targetDirectionX);
                    this.func_184212_Q().func_187217_b(targetDirectionY);
                }
            } else if (this.field_70173_aa % 40 == 0 && !this.func_130014_f_().field_72995_K) {
                this.func_184212_Q().func_187227_b(targetDirectionX, (Object)Float.valueOf((float)Math.toRadians(this.random.nextFloat() * 360.0f)));
                this.func_184212_Q().func_187227_b(targetDirectionY, (Object)Float.valueOf((float)Math.toRadians(this.random.nextFloat() * 180.0f - 90.0f)));
                this.func_184212_Q().func_187217_b(targetDirectionX);
                this.func_184212_Q().func_187217_b(targetDirectionY);
            }
            if (this.field_70173_aa % 5 == 0) {
                this.prevMoveVec = this.moveVec;
                this.moveVec = Util.lookVector(((Float)this.func_184212_Q().func_187225_a(targetDirectionX)).floatValue(), ((Float)this.func_184212_Q().func_187225_a(targetDirectionY)).floatValue()).func_186678_a(this.func_70638_az() != null ? ((Integer)this.func_184212_Q().func_187225_a(dashTimer) > 0 ? 0.3 : 0.225) : 0.15);
            }
            float motionInterp = (float)(this.field_70173_aa % 5) / 5.0f;
            this.field_70159_w = (double)(1.0f - motionInterp) * this.prevMoveVec.field_72450_a + (double)motionInterp * this.moveVec.field_72450_a;
            this.field_70181_x = (double)(1.0f - motionInterp) * this.prevMoveVec.field_72448_b + (double)motionInterp * this.moveVec.field_72448_b;
            this.field_70179_y = (double)(1.0f - motionInterp) * this.prevMoveVec.field_72449_c + (double)motionInterp * this.moveVec.field_72449_c;
            this.field_70177_z = (float)Math.toRadians(Util.yawDegreesBetweenPointsSafe(0.0, 0.0, 0.0, this.field_70159_w, this.field_70181_x, this.field_70179_y, this.field_70177_z));
            this.field_70125_A = (float)Math.toRadians(Util.pitchDegreesBetweenPoints(0.0, 0.0, 0.0, this.field_70159_w, this.field_70181_x, this.field_70179_y));
            if ((Integer)this.func_184212_Q().func_187225_a(dashTimer) > 0) {
                EmberRootZoo.proxy.spawnParticleMagicSparkleFX(this.func_130014_f_(), this.field_70165_t + (this.random.nextDouble() - 0.5) * 0.5, this.field_70163_u + 0.25 + (this.random.nextDouble() - 0.5) * 0.5, this.field_70161_v + (this.random.nextDouble() - 0.5) * 0.5, -0.25 * this.moveVec.field_72450_a, -0.25 * this.moveVec.field_72448_b, -0.25 * this.moveVec.field_72449_c, 107.0, 255.0, 28.0);
            }
            if (((Float)this.func_184212_Q().func_187225_a(happiness)).floatValue() < -25.0f && (playersValid = EntityUtil.getNonCreativePlayers(this.func_130014_f_(), new AxisAlignedBB(this.field_70165_t - 16.0, this.field_70163_u - 16.0, this.field_70161_v - 16.0, this.field_70165_t + 16.0, this.field_70163_u + 16.0, this.field_70161_v + 16.0))).size() > 0) {
                this.func_70624_b((EntityLivingBase)playersValid.get(this.field_70146_Z.nextInt(playersValid.size())));
            }
        } else {
            if (this.func_110143_aJ() > 0.75f * this.func_110138_aP()) {
                this.func_184212_Q().func_187227_b(stunned, (Object)false);
                this.func_184212_Q().func_187217_b(stunned);
            }
            this.field_70125_A = (float)((double)this.field_70125_A * 0.9);
            this.field_70159_w = 0.9 * this.field_70159_w;
            this.field_70181_x = -0.05;
            this.field_70179_y = 0.9 * this.field_70179_y;
        }
        if (this.getHappiness() > 0.0f) {
            this.setHappiness(this.getHappiness() - 0.001f);
        }
    }

    public int func_70070_b() {
        if (((Boolean)this.func_184212_Q().func_187225_a(stunned)).booleanValue()) {
            return 128;
        }
        float f = 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_70070_b();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_130014_f_().func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, hurtSound, SoundCategory.NEUTRAL, this.random.nextFloat() * 0.1f + 0.95f, this.random.nextFloat() * 0.1f + 0.95f, false);
        this.func_184212_Q().func_187227_b(happiness, (Object)Float.valueOf(((Float)this.func_184212_Q().func_187225_a(happiness)).floatValue() - 5.0f));
        this.func_184212_Q().func_187217_b(happiness);
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        return super.func_70652_k(entity);
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.func_130014_f_().func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, hurtSound, SoundCategory.NEUTRAL, this.random.nextFloat() * 0.1f + 0.95f, (this.random.nextFloat() * 0.1f + 0.95f) / 2.0f, false);
    }

    public boolean func_175446_cd() {
        return false;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.25);
        ConfigSpawnEntity.syncInstance((EntityLivingBase)this, EntitySprite.config.settings);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(targetDirectionX, (Object)Float.valueOf(compound.func_74760_g("targetDirectionX")));
        this.func_184212_Q().func_187227_b(targetDirectionY, (Object)Float.valueOf(compound.func_74760_g("targetDirectionY")));
        this.func_184212_Q().func_187227_b(dashTimer, (Object)compound.func_74762_e("dashTimer"));
        this.func_184212_Q().func_187227_b(happiness, (Object)Float.valueOf(compound.func_74760_g("happiness")));
        this.func_184212_Q().func_187227_b(stunned, (Object)compound.func_74767_n("stunned"));
        this.func_184212_Q().func_187227_b(targetBlock, (Object)new BlockPos(compound.func_74762_e("targetBlockX"), compound.func_74762_e("targetBlockY"), compound.func_74762_e("targetBlockZ")));
        this.func_184212_Q().func_187227_b(lastTargetBlock, (Object)new BlockPos(compound.func_74762_e("lastTargetBlockX"), compound.func_74762_e("lastTargetBlockY"), compound.func_74762_e("lastTargetBlockZ")));
        this.func_184212_Q().func_187227_b(lastLastTargetBlock, (Object)new BlockPos(compound.func_74762_e("lastLastTargetBlockX"), compound.func_74762_e("lastLastTargetBlockY"), compound.func_74762_e("lastLastTargetBlockZ")));
        this.func_184212_Q().func_187217_b(targetDirectionX);
        this.func_184212_Q().func_187217_b(targetDirectionY);
        this.func_184212_Q().func_187217_b(dashTimer);
        this.func_184212_Q().func_187217_b(happiness);
        this.func_184212_Q().func_187217_b(stunned);
        this.func_184212_Q().func_187217_b(targetBlock);
        this.func_184212_Q().func_187217_b(lastTargetBlock);
        this.func_184212_Q().func_187217_b(lastLastTargetBlock);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("targetDirectionX", ((Float)this.func_184212_Q().func_187225_a(targetDirectionX)).floatValue());
        compound.func_74776_a("targetDirectionY", ((Float)this.func_184212_Q().func_187225_a(targetDirectionY)).floatValue());
        compound.func_74768_a("dashTimer", ((Integer)this.func_184212_Q().func_187225_a(dashTimer)).intValue());
        compound.func_74776_a("happiness", ((Float)this.func_184212_Q().func_187225_a(happiness)).floatValue());
        compound.func_74757_a("stunned", ((Boolean)this.func_184212_Q().func_187225_a(stunned)).booleanValue());
        compound.func_74768_a("targetBlockX", ((BlockPos)this.func_184212_Q().func_187225_a(targetBlock)).func_177958_n());
        compound.func_74768_a("targetBlockY", ((BlockPos)this.func_184212_Q().func_187225_a(targetBlock)).func_177956_o());
        compound.func_74768_a("targetBlockZ", ((BlockPos)this.func_184212_Q().func_187225_a(targetBlock)).func_177952_p());
        compound.func_74768_a("lastTargetBlockX", ((BlockPos)this.func_184212_Q().func_187225_a(lastTargetBlock)).func_177958_n());
        compound.func_74768_a("lastTargetBlockY", ((BlockPos)this.func_184212_Q().func_187225_a(lastTargetBlock)).func_177956_o());
        compound.func_74768_a("lastTargetBlockZ", ((BlockPos)this.func_184212_Q().func_187225_a(lastTargetBlock)).func_177952_p());
        compound.func_74768_a("lastLastTargetBlockX", ((BlockPos)this.func_184212_Q().func_187225_a(lastLastTargetBlock)).func_177958_n());
        compound.func_74768_a("lastLastTargetBlockY", ((BlockPos)this.func_184212_Q().func_187225_a(lastLastTargetBlock)).func_177956_o());
        compound.func_74768_a("lastLastTargetBlockZ", ((BlockPos)this.func_184212_Q().func_187225_a(lastLastTargetBlock)).func_177952_p());
    }

    @Override
    public float getHappiness() {
        return ((Float)this.func_184212_Q().func_187225_a(happiness)).floatValue();
    }

    @Override
    public void setHappiness(float value) {
        this.func_184212_Q().func_187227_b(happiness, (Object)Float.valueOf(value));
        this.func_184212_Q().func_187217_b(happiness);
    }

    @Override
    public void setTargetPosition(BlockPos pos) {
        if (!pos.equals(this.func_184212_Q().func_187225_a(lastTargetBlock)) && !pos.equals(this.func_184212_Q().func_187225_a(targetBlock))) {
            this.func_184212_Q().func_187227_b(lastLastTargetBlock, this.func_184212_Q().func_187225_a(lastTargetBlock));
            this.func_184212_Q().func_187217_b(lastLastTargetBlock);
            this.func_184212_Q().func_187227_b(lastTargetBlock, this.func_184212_Q().func_187225_a(targetBlock));
            this.func_184212_Q().func_187217_b(lastTargetBlock);
            this.func_184212_Q().func_187227_b(targetBlock, (Object)pos);
            this.func_184212_Q().func_187217_b(targetBlock);
        }
    }

    @Override
    public BlockPos getTargetPosition() {
        return (BlockPos)this.func_184212_Q().func_187225_a(targetBlock);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("emberroot", "entity/sprite_normal");
    }
}

