/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.slime;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.emberroot.config.ConfigSpawnEntity;

public class EntityRainbowSlime
extends EntitySlime {
    public static final DataParameter<Integer> variant = EntityDataManager.func_187226_a(EntitySlime.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final String NAME = "rainbowslime";
    public static boolean canPlaceBlocks;
    public static boolean canPotionsDeath;
    public static ConfigSpawnEntity config;

    public EntityRainbowSlime(World worldIn) {
        super(worldIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        ConfigSpawnEntity.syncInstance((EntityLivingBase)this, EntityRainbowSlime.config.settings);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(variant, (Object)this.field_70146_Z.nextInt(VariantColors.values().length));
    }

    public Integer getVariant() {
        return (Integer)this.func_184212_Q().func_187225_a(variant);
    }

    public VariantColors getVariantEnum() {
        return VariantColors.values()[this.getVariant()];
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    private boolean isBaby() {
        return this.func_70809_q() == 1;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && canPlaceBlocks && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && this.isBaby() && this.func_110143_aJ() <= 0.0f) {
            this.setBlockOnDeath();
        }
        if (canPotionsDeath) {
            this.setPotionsOnDeath();
        }
        this.spawnChildSlimes();
        this.field_70128_L = true;
    }

    private void setBlockOnDeath() {
        BlockPos pos = this.func_180425_c();
        IBlockState setBlock = null;
        IBlockState current = this.field_70170_p.func_180495_p(pos);
        switch (this.getVariantEnum()) {
            case BLUE: {
                if (current.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
                    setBlock = Blocks.field_150355_j.func_176223_P();
                    break;
                }
                if (current.func_177230_c() != Blocks.field_150355_j) break;
                setBlock = Blocks.field_150432_aD.func_176223_P();
                break;
            }
            case GREY: {
                if (!current.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) break;
                setBlock = Blocks.field_150435_aG.func_176223_P();
                break;
            }
            case WHITE: {
                if (current.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
                    setBlock = Blocks.field_150431_aC.func_176223_P();
                }
                if (current.func_177230_c() != Blocks.field_150431_aC) break;
                setBlock = Blocks.field_150433_aE.func_176223_P();
                break;
            }
            case PURPLE: {
                break;
            }
            case RED: {
                break;
            }
        }
        if (setBlock != null) {
            this.field_70170_p.func_175656_a(this.func_180425_c(), setBlock);
        }
    }

    public void setPotionsOnDeath() {
        switch (this.getVariantEnum()) {
            case BLUE: {
                break;
            }
            case GREY: {
                break;
            }
            case PURPLE: {
                this.spawnLingeringPotion(PotionType.func_185168_a((String)"poison"));
                break;
            }
            case WHITE: {
                break;
            }
            case RED: {
                this.spawnLingeringPotion(PotionType.func_185168_a((String)"regeneration"));
            }
        }
    }

    private void spawnLingeringPotion(PotionType type) {
        EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)type));
        entitypotion.func_70186_c(0.0, 1.0, 0.0, 0.05f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)entitypotion);
        }
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        String var = this.getVariantEnum().nameLower();
        return I18n.func_74838_a((String)("entity." + s + "." + var + ".name"));
    }

    private void spawnChildSlimes() {
        int size = this.func_70809_q();
        if (!this.field_70170_p.field_72995_K && size > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)size / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)size / 4.0f;
                EntityRainbowSlime entityslime = this.createInstance();
                entityslime.func_184212_Q().func_187227_b(variant, (Object)this.getVariant());
                if (this.func_145818_k_()) {
                    entityslime.func_96094_a(this.func_95999_t());
                }
                if (this.func_104002_bU()) {
                    entityslime.func_110163_bv();
                }
                entityslime.func_70799_a(size / 2, true);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
    }

    protected EntityRainbowSlime createInstance() {
        return new EntityRainbowSlime(this.field_70170_p);
    }

    protected EnumParticleTypes func_180487_n() {
        return EnumParticleTypes.WATER_SPLASH;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(variant, (Object)compound.func_74762_e("variant"));
        this.func_184212_Q().func_187217_b(variant);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("variant", ((Integer)this.func_184212_Q().func_187225_a(variant)).intValue());
    }

    public ResourceLocation func_184647_J() {
        String colour = this.getVariantEnum().nameLower();
        return new ResourceLocation("emberroot", "entity/slime_" + colour);
    }

    static {
        config = new ConfigSpawnEntity(EntityRainbowSlime.class, EnumCreatureType.MONSTER);
    }

    public static enum VariantColors {
        BLUE,
        GREY,
        WHITE,
        PURPLE,
        RED;


        public String nameLower() {
            return this.name().toLowerCase();
        }
    }
}

