/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.owl;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import teamroots.emberroot.entity.owl.FlyNodeProcessor;
import teamroots.emberroot.entity.owl.FlyingPathFinder;

public class FlyingPathNavigate
extends PathNavigateGround {
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3d lastPosCheck = new Vec3d(0.0, 0.0, 0.0);
    private boolean forceFlying = false;

    public FlyingPathNavigate(EntityLiving entitylivingIn, World worldIn) {
        super(entitylivingIn, worldIn);
    }

    public boolean isForceFlying() {
        return this.forceFlying && !this.func_75500_f();
    }

    public void setForceFlying(boolean forceFlying) {
        this.forceFlying = forceFlying;
    }

    protected PathFinder func_179679_a() {
        this.field_179695_a = new FlyNodeProcessor();
        return new FlyingPathFinder(this.field_179695_a);
    }

    protected boolean func_75485_k() {
        return true;
    }

    protected Vec3d func_75502_i() {
        int y = (int)(this.field_75515_a.func_174813_aQ().field_72338_b + 0.5);
        return new Vec3d(this.field_75515_a.field_70165_t, (double)y, this.field_75515_a.field_70161_v);
    }

    public boolean tryFlyToXYZ(double x, double y, double z, double speedIn) {
        Path pathentity = this.func_179680_a(new BlockPos((double)MathHelper.func_76128_c((double)x), (double)((int)y), (double)MathHelper.func_76128_c((double)z)));
        return this.setPath(pathentity, speedIn, true);
    }

    public boolean tryFlyToPos(double x, double y, double z, double speedIn) {
        Path pathentity = this.func_75488_a(x, y, z);
        return this.setPath(pathentity, speedIn, true);
    }

    public boolean tryFlyToEntityLiving(Entity entityIn, double speedIn) {
        Path pathentity = this.func_75494_a(entityIn);
        return pathentity != null ? this.setPath(pathentity, speedIn, true) : false;
    }

    public boolean setPath(Path path, double speed, boolean forceFlying) {
        if (super.func_75484_a(path, speed)) {
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck = this.func_75502_i();
            this.forceFlying = forceFlying;
            return true;
        }
        return false;
    }

    public boolean func_75484_a(Path path, double speed) {
        return this.setPath(path, speed, false);
    }

    public void func_75501_e() {
        ++this.totalTicks;
        if (!this.func_75500_f()) {
            this.func_75508_h();
            if (!this.func_75500_f()) {
                double aboveBlock;
                Vec3d targetPos = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
                if (targetPos == null) {
                    return;
                }
                double y = targetPos.field_72448_b;
                if (this.forceFlying && (aboveBlock = y - (double)((int)y)) < 0.1) {
                    y = (double)((int)y) + 0.1;
                }
                this.field_75515_a.func_70605_aq().func_75642_a(targetPos.field_72450_a, y, targetPos.field_72449_c, this.field_75511_d);
            }
        }
    }

    protected void func_75508_h() {
        Vec3d targetPos;
        double distToCurrTargSq;
        Vec3d entPos = this.func_75502_i();
        float entWidthSq = this.field_75515_a.field_70130_N * this.field_75515_a.field_70130_N;
        if (this.field_75514_c.func_75873_e() == this.field_75514_c.func_75874_d() - 1 && this.field_75515_a.field_70122_E) {
            entWidthSq = 0.01f;
        }
        if ((distToCurrTargSq = entPos.func_72436_e(targetPos = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, this.field_75514_c.func_75873_e()))) < (double)entWidthSq) {
            this.field_75514_c.func_75875_a();
        }
        int i = 6;
        for (int j = Math.min(this.field_75514_c.func_75873_e() + i, this.field_75514_c.func_75874_d() - 1); j > this.field_75514_c.func_75873_e(); --j) {
            targetPos = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, j);
            if (!(targetPos.func_72436_e(entPos) <= 36.0) || !this.func_75493_a(entPos, targetPos, 0, 0, 0)) continue;
            this.field_75514_c.func_75872_c(j);
            break;
        }
        this.func_179677_a(entPos);
    }

    protected boolean func_75493_a(Vec3d startPos, Vec3d endPos, int sizeX, int sizeY, int sizeZ) {
        Vec3d target = new Vec3d(endPos.field_72450_a, endPos.field_72448_b + (double)this.field_75515_a.field_70131_O * 0.5, endPos.field_72449_c);
        if (!this.isClear(startPos, target)) {
            return false;
        }
        AxisAlignedBB bb = this.field_75515_a.func_174813_aQ();
        startPos = new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        return this.isClear(startPos, target);
    }

    private boolean isClear(Vec3d startPos, Vec3d target) {
        RayTraceResult hit = this.field_75513_b.func_147447_a(startPos, target, true, true, false);
        return hit == null || hit.field_72313_a == RayTraceResult.Type.MISS;
    }

    protected void func_179677_a(Vec3d positionVec3) {
        if (this.totalTicks - this.ticksAtLastPos > 10 && positionVec3.func_72436_e(this.lastPosCheck) < 0.0625) {
            this.func_75499_g();
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck = positionVec3;
            return;
        }
        if (this.totalTicks - this.ticksAtLastPos > 50) {
            if (positionVec3.func_72436_e(this.lastPosCheck) < 2.25) {
                this.func_75499_g();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck = positionVec3;
        }
    }
}

