/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.frozen;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import teamroots.emberroot.EmberRootZoo;
import teamroots.emberroot.config.ConfigSpawnEntity;
import teamroots.emberroot.util.EntityUtil;

public class EntityFrozenKnight
extends EntitySkeleton {
    public static final String NAME = "skeleton_frozen";
    public static ConfigSpawnEntity config = new ConfigSpawnEntity(EntityFrozenKnight.class, EnumCreatureType.MONSTER);
    public static boolean attacksVillagers;
    public static boolean avoidWolves;
    private float fallenKnightChancePerArmorPiece = 0.66f;
    private float fallenKnightChanceArmorUpgrade = 0.2f;
    private double fallenKnightChanceShield = 0.5;
    public static boolean spawnsWithArmor;
    public static boolean appliesSlowPotion;

    public EntityFrozenKnight(World world) {
        super(world);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        ConfigSpawnEntity.syncInstance((EntityLivingBase)this, EntityFrozenKnight.config.settings);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        if (avoidWolves) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWolf.class, 6.0f, 1.0, 1.2));
        }
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        if (attacksVillagers) {
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        }
    }

    public boolean func_70648_aU() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource s) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    private void addRandomArmor() {
        float occupiedDiffcultyMultiplier = EntityUtil.getDifficultyMultiplierForLocation(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        int equipmentLevel = this.getRandomEquipmentLevel(occupiedDiffcultyMultiplier);
        int armorLevel = equipmentLevel;
        if (armorLevel == 1) {
            ++armorLevel;
        }
        float chancePerPiece = this.fallenKnightChancePerArmorPiece;
        chancePerPiece *= 1.0f + occupiedDiffcultyMultiplier;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            Item item;
            ItemStack itemStack = this.func_184582_a(slot);
            if (itemStack != null || !(this.field_70146_Z.nextFloat() <= chancePerPiece) || (item = EntityLiving.func_184636_a((EntityEquipmentSlot)slot, (int)armorLevel)) == null) continue;
            ItemStack stack = new ItemStack(item);
            if (armorLevel == 0) {
                ((ItemArmor)item).func_82813_b(stack, 0);
            }
            this.func_184201_a(slot, stack);
        }
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getSwordForLevel(equipmentLevel));
        if (Math.random() <= this.fallenKnightChanceShield) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_185159_cQ));
        }
    }

    private int getRandomEquipmentLevel(float occupiedDiffcultyMultiplier) {
        float chanceImprovedArmor = this.fallenKnightChanceArmorUpgrade;
        chanceImprovedArmor *= 1.0f + occupiedDiffcultyMultiplier;
        int armorLevel = this.field_70146_Z.nextInt(2);
        for (int i = 0; i < 2; ++i) {
            if (!(this.field_70146_Z.nextFloat() <= chanceImprovedArmor)) continue;
            ++armorLevel;
        }
        return armorLevel;
    }

    protected boolean isHardDifficulty() {
        return EntityUtil.isHardDifficulty(this.field_70170_p);
    }

    private ItemStack getSwordForLevel(int swordLevel) {
        if (swordLevel < 2) {
            swordLevel += this.field_70146_Z.nextInt(this.isHardDifficulty() ? 3 : 2);
            swordLevel = Math.min(swordLevel, 2);
        }
        switch (swordLevel) {
            case 0: {
                return new ItemStack(Items.field_151041_m);
            }
            case 1: {
                return new ItemStack(Items.field_151052_q);
            }
            case 2: {
                return new ItemStack(Items.field_151040_l);
            }
            case 4: {
                return new ItemStack(Items.field_151048_u);
            }
        }
        return new ItemStack(Items.field_151040_l);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance di, IEntityLivingData livingData) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (spawnsWithArmor) {
            this.addRandomArmor();
            this.func_180483_b(di);
        }
        float f = di.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        return livingData;
    }

    public void func_70014_b(NBTTagCompound root) {
        super.func_70014_b(root);
    }

    public void func_70037_a(NBTTagCompound root) {
        super.func_70037_a(root);
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("emberroot", "entity/skeleton_frozen");
    }

    public boolean func_70652_k(Entity entityIn) {
        if (appliesSlowPotion && entityIn instanceof EntityPlayer && !(entityIn instanceof FakePlayer)) {
            try {
                EntityPlayer p = (EntityPlayer)entityIn;
                if (!p.func_70644_a(MobEffects.field_76421_d)) {
                    p.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                }
            }
            catch (Exception e) {
                EmberRootZoo.log("Error applying slowness to player: possible ticking, dead, or fake player " + e.getMessage());
            }
        }
        return super.func_70652_k(entityIn);
    }
}

