/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.creeper;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import teamroots.emberroot.EmberRootZoo;
import teamroots.emberroot.config.ConfigSpawnEntity;
import teamroots.emberroot.util.TeleportUtil;

public class EntityConcussionCreeper
extends EntityCreeper {
    public static final DataParameter<Integer> variant = EntityDataManager.func_187226_a(EntityConcussionCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final String NAME = "creeper";
    private static final int concussionCreeperExplosionRange = 16;
    private static final int concussionCreeperMaxTeleportRange = 16;
    private static final int concussionCreeperConfusionDuration = 600;
    public static ConfigSpawnEntity config = new ConfigSpawnEntity(EntityConcussionCreeper.class, EnumCreatureType.MONSTER);
    private Field fTimeSinceIgnited;
    private Field fFuseTime;

    public EntityConcussionCreeper(World world) {
        super(world);
        try {
            this.fTimeSinceIgnited = ReflectionHelper.findField(EntityCreeper.class, (String[])new String[]{"timeSinceIgnited", "field_70833_d"});
            this.fFuseTime = ReflectionHelper.findField(EntityCreeper.class, (String[])new String[]{"fuseTime", "field_82225_f"});
        }
        catch (Exception e) {
            EmberRootZoo.instance.logger.error("Could not create ender creeper  logic as fields not found");
        }
    }

    public Integer getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(variant);
    }

    public VariantColors getVariantEnum() {
        return VariantColors.values()[this.getVariant()];
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        ConfigSpawnEntity.syncInstance((EntityLivingBase)this, EntityConcussionCreeper.config.settings);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(variant, (Object)this.field_70146_Z.nextInt(VariantColors.values().length));
    }

    private void spawnLingeringPotion(PotionType type) {
        ItemStack potion = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)type);
        EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, potion);
        entitypotion.func_70186_c(0.0, 1.0, 0.0, 0.75f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)entitypotion);
        }
    }

    public void func_70071_h_() {
        int fuseTime;
        int timeSinceIgnited;
        if (this.func_70089_S() && (timeSinceIgnited = this.getTimeSinceIgnited()) >= (fuseTime = this.getFuseTime()) - 1) {
            this.setTimeSinceIgnited(0);
            int range = 16;
            switch (this.getVariantEnum()) {
                case POISON: {
                    this.spawnLingeringPotion(PotionTypes.field_185254_z);
                    break;
                }
                case REGEN: {
                    this.spawnLingeringPotion(PotionTypes.field_185221_D);
                    break;
                }
                case BLUE: {
                    this.spawnLingeringPotion(PotionTypes.field_185227_J);
                    break;
                }
                case TP: {
                    AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range);
                    List ents = this.field_70170_p.func_72872_a(EntityLivingBase.class, bb);
                    for (EntityLivingBase ent : ents) {
                        if (ent == this) continue;
                        if (!this.field_70170_p.field_72995_K) {
                            boolean done = false;
                            for (int i = 0; i < 20 && !done; ++i) {
                                done = TeleportUtil.teleportRandomly(ent, 16);
                            }
                        }
                        if (!(ent instanceof EntityPlayer)) continue;
                        this.field_70170_p.func_184134_a(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                        EmberRootZoo.proxy.setInstantConfusionOnPlayer((EntityPlayer)ent, 600);
                    }
                    break;
                }
            }
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    private void setTimeSinceIgnited(int i) {
        if (this.fTimeSinceIgnited == null) {
            return;
        }
        try {
            this.fTimeSinceIgnited.setInt((Object)this, i);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getTimeSinceIgnited() {
        if (this.fTimeSinceIgnited == null) {
            return 0;
        }
        try {
            return this.fTimeSinceIgnited.getInt((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int getFuseTime() {
        if (this.fFuseTime == null) {
            return 0;
        }
        try {
            return this.fFuseTime.getInt((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public ResourceLocation func_184647_J() {
        return new ResourceLocation("emberroot", "entity/creeper_concussion");
    }

    public static enum VariantColors {
        TP,
        POISON,
        REGEN,
        BLUE;


        public String nameLower() {
            return this.name().toLowerCase();
        }
    }
}

