/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.Misc;
import xaero.map.region.MapBlock;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayManager;

public class OverlayBuilder {
    private static final int MAX_OVERLAYS = 10;
    private Overlay[] overlayBuildingSet;
    private int currentOverlayIndex;
    private OverlayManager overlayManager;
    private TextureAtlasSprite prevIcon;

    public OverlayBuilder(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
        this.overlayBuildingSet = new Overlay[10];
        for (int i = 0; i < this.overlayBuildingSet.length; ++i) {
            this.overlayBuildingSet[i] = new Overlay(0, new int[3], 0, 0, false);
        }
        this.currentOverlayIndex = -1;
    }

    public void startBuilding() {
        this.currentOverlayIndex = -1;
    }

    public void build(int state, int[] biome, int opacity, byte light, World world) {
        Overlay currentOverlay = null;
        if (this.currentOverlayIndex >= 0) {
            currentOverlay = this.overlayBuildingSet[this.currentOverlayIndex];
        }
        Overlay nextOverlay = null;
        if (this.currentOverlayIndex < this.overlayBuildingSet.length - 1) {
            nextOverlay = this.overlayBuildingSet[this.currentOverlayIndex + 1];
        }
        TextureAtlasSprite icon = null;
        boolean changed = false;
        if (currentOverlay == null || currentOverlay.getState() != state) {
            icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(Misc.getStateById(state));
            boolean bl = changed = icon != this.prevIcon;
        }
        if (nextOverlay != null && (currentOverlay == null || changed)) {
            IBlockState s = Misc.getStateById(state);
            int intensity = s.func_177230_c() instanceof BlockLiquid ? 2 : (s.func_177230_c() instanceof BlockIce ? 5 : 1);
            boolean glowing = false;
            try {
                glowing = MapProcessor.instance.getMapWriter().isGlowing(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nextOverlay.write(state, biome, intensity, light, glowing);
            currentOverlay = nextOverlay;
            ++this.currentOverlayIndex;
        }
        currentOverlay.increaseOpacity(opacity);
        if (changed) {
            this.prevIcon = icon;
        }
    }

    public void finishBuilding(MapBlock block) {
        for (int i = 0; i <= this.currentOverlayIndex; ++i) {
            Overlay o = this.overlayBuildingSet[i];
            Overlay original = this.overlayManager.getOriginal(o);
            if (o == original) {
                this.overlayBuildingSet[i] = new Overlay(0, new int[3], 0, 0, false);
            }
            block.addOverlay(original);
        }
    }
}

