/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.chunk.Chunk;
import xaero.map.MapProcessor;
import xaero.map.Misc;
import xaero.map.WorldMap;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class MapWriter
implements Runnable {
    public static final String[] DEFAULT_RESOURCE = new String[]{"minecraft", ""};
    private int X;
    private int Z;
    private int playerChunkX;
    private int playerChunkZ;
    private int insideX;
    private int insideZ;
    private long updateCounter;
    private int caveStart = -1;
    private boolean clearCachedColours;
    private MapBlock loadingObject = new MapBlock();
    private OverlayBuilder overlayBuilder;
    private BlockPos.MutableBlockPos mutableLocalPos;
    private BlockPos.MutableBlockPos mutableGlobalPos;
    private int[] biomeBuffer;
    private HashMap<String, Integer> textureColours = new HashMap();
    private HashMap<Integer, Integer> blockColours = new HashMap();

    public MapWriter(OverlayManager overlayManager) {
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.mutableLocalPos = new BlockPos.MutableBlockPos();
        this.mutableGlobalPos = new BlockPos.MutableBlockPos();
        this.biomeBuffer = new int[3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: while (true) {
            try {
                while (MapProcessor.instance.getCrashedBy() == null) {
                    long startTime = System.currentTimeMillis();
                    int totalTime = 2000000;
                    int sleepTime = 10;
                    while (totalTime > 0) {
                        try {
                            Object object = MapProcessor.instance.writerThreadPauseSync;
                            synchronized (object) {
                                if (!MapProcessor.instance.isWritingPaused() && !MapProcessor.instance.isWaitingForWorldUpdate() && MapProcessor.instance.getMapSaveLoad().isRegionDetectionComplete()) {
                                    if (MapProcessor.instance.getPlayer() == null || MapProcessor.instance.getWorld() == null) {
                                        sleepTime = 100;
                                        break;
                                    }
                                    if (MapProcessor.instance.getCurrentWorldString() == null || MapProcessor.instance.ignoreWorld(MapProcessor.instance.getWorld()) || !WorldMap.settings.updateChunks && !WorldMap.settings.loadChunks) {
                                        break;
                                    }
                                    long processStart = System.nanoTime();
                                    this.writeMap(MapProcessor.instance.getWorld(), MapProcessor.instance.getPlayer());
                                    totalTime = (int)((long)totalTime - (System.nanoTime() - processStart));
                                    if (this.insideX == 0 && this.insideZ == 0 && this.X == 0 && this.Z == 0) {
                                        sleepTime = 200;
                                        break;
                                    }
                                } else {
                                    break;
                                }
                            }
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {
                        }
                    }
                    int passed = (int)(System.currentTimeMillis() - startTime);
                    try {
                        if (passed >= sleepTime) continue block9;
                        Thread.sleep(sleepTime - passed);
                        continue block9;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (Exception e) {
                MapProcessor.instance.setCrashedBy(e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMap(World world, EntityPlayer player) {
        int loadDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c - 1;
        World world2 = world;
        synchronized (world2) {
            Chunk chunk;
            if (this.caveStart == -1 && world.func_72940_L() < 256 && (chunk = world.func_175726_f(player.func_180425_c())) != null && Math.abs(chunk.func_76611_b(0, 0) - world.func_72940_L()) < 16) {
                this.caveStart = world.func_72940_L() - 1;
            }
            if (this.insideX == 0 && this.insideZ == 0) {
                this.playerChunkX = (int)Math.floor(player.field_70165_t) >> 4;
                this.playerChunkZ = (int)Math.floor(player.field_70161_v) >> 4;
            }
            this.writeChunk(world, loadDistance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChunk(World world, int distance) {
        MapRegion mapRegion;
        boolean onlyLoad = WorldMap.settings.loadChunks && (!WorldMap.settings.updateChunks || this.updateCounter % 5L != 0L);
        int playerTileChunkX = this.playerChunkX >> 2;
        int playerTileChunkZ = this.playerChunkZ >> 2;
        int distanceInTileChunks = playerTileChunkX - (this.playerChunkX - distance >> 2);
        int tileChunkX = playerTileChunkX - distanceInTileChunks + this.X;
        int tileChunkZ = playerTileChunkZ - distanceInTileChunks + this.Z;
        int regionX = tileChunkX >> 3;
        int regionZ = tileChunkZ >> 3;
        MapRegion region = MapProcessor.instance.getMapRegion(regionX, regionZ, true);
        MapTileChunk tileChunk = null;
        Object object = region.writerThreadPauseSync;
        synchronized (object) {
            if (!region.isWritingPaused()) {
                boolean regionIsResting;
                mapRegion = region;
                synchronized (mapRegion) {
                    regionIsResting = region.isResting();
                    if (regionIsResting) {
                        region.setBeingWritten(true);
                        int tileChunkLocalX = tileChunkX & 7;
                        int tileChunkLocalZ = tileChunkZ & 7;
                        tileChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ);
                        if (region.getLoadState() == 2 && tileChunk == null) {
                            tileChunk = new MapTileChunk(region, tileChunkX, tileChunkZ);
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, tileChunk);
                            tileChunk.setLoadState((byte)2);
                        } else if (!(region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.getLoadState() != 0 && region.getLoadState() != 4)) {
                            MapProcessor.instance.getMapSaveLoad().requestLoad(region, "writing");
                        }
                    }
                }
                if (regionIsResting && tileChunk != null && tileChunk.getLoadState() == 2) {
                    if (tileChunk.toUpload(MapProcessor.instance.getLightLevel(), false) == -1) {
                        Chunk chunk;
                        int regZ;
                        int regX;
                        MapRegion prevRegion = null;
                        if (!tileChunk.wasSuccessful() && (tileChunkZ & 7) == 0 && ((prevRegion = MapProcessor.instance.getMapRegion(regX = region.getRegionX(), regZ = region.getRegionZ() - 1, false)) == null || prevRegion.getChunk(tileChunkX & 7, 7) == null || prevRegion.getChunk(tileChunkX & 7, 7).getLoadState() != 2) && MapProcessor.instance.regionExists(regX, regZ)) {
                            MapRegion mapRegion2 = prevRegion = MapProcessor.instance.getMapRegion(regX, regZ, true);
                            synchronized (mapRegion2) {
                                if (!(prevRegion.reloadHasBeenRequested() || prevRegion.recacheHasBeenRequested() || prevRegion.getLoadState() != 0 && prevRegion.getLoadState() != 4)) {
                                    prevRegion.setBeingWritten(true);
                                    MapProcessor.instance.getMapSaveLoad().requestLoad(prevRegion, "previous region needed");
                                }
                            }
                        }
                        int chunkX = tileChunkX * 4 + this.insideX;
                        int chunkZ = tileChunkZ * 4 + this.insideZ;
                        if (chunkX >= this.playerChunkX - distance && chunkX < this.playerChunkX + distance && chunkZ >= this.playerChunkZ - distance && chunkZ < this.playerChunkZ + distance && (chunk = world.func_72964_e(chunkX, chunkZ)) != null && chunk.func_177410_o()) {
                            MapTile mapTile;
                            boolean connectedToOthers = false;
                            block15: for (int i = -1; i < 2; ++i) {
                                for (int j = -1; j < 2; ++j) {
                                    Chunk neighbor;
                                    if (i == 0 && j == 0 || (neighbor = world.func_72964_e(chunkX + i, chunkZ + j)) == null || !neighbor.func_177410_o()) continue;
                                    connectedToOthers = true;
                                    break block15;
                                }
                            }
                            if (connectedToOthers && ((mapTile = tileChunk.getTile(this.insideX, this.insideZ)) == null && WorldMap.settings.loadChunks || mapTile != null && WorldMap.settings.updateChunks && !onlyLoad)) {
                                if (mapTile == null) {
                                    mapTile = MapProcessor.instance.getTilePool().get(MapProcessor.instance.getCurrentDimension(), chunkX, chunkZ);
                                }
                                if (mapTile.getPrevTile() == null) {
                                    tileChunk.findPrevTile(prevRegion, mapTile, this.insideX, this.insideZ);
                                }
                                for (int x = 0; x < 16; ++x) {
                                    for (int z = 0; z < 16; ++z) {
                                        int startHeight = chunk.func_76611_b(x, z) + 3;
                                        if (this.caveStart != -1) {
                                            startHeight = this.caveStart;
                                        }
                                        MapBlock currentPixel = mapTile.getBlock(x, z);
                                        this.loadPixel(world, this.loadingObject, currentPixel, chunk, x, z, startHeight, 0, this.caveStart != -1, mapTile.wasWrittenOnce());
                                        this.loadingObject.fixHeightType(world, x, z, mapTile.getPrevTile(), mapTile, tileChunk);
                                        if (this.loadingObject.equals(currentPixel)) continue;
                                        mapTile.setBlock(x, z, this.loadingObject);
                                        this.loadingObject = currentPixel != null ? currentPixel : new MapBlock();
                                        tileChunk.setChanged(true);
                                    }
                                }
                                tileChunk.setTile(this.insideX, this.insideZ, mapTile);
                                mapTile.setWrittenOnce(true);
                                mapTile.setLoaded(true);
                            }
                        }
                    }
                    if (!tileChunk.includeInSave()) {
                        tileChunk = null;
                        region.setChunk(tileChunkX & 7, tileChunkZ & 7, null);
                    }
                }
            }
        }
        ++this.insideZ;
        if (this.insideZ > 3) {
            this.insideZ = 0;
            ++this.insideX;
            if (this.insideX > 3) {
                this.insideX = 0;
                object = region.writerThreadPauseSync;
                synchronized (object) {
                    if (tileChunk != null && !region.isWritingPaused()) {
                        boolean regionIsStillWritable = false;
                        mapRegion = region;
                        synchronized (mapRegion) {
                            boolean bl = regionIsStillWritable = region.isResting() && region.getLoadState() == 2;
                            if (regionIsStillWritable) {
                                region.setBeingWritten(true);
                            }
                        }
                        if (tileChunk.wasChanged()) {
                            if (regionIsStillWritable) {
                                tileChunk.updateBuffers(world);
                            }
                            tileChunk.setChanged(false);
                        }
                    }
                }
                ++this.Z;
                if (this.Z > distanceInTileChunks * 2) {
                    this.Z = 0;
                    ++this.X;
                    if (this.X > distanceInTileChunks * 2) {
                        this.X = 0;
                        ++this.updateCounter;
                    }
                }
            }
        }
    }

    public int getBiomeColor(int type, BlockPos.MutableBlockPos pos) {
        int i = 0;
        int j = 0;
        int k = 0;
        int total = 0;
        int initX = pos.func_177958_n();
        int initZ = pos.func_177952_p();
        for (int o = -1; o < 2; ++o) {
            for (int p = -1; p < 2; ++p) {
                pos.func_181079_c(initX + o, pos.func_177956_o(), initZ + p);
                int b = this.getBiomeAtPos((BlockPos)pos);
                if (b == -1) continue;
                int l = 0;
                Biome gen = Biome.func_150568_d((int)b);
                if (gen != null) {
                    l = type == 0 ? gen.func_180627_b((BlockPos)pos) : (type == 1 ? gen.func_180625_c((BlockPos)pos) : gen.getWaterColorMultiplier());
                }
                i += l >> 16 & 0xFF;
                j += l >> 8 & 0xFF;
                k += l & 0xFF;
                ++total;
            }
        }
        pos.func_181079_c(initX, pos.func_177956_o(), initZ);
        if (total == 0) {
            return 0;
        }
        return (i / total & 0xFF) << 16 | (j / total & 0xFF) << 8 | k / total & 0xFF;
    }

    public int getBiomeAtPos(BlockPos pos) {
        MapTile tile = MapProcessor.instance.getMapTile(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (tile != null && tile.isLoaded()) {
            return tile.getBlock(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF).getBiome();
        }
        return -1;
    }

    public boolean isGlowing(IBlockState state) {
        return (double)state.func_185906_d() >= 0.5;
    }

    public void loadPixel(World world, MapBlock pixel, MapBlock currentPixel, Chunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean canReuseBiomeColours) {
        pixel.prepareForWriting();
        pixel.setHeight(highY);
        this.overlayBuilder.startBuilding();
        int overlayBiome = -1;
        IBlockState prevOverlay = null;
        boolean underair = !cave;
        for (int h = highY; h >= lowY; --h) {
            this.mutableLocalPos.func_181079_c(insideX, h, insideZ);
            IBlockState state = bchunk.func_177435_g((BlockPos)this.mutableLocalPos);
            Block b = state.func_177230_c();
            if (b instanceof BlockAir) {
                underair = true;
                continue;
            }
            if (!underair) continue;
            int stateId = Block.func_176210_f((IBlockState)state);
            this.mutableGlobalPos.func_181079_c(bchunk.field_76635_g * 16 + insideX, h, bchunk.field_76647_h * 16 + insideZ);
            this.mutableLocalPos.func_181079_c(insideX, Math.min(h + 1, 255), insideZ);
            byte light = (byte)bchunk.func_177413_a(EnumSkyBlock.BLOCK, (BlockPos)this.mutableLocalPos);
            if (b instanceof BlockLiquid && b.getLightOpacity(state, (IBlockAccess)bchunk.func_177412_p(), (BlockPos)this.mutableGlobalPos) != 255 && b.getLightOpacity(state, (IBlockAccess)bchunk.func_177412_p(), (BlockPos)this.mutableGlobalPos) != 0 || b.func_180664_k() == BlockRenderLayer.TRANSLUCENT || b instanceof BlockGlass) {
                if (state != prevOverlay) {
                    if (canReuseBiomeColours && currentPixel != null && currentPixel.getNumberOfOverlays() > 0 && currentPixel.getOverlays().get(0).getState() == stateId) {
                        Overlay currentTopOverlay = currentPixel.getOverlays().get(0);
                        this.biomeBuffer[0] = currentTopOverlay.getColourType();
                        this.biomeBuffer[1] = currentTopOverlay.getColourType() == 1 ? currentPixel.getBiome() : -1;
                        this.biomeBuffer[2] = currentTopOverlay.getCustomColour();
                    } else {
                        this.getOverlayBiomeColour(world, state, (BlockPos)this.mutableGlobalPos, this.biomeBuffer);
                    }
                    if (overlayBiome == -1) {
                        overlayBiome = this.biomeBuffer[1];
                    }
                    prevOverlay = state;
                }
                this.overlayBuilder.build(stateId, this.biomeBuffer, b.getLightOpacity(state, (IBlockAccess)bchunk.func_177412_p(), (BlockPos)this.mutableGlobalPos), light, bchunk.func_177412_p());
                continue;
            }
            if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE || state.func_177230_c() == Blocks.field_150478_aa || state.func_177230_c() == Blocks.field_150329_H || state.func_177230_c() == Blocks.field_150398_cm || (state.func_177230_c() instanceof BlockFlower || state.func_177230_c() instanceof BlockDoublePlant) && !WorldMap.settings.flowers) continue;
            this.overlayBuilder.finishBuilding(pixel);
            if (!canReuseBiomeColours || currentPixel == null || currentPixel.getState() != stateId) {
                this.getBlockBiomeColour(world, state, (BlockPos)this.mutableGlobalPos, this.biomeBuffer);
            } else {
                this.biomeBuffer[0] = currentPixel.getColourType();
                this.biomeBuffer[1] = currentPixel.getBiome();
                this.biomeBuffer[2] = currentPixel.getCustomColour();
            }
            if (overlayBiome != -1) {
                this.biomeBuffer[1] = overlayBiome;
            }
            boolean glowing = this.isGlowing(state);
            pixel.write(stateId, h, this.biomeBuffer, light, glowing, cave);
            return;
        }
    }

    public void getBlockBiomeColour(World world, IBlockState state, BlockPos pos, int[] dest) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        int customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
        if (customColour != 0xFFFFFF && customColour != -1) {
            int grassColour = BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos);
            if (customColour == grassColour) {
                dest[0] = 1;
            } else {
                int foliageColour = BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos);
                if (customColour == foliageColour) {
                    dest[0] = 2;
                } else {
                    dest[0] = 3;
                    dest[2] = customColour;
                }
            }
            Biome biome = world.func_180494_b(pos);
            dest[1] = Biome.func_185362_a((Biome)biome);
        }
    }

    public void getOverlayBiomeColour(World world, IBlockState state, BlockPos pos, int[] dest) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        int customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
        if (customColour != 0xFFFFFF && customColour != -1) {
            int waterColour = BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)pos);
            if (customColour == waterColour) {
                dest[0] = 1;
                Biome biome = world.func_180494_b(pos);
                dest[1] = Biome.func_185362_a((Biome)biome);
            } else {
                dest[0] = 2;
                dest[2] = customColour;
            }
        }
    }

    public int loadBlockColourFromTexture(int stateId, boolean convert, World world, BlockPos globalPos) {
        if (this.clearCachedColours) {
            this.textureColours.clear();
            this.blockColours.clear();
            this.clearCachedColours = false;
            if (WorldMap.settings.debug) {
                System.out.println("Xaero's World Map cache cleared!");
            }
        }
        Integer c = this.blockColours.get(stateId);
        int red = 0;
        int green = 0;
        int blue = 0;
        IBlockState state = Misc.getStateById(stateId);
        Block b = state.func_177230_c();
        if (c == null) {
            String name = null;
            try {
                Integer cachedColour;
                List upQuads = null;
                BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
                if (convert) {
                    upQuads = bms.func_178125_b(state).func_188616_a(state, EnumFacing.UP, 0L);
                }
                TextureAtlasSprite texture = upQuads == null || upQuads.isEmpty() || ((BakedQuad)upQuads.get(0)).func_187508_a() == bms.func_178126_b().func_174952_b().func_174944_f() ? bms.func_178122_a(state) : ((BakedQuad)upQuads.get(0)).func_187508_a();
                name = texture.func_94215_i() + ".png";
                if (b instanceof BlockOre && b != Blocks.field_150449_bY) {
                    name = "minecraft:blocks/stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    MapWriter.DEFAULT_RESOURCE[1] = args[0];
                    args = DEFAULT_RESOURCE;
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
                    InputStream input = resource.func_110527_b();
                    BufferedImage img = TextureUtil.func_177053_a((InputStream)input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 64;
                    int tw = img.getWidth();
                    int diff = tw / 8;
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            int rgb = img.getRGB(i * diff, j * diff);
                            if (rgb == 0) {
                                --total;
                                continue;
                            }
                            red += rgb >> 16 & 0xFF;
                            green += rgb >> 8 & 0xFF;
                            blue += rgb & 0xFF;
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    c = 0xFF000000 | (red /= total) << 16 | (green /= total) << 8 | (blue /= total);
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(stateId, false, world, globalPos);
                }
                c = state.func_185909_g((IBlockAccess)world, (BlockPos)globalPos).field_76291_p;
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Block file not found: " + Block.field_149771_c.func_177774_c((Object)b));
            }
            catch (Exception e) {
                c = state.func_185909_g((IBlockAccess)world, (BlockPos)globalPos).field_76291_p;
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Block " + Block.field_149771_c.func_177774_c((Object)b) + " has no texture, using material colour.");
            }
            if (c != null) {
                this.blockColours.put(stateId, c);
            }
        }
        return c;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void resetCaveStart() {
        this.caveStart = -1;
    }

    public void resetPosition() {
        this.X = 0;
        this.Z = 0;
        this.insideX = 0;
        this.insideZ = 0;
    }

    public void requestCachedColoursClear() {
        this.clearCachedColours = true;
    }
}

