/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util.inventory;

import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class WrapperInventoryItemHandler
implements IItemHandler {
    private IInventory inventory;

    public WrapperInventoryItemHandler(IInventory inventory) {
        this.inventory = inventory;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (slot < 0 || slot > this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
        if (!this.inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.getStackInSlot(slot);
        int limit = Math.min(this.getSlotLimit(slot), stack.func_77976_d());
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStackInSlot(slot), (ItemStack)stack)) {
                return stack;
            }
            limit -= this.getStackInSlot(slot).func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (this.getStackInSlot(slot).func_190926_b()) {
                this.inventory.func_70299_a(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < 0 || slot > this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.getStackInSlot(slot);
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= amount) {
            if (!simulate) {
                this.inventory.func_70299_a(slot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.inventory.func_70299_a(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public int getSlots() {
        return this.inventory.func_70302_i_();
    }

    public int getSlotLimit(int slot) {
        return this.inventory.func_70297_j_();
    }
}

