/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.ThEPartModel;
import thaumicenergistics.item.part.ItemArcaneTerminal;
import thaumicenergistics.part.PartSharedTerminal;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.ItemHandlerUtil;
import thaumicenergistics.util.inventory.ThEInternalInventory;
import thaumicenergistics.util.inventory.ThEUpgradeInventory;

public class PartArcaneTerminal
extends PartSharedTerminal {
    public static ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("thaumicenergistics", "part/arcane_terminal/base"), new ResourceLocation("thaumicenergistics", "part/arcane_terminal/on"), new ResourceLocation("thaumicenergistics", "part/arcane_terminal/off"), new ResourceLocation("appliedenergistics2", "part/display_status_has_channel"), new ResourceLocation("appliedenergistics2", "part/display_status_on"), new ResourceLocation("appliedenergistics2", "part/display_status_off")};
    private static IPartModel MODEL_ON = new ThEPartModel(MODELS[0], MODELS[1], MODELS[4]);
    private static IPartModel MODEL_OFF = new ThEPartModel(MODELS[0], MODELS[2], MODELS[5]);
    private static IPartModel MODEL_HAS_CHANNEL = new ThEPartModel(MODELS[0], MODELS[1], MODELS[3]);
    public ThEInternalInventory craftingInventory = new ThEInternalInventory("matrix", 15, 64);
    public ThEInternalInventory upgradeInventory = new ThEUpgradeInventory("upgrades", 1, 1, this.getItemStack(PartItemStack.NETWORK));

    public PartArcaneTerminal(ItemArcaneTerminal item) {
        super(item);
        this.getConfigManager().registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.getConfigManager().registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.getConfigManager().registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equalsIgnoreCase("crafting")) {
            return new InvWrapper((IInventory)this.craftingInventory);
        }
        if (name.equalsIgnoreCase("upgrades")) {
            return new InvWrapper((IInventory)this.upgradeInventory);
        }
        return super.getInventoryByName(name);
    }

    @Override
    public void getDrops(List<ItemStack> list, boolean b) {
        super.getDrops(list, b);
        ItemHandlerUtil.getInventoryAsList(this.getInventoryByName("crafting"), list);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (ForgeUtil.isClient() || player.func_70093_af() && AEUtil.isWrench(player.func_184586_b(hand), player, this.getTile().func_174877_v())) {
            return false;
        }
        GuiHandler.openGUI(ModGUIs.ARCANE_TERMINAL, player, this.hostTile.func_174877_v(), this.side);
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("crafting", (NBTBase)this.craftingInventory.serializeNBT());
        tag.func_74782_a("upgrades", (NBTBase)this.upgradeInventory.serializeNBT());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.func_74764_b("crafting")) {
            this.craftingInventory.deserializeNBT(tag.func_150295_c("crafting", 10));
        }
        if (tag.func_74764_b("upgrades")) {
            this.upgradeInventory.deserializeNBT(tag.func_150295_c("upgrades", 10));
        }
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return MODEL_HAS_CHANNEL;
            }
            return MODEL_ON;
        }
        return MODEL_OFF;
    }
}

