/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.appeng;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IItemList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.util.MeaningfulEssentiaIterator;

public class EssentiaList
implements IItemList<IAEEssentiaStack> {
    private final Map<IAEEssentiaStack, IAEEssentiaStack> records = new HashMap<IAEEssentiaStack, IAEEssentiaStack>();

    public void addStorage(IAEEssentiaStack option) {
        if (option == null) {
            return;
        }
        IAEEssentiaStack st = this.getEssentiaRecord(option);
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        IAEEssentiaStack opt = (IAEEssentiaStack)option.copy();
        this.putEssentiaRecord(opt);
    }

    public void addCrafting(IAEEssentiaStack option) {
        if (option == null) {
            return;
        }
        IAEEssentiaStack st = this.getEssentiaRecord(option);
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        IAEEssentiaStack opt = (IAEEssentiaStack)option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(true);
        this.putEssentiaRecord(opt);
    }

    public void addRequestable(IAEEssentiaStack option) {
        if (option == null) {
            return;
        }
        IAEEssentiaStack st = this.getEssentiaRecord(option);
        if (st != null) {
            st.setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            return;
        }
        IAEEssentiaStack opt = (IAEEssentiaStack)option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(false);
        opt.setCountRequestable(option.getCountRequestable());
        this.putEssentiaRecord(opt);
    }

    public IAEEssentiaStack getFirstItem() {
        Iterator<IAEEssentiaStack> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEEssentiaStack stack = iterator.next();
            return stack;
        }
        return null;
    }

    public int size() {
        return this.records.values().size();
    }

    public Iterator<IAEEssentiaStack> iterator() {
        return new MeaningfulEssentiaIterator<IAEEssentiaStack>(this.records.values().iterator());
    }

    public void resetStatus() {
        Iterator<IAEEssentiaStack> iterator = this.iterator();
        while (iterator.hasNext()) {
            IAEEssentiaStack s = iterator.next();
            s.reset();
        }
    }

    public void add(IAEEssentiaStack option) {
        if (option == null) {
            return;
        }
        IAEEssentiaStack stack = this.getEssentiaRecord(option);
        if (stack != null) {
            stack.add(option);
            return;
        }
        IAEEssentiaStack opt = (IAEEssentiaStack)option.copy();
        this.putEssentiaRecord(opt);
    }

    public IAEEssentiaStack findPrecise(IAEEssentiaStack stack) {
        return stack == null ? null : this.getEssentiaRecord(stack);
    }

    public Collection<IAEEssentiaStack> findFuzzy(IAEEssentiaStack stack, FuzzyMode mode) {
        return stack == null ? Collections.emptyList() : Collections.singletonList(this.findPrecise(stack));
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    private IAEEssentiaStack getEssentiaRecord(IAEEssentiaStack stack) {
        return this.records.get(stack);
    }

    private IAEEssentiaStack putEssentiaRecord(IAEEssentiaStack stack) {
        return this.records.put(stack, stack);
    }
}

