/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.container.ActionType;
import thaumicenergistics.container.ContainerBase;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketInvHeldUpdate;
import thaumicenergistics.network.packets.PacketMEEssentiaUpdate;
import thaumicenergistics.network.packets.PacketUIAction;
import thaumicenergistics.part.PartEssentiaTerminal;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;

public class ContainerEssentiaTerminal
extends ContainerBase
implements IMEMonitorHandlerReceiver<IAEEssentiaStack> {
    private PartEssentiaTerminal part;
    private IMEMonitor<IAEEssentiaStack> monitor;

    public ContainerEssentiaTerminal(EntityPlayer player, PartEssentiaTerminal part) {
        super(player);
        this.part = part;
        if (ForgeUtil.isServer()) {
            this.monitor = this.part.getInventory(AEApi.instance().storage().getStorageChannel(IEssentiaStorageChannel.class));
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            }
        }
        this.bindPlayerInventory((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), 0, 138);
    }

    @Override
    public void onAction(EntityPlayerMP player, PacketUIAction packet) {
        InventoryPlayer inv = player.field_71071_by;
        if (packet.action == ActionType.FILL_ESSENTIA_ITEM && packet.requestedStack instanceof IAEEssentiaStack) {
            IAEEssentiaStack requestedStack = (IAEEssentiaStack)packet.requestedStack;
            ItemStack toFill = inv.func_70445_o().func_77946_l();
            ResourceLocation registryName = toFill.func_77973_b().getRegistryName();
            if (toFill.func_190926_b() || !(toFill.func_77973_b() instanceof IEssentiaContainerItem) || registryName == null) {
                return;
            }
            toFill.func_190920_e(1);
            IEssentiaContainerItem containerItem = (IEssentiaContainerItem)toFill.func_77973_b();
            int max = ThEApi.instance().config().essentiaContainerCapacity().getOrDefault(registryName.toString(), 0);
            if (max < 1 || containerItem.getAspects(toFill) != null && containerItem.getAspects(toFill).size() > 0) {
                return;
            }
            IAEEssentiaStack stack = (IAEEssentiaStack)this.monitor.extractItems((IAEStack)requestedStack, Actionable.SIMULATE, this.part.source);
            if (stack == null || stack.getStackSize() < (long)max) {
                return;
            }
            stack.setStackSize(max);
            containerItem.setAspects(toFill, new AspectList().add(stack.getAspect(), max));
            toFill.func_77964_b(1);
            boolean filledItem = false;
            if (inv.func_70445_o().func_190916_E() > 1) {
                if (inv.func_70441_a(toFill)) {
                    filledItem = true;
                    ItemStack held = inv.func_70445_o();
                    held.func_190920_e(held.func_190916_E() - 1);
                    inv.func_70437_b(held);
                    PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(held));
                }
            } else {
                player.field_71071_by.func_70437_b(toFill);
                filledItem = true;
                PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(toFill));
            }
            if (filledItem) {
                this.monitor.extractItems((IAEStack)stack, Actionable.MODULATE, this.part.source);
            }
        } else if (packet.action == ActionType.EMPTY_ESSENTIA_ITEM) {
            ItemStack toEmpty = inv.func_70445_o().func_77946_l();
            ResourceLocation registryName = toEmpty.func_77973_b().getRegistryName();
            if (toEmpty.func_190926_b() || !(toEmpty.func_77973_b() instanceof IEssentiaContainerItem) || registryName == null) {
                return;
            }
            IEssentiaContainerItem containerItem = (IEssentiaContainerItem)toEmpty.func_77973_b();
            AspectList list = containerItem.getAspects(toEmpty);
            if (list == null || list.size() < 1 || ThEApi.instance().config().essentiaContainerCapacity().getOrDefault(registryName.toString(), 0) < 1) {
                return;
            }
            AtomicBoolean canInsert = new AtomicBoolean(true);
            list.aspects.forEach((aspect, amount) -> {
                IAEEssentiaStack stack = (IAEEssentiaStack)this.monitor.injectItems((IAEStack)AEUtil.getAEStackFromAspect(aspect, amount), Actionable.SIMULATE, this.part.source);
                if (stack != null && stack.getStackSize() > 0L) {
                    canInsert.set(false);
                }
            });
            if (!canInsert.get()) {
                return;
            }
            if (toEmpty.func_190916_E() > 1) {
                toEmpty.func_190920_e(1);
                toEmpty.func_77982_d(null);
                toEmpty.func_77964_b(0);
                if (!inv.func_70441_a(toEmpty)) {
                    return;
                }
                ItemStack held = inv.func_70445_o();
                held.func_190920_e(held.func_190916_E() - 1);
                inv.func_70437_b(held);
                PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(held));
            } else {
                toEmpty.func_77982_d(null);
                toEmpty.func_77964_b(0);
                inv.func_70437_b(toEmpty);
                PacketHandler.sendToPlayer(player, new PacketInvHeldUpdate(toEmpty));
            }
            list.aspects.forEach((aspect, amount) -> {
                IAEEssentiaStack cfr_ignored_0 = (IAEEssentiaStack)this.monitor.injectItems((IAEStack)AEUtil.getAEStackFromAspect(aspect, amount), Actionable.MODULATE, this.part.source);
            });
        }
        super.onAction(player, packet);
    }

    public boolean isValid(Object o) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEEssentiaStack> iBaseMonitor, Iterable<IAEEssentiaStack> iterable, IActionSource iActionSource) {
        for (IContainerListener c : this.field_75149_d) {
            this.sendInventory(c);
        }
    }

    public void onListUpdate() {
        for (IContainerListener c : this.field_75149_d) {
            this.sendInventory(c);
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.sendInventory(listener);
    }

    private void sendInventory(IContainerListener listener) {
        if (ForgeUtil.isClient() || !(listener instanceof EntityPlayer) || this.monitor == null) {
            return;
        }
        IItemList storage = this.monitor.getStorageList();
        PacketMEEssentiaUpdate packet = new PacketMEEssentiaUpdate();
        for (IAEEssentiaStack stack : storage) {
            packet.appendStack(stack);
        }
        PacketHandler.sendToPlayer((EntityPlayerMP)listener, packet);
    }
}

