/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.transformation;

import com.creativemd.littletiles.common.entity.EntityDoorAnimation;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.transformation.DoorTransformation;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class SlidingDoorTransformation
extends DoorTransformation {
    public EnumFacing direction;
    public int distance;
    public LittleGridContext context;

    public SlidingDoorTransformation() {
    }

    public SlidingDoorTransformation(EnumFacing direction, LittleGridContext context, int distance) {
        this.direction = direction;
        this.distance = distance;
        this.context = context;
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("direction", this.direction.ordinal());
        nbt.func_74768_a("distance", this.distance);
        this.context.set(nbt);
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        this.direction = EnumFacing.func_82600_a((int)nbt.func_74762_e("direction"));
        this.distance = nbt.func_74762_e("distance");
        this.context = LittleGridContext.get(nbt);
    }

    @Override
    public void performTransformation(EntityDoorAnimation animation, double progress) {
        double pushDistance = (double)this.distance * this.context.gridMCLength * (1.0 - progress);
        switch (this.direction) {
            case EAST: {
                animation.moveXTo((double)animation.getAxisPos().func_177958_n() - pushDistance);
                break;
            }
            case WEST: {
                animation.moveXTo((double)animation.getAxisPos().func_177958_n() + pushDistance);
                break;
            }
            case UP: {
                animation.moveYTo((double)animation.getAxisPos().func_177956_o() - pushDistance);
                break;
            }
            case DOWN: {
                animation.moveYTo((double)animation.getAxisPos().func_177956_o() + pushDistance);
                break;
            }
            case SOUTH: {
                animation.moveZTo((double)animation.getAxisPos().func_177952_p() - pushDistance);
                break;
            }
            case NORTH: {
                animation.moveZTo((double)animation.getAxisPos().func_177952_p() + pushDistance);
                break;
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SlidingDoorTransformation) {
            return ((SlidingDoorTransformation)object).direction == this.direction && ((SlidingDoorTransformation)object).distance == this.distance && ((SlidingDoorTransformation)object).context == this.context;
        }
        return false;
    }
}

