/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.ColorUnit;
import java.util.List;

public class CombinedIngredients {
    public final ColorUnit color;
    public final BlockIngredient.BlockIngredients block;

    public CombinedIngredients() {
        this(new ColorUnit(), new BlockIngredient.BlockIngredients());
    }

    public CombinedIngredients(ColorUnit color, BlockIngredient.BlockIngredients block) {
        this.color = color;
        this.block = block;
    }

    public void addPreview(LittleGridContext context, List<LittleTilePreview> previews) {
        for (LittleTilePreview preview : previews) {
            this.addPreview(context, preview);
        }
    }

    public void addPreview(LittleGridContext context, LittleTilePreview preview) {
        if (preview.canBeConvertedToBlockEntry()) {
            this.block.addIngredient(preview.getBlockIngredient(context));
            this.color.addColorUnit(ColorUnit.getColors(context, preview));
        }
    }

    public void addPreview(LittleTilePreview preview, double volume) {
        if (preview.canBeConvertedToBlockEntry()) {
            BlockIngredient ingredient = preview.getBlockIngredient(LittleGridContext.get());
            ingredient.value = volume;
            this.block.addIngredient(ingredient);
            this.color.addColorUnit(ColorUnit.getColors(preview, volume));
        }
    }
}

