/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.creativecore.common.utils.mc.ChatFormatting;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import net.minecraft.util.text.translation.I18n;

public class ColorUnit {
    public int BLACK;
    public int CYAN;
    public int MAGENTA;
    public int YELLOW;
    public static float dyeToBlockPercentage = 4096.0f;

    public ColorUnit() {
        this.BLACK = 0;
        this.CYAN = 0;
        this.MAGENTA = 0;
        this.YELLOW = 0;
    }

    public ColorUnit(int[] array) {
        if (array.length != 4) {
            throw new IllegalArgumentException("Invalid array " + array + "!");
        }
        this.BLACK = array[0];
        this.CYAN = array[1];
        this.MAGENTA = array[2];
        this.YELLOW = array[3];
    }

    public ColorUnit(int black, int cyan, int magenta, int yellow) {
        this.BLACK = black;
        this.CYAN = cyan;
        this.MAGENTA = magenta;
        this.YELLOW = yellow;
    }

    public int[] getArray() {
        return new int[]{this.BLACK, this.CYAN, this.MAGENTA, this.YELLOW};
    }

    private static String getUnit(int number) {
        if (number == 1) {
            return I18n.func_74838_a((String)"color.unit.single");
        }
        return I18n.func_74838_a((String)"color.unit.multiple");
    }

    public String getBlackDescription() {
        return this.BLACK + " " + ChatFormatting.DARK_GRAY + I18n.func_74838_a((String)"color.unit.black") + ChatFormatting.WHITE + " " + ColorUnit.getUnit(this.BLACK);
    }

    public String getCyanDescription() {
        return this.CYAN + " " + ChatFormatting.AQUA + I18n.func_74838_a((String)"color.unit.cyan") + ChatFormatting.WHITE + " " + ColorUnit.getUnit(this.CYAN);
    }

    public String getMagentaDescription() {
        return this.MAGENTA + " " + ChatFormatting.LIGHT_PURPLE + I18n.func_74838_a((String)"color.unit.magenta") + ChatFormatting.WHITE + " " + ColorUnit.getUnit(this.MAGENTA);
    }

    public String getYellowDescription() {
        return this.YELLOW + " " + ChatFormatting.YELLOW + I18n.func_74838_a((String)"color.unit.yellow") + ChatFormatting.WHITE + " " + ColorUnit.getUnit(this.YELLOW);
    }

    public String getDescription() {
        String description = "";
        if (this.BLACK > 0) {
            description = description + this.getBlackDescription();
        }
        if (this.CYAN > 0) {
            description = description + this.getCyanDescription();
        }
        if (this.MAGENTA > 0) {
            description = description + this.getMagentaDescription();
        }
        if (this.YELLOW > 0) {
            description = description + this.getYellowDescription();
        }
        return description;
    }

    public String toString() {
        return "[back=" + this.BLACK + ",cyan=" + this.CYAN + ",magenta=" + this.MAGENTA + ",yellow=" + this.YELLOW + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColorUnit) {
            return this.BLACK == ((ColorUnit)obj).BLACK && this.CYAN == ((ColorUnit)obj).CYAN && this.MAGENTA == ((ColorUnit)obj).MAGENTA && this.YELLOW == ((ColorUnit)obj).YELLOW;
        }
        return false;
    }

    public int hashCode() {
        return this.BLACK + this.CYAN + this.MAGENTA + this.YELLOW;
    }

    public void scale(double scale) {
        this.BLACK = (int)Math.ceil((double)this.BLACK * scale);
        this.CYAN = (int)Math.ceil((double)this.CYAN * scale);
        this.MAGENTA = (int)Math.ceil((double)this.MAGENTA * scale);
        this.YELLOW = (int)Math.ceil((double)this.YELLOW * scale);
    }

    public void scaleLoose(double scale) {
        this.BLACK = (int)Math.floor((double)this.BLACK * scale);
        this.CYAN = (int)Math.floor((double)this.CYAN * scale);
        this.MAGENTA = (int)Math.floor((double)this.MAGENTA * scale);
        this.YELLOW = (int)Math.floor((double)this.YELLOW * scale);
    }

    public void subColorUnit(ColorUnit unit) {
        if (unit == null) {
            return;
        }
        this.BLACK -= unit.BLACK;
        this.CYAN -= unit.CYAN;
        this.MAGENTA -= unit.MAGENTA;
        this.YELLOW -= unit.YELLOW;
    }

    public void addColorUnit(ColorUnit unit) {
        if (unit == null) {
            return;
        }
        this.BLACK += unit.BLACK;
        this.CYAN += unit.CYAN;
        this.MAGENTA += unit.MAGENTA;
        this.YELLOW += unit.YELLOW;
    }

    public ColorUnit copy() {
        return new ColorUnit(this.BLACK, this.CYAN, this.MAGENTA, this.YELLOW);
    }

    public static ColorUnit getColors(LittleTilePreview preview, double volume) {
        if (preview.hasColor()) {
            ColorUnit color = ColorUnit.getColors(preview.getColor());
            color.scale(volume);
            return color;
        }
        return null;
    }

    public static ColorUnit getColors(LittleGridContext context, LittleTilePreview preview) {
        return ColorUnit.getColors(preview, preview.getPercentVolume(context));
    }

    public static ColorUnit getColors(int color) {
        float cmyk_scale = dyeToBlockPercentage;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (r == 0 && g == 0 && b == 0) {
            return new ColorUnit((int)cmyk_scale, 0, 0, 0);
        }
        float c = 1.0f - (float)r / 255.0f;
        float m = 1.0f - (float)g / 255.0f;
        float y = 1.0f - (float)b / 255.0f;
        float min_cmy = Math.min(c, Math.min(m, y));
        c = (c - min_cmy) / (1.0f - min_cmy);
        m = (m - min_cmy) / (1.0f - min_cmy);
        y = (y - min_cmy) / (1.0f - min_cmy);
        float k = min_cmy;
        return new ColorUnit((int)(k * cmyk_scale), (int)(c * cmyk_scale), (int)(m * cmyk_scale), (int)(y * cmyk_scale));
    }

    public boolean isEmpty() {
        return this.BLACK == 0 && this.CYAN == 0 && this.MAGENTA == 0 && this.YELLOW == 0;
    }

    public void drain(ColorUnit toDrain) {
        int drain = Math.min(this.BLACK, toDrain.BLACK);
        this.BLACK -= drain;
        toDrain.BLACK -= drain;
        drain = Math.min(this.CYAN, toDrain.CYAN);
        this.CYAN -= drain;
        toDrain.CYAN -= drain;
        drain = Math.min(this.MAGENTA, toDrain.MAGENTA);
        this.MAGENTA -= drain;
        toDrain.MAGENTA -= drain;
        drain = Math.min(this.YELLOW, toDrain.YELLOW);
        this.YELLOW -= drain;
        toDrain.YELLOW -= drain;
    }
}

