/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.animation;

import com.creativemd.littletiles.common.utils.animation.AnimationState;
import javax.annotation.Nullable;

public abstract class Animation {
    public final long duration;
    protected long tick;
    protected boolean done = false;

    public Animation(long duration) {
        this.duration = duration;
    }

    public boolean tick(Animation parent, AnimationState currentState) {
        if (!this.isDone()) {
            if (this.tick == 0L) {
                this.begin(currentState);
            } else {
                this.tick(currentState);
            }
            ++this.tick;
            return true;
        }
        if (!this.done) {
            this.end(currentState);
            this.done = true;
        }
        return false;
    }

    public void begin(AnimationState currentState) {
        this.tick(currentState);
    }

    public abstract void tick(AnimationState var1);

    public abstract void end(AnimationState var1);

    public long progress() {
        return this.tick;
    }

    public void setProgress(long tick, @Nullable AnimationState currentState) {
        this.tick = tick;
        if (currentState != null) {
            this.tick(currentState);
        }
    }

    public boolean isDone() {
        return this.tick >= this.duration;
    }
}

