/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec.advanced;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.creativecore.common.utils.math.vec.Ray2d;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.client.tiles.LittleSlicedRenderingCube;
import com.creativemd.littletiles.common.tiles.combine.BasicCombiner;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleUtils;
import com.creativemd.littletiles.common.tiles.vec.advanced.AxisAlignedBBOrdinarySliced;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleSlice;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleTileSlicedOrdinaryBox;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTileSlicedBox
extends LittleTileSlicedOrdinaryBox {
    public float startOne;
    public float startTwo;
    public float endOne;
    public float endTwo;

    public LittleTileSlicedBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, LittleSlice slice, float startOne, float startTwo, float endOne, float endTwo) {
        super(minX, minY, minZ, maxX, maxY, maxZ, slice);
        this.startOne = startOne;
        this.startTwo = startTwo;
        this.endOne = endOne;
        this.endTwo = endTwo;
    }

    public LittleTileSlicedBox(LittleTileBox box, LittleSlice slice, float startOne, float startTwo, float endOne, float endTwo) {
        this(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, slice, startOne, startTwo, endOne, endTwo);
    }

    @Override
    public void addCollisionBoxes(LittleGridContext context, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, BlockPos offset) {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        Vector3d min = new Vector3d((double)this.minX, (double)this.minY, (double)this.minZ);
        Vector3d max = new Vector3d((double)this.maxX, (double)this.maxY, (double)this.maxZ);
        RotationUtils.setValue((Tuple3d)min, (double)this.getMinSlice(one), (EnumFacing.Axis)one);
        RotationUtils.setValue((Tuple3d)min, (double)this.getMinSlice(two), (EnumFacing.Axis)two);
        RotationUtils.setValue((Tuple3d)max, (double)this.getMaxSlice(one), (EnumFacing.Axis)one);
        RotationUtils.setValue((Tuple3d)max, (double)this.getMaxSlice(two), (EnumFacing.Axis)two);
        AxisAlignedBBOrdinarySliced bb = new AxisAlignedBBOrdinarySliced(context.toVanillaGrid(min.x) + (double)offset.func_177958_n(), context.toVanillaGrid(min.y) + (double)offset.func_177956_o(), context.toVanillaGrid(min.z) + (double)offset.func_177952_p(), context.toVanillaGrid(max.x) + (double)offset.func_177958_n(), context.toVanillaGrid(max.y) + (double)offset.func_177956_o(), context.toVanillaGrid(max.z) + (double)offset.func_177952_p(), this.slice);
        if (entityBox.func_72326_a((AxisAlignedBB)bb)) {
            collidingBoxes.add((AxisAlignedBB)bb);
        }
        boolean boxTwo = this.hasAdditionalBoxTwo();
        if (this.hasAdditionalBoxOne()) {
            if (this.slice.isFacingPositive(one)) {
                RotationUtils.setValue((Tuple3d)min, (double)this.getMin(one), (EnumFacing.Axis)one);
                RotationUtils.setValue((Tuple3d)max, (double)this.getMinSlice(one), (EnumFacing.Axis)one);
            } else {
                RotationUtils.setValue((Tuple3d)min, (double)this.getMaxSlice(one), (EnumFacing.Axis)one);
                RotationUtils.setValue((Tuple3d)max, (double)this.getMax(one), (EnumFacing.Axis)one);
            }
            if (this.slice.isFacingPositive(two)) {
                RotationUtils.setValue((Tuple3d)min, (double)(boxTwo ? (double)this.getMin(two) : this.getMinSlice(two)), (EnumFacing.Axis)two);
                RotationUtils.setValue((Tuple3d)max, (double)this.getMaxSlice(two), (EnumFacing.Axis)two);
            } else {
                RotationUtils.setValue((Tuple3d)min, (double)this.getMinSlice(two), (EnumFacing.Axis)two);
                RotationUtils.setValue((Tuple3d)max, (double)(boxTwo ? (double)this.getMax(two) : this.getMaxSlice(two)), (EnumFacing.Axis)two);
            }
            bb = new AxisAlignedBB(context.toVanillaGrid(min.x) + (double)offset.func_177958_n(), context.toVanillaGrid(min.y) + (double)offset.func_177956_o(), context.toVanillaGrid(min.z) + (double)offset.func_177952_p(), context.toVanillaGrid(max.x) + (double)offset.func_177958_n(), context.toVanillaGrid(max.y) + (double)offset.func_177956_o(), context.toVanillaGrid(max.z) + (double)offset.func_177952_p());
            if (entityBox.func_72326_a((AxisAlignedBB)bb)) {
                collidingBoxes.add((AxisAlignedBB)bb);
            }
        }
        if (boxTwo) {
            if (this.slice.isFacingPositive(one)) {
                RotationUtils.setValue((Tuple3d)min, (double)this.getMinSlice(one), (EnumFacing.Axis)one);
                RotationUtils.setValue((Tuple3d)max, (double)this.getMaxSlice(one), (EnumFacing.Axis)one);
            } else {
                RotationUtils.setValue((Tuple3d)min, (double)this.getMinSlice(one), (EnumFacing.Axis)one);
                RotationUtils.setValue((Tuple3d)max, (double)this.getMaxSlice(one), (EnumFacing.Axis)one);
            }
            if (this.slice.isFacingPositive(two)) {
                RotationUtils.setValue((Tuple3d)min, (double)this.getMin(two), (EnumFacing.Axis)two);
                RotationUtils.setValue((Tuple3d)max, (double)this.getMinSlice(two), (EnumFacing.Axis)two);
            } else {
                RotationUtils.setValue((Tuple3d)min, (double)this.getMaxSlice(two), (EnumFacing.Axis)two);
                RotationUtils.setValue((Tuple3d)max, (double)this.getMax(two), (EnumFacing.Axis)two);
            }
            bb = new AxisAlignedBB(context.toVanillaGrid(min.x) + (double)offset.func_177958_n(), context.toVanillaGrid(min.y) + (double)offset.func_177956_o(), context.toVanillaGrid(min.z) + (double)offset.func_177952_p(), context.toVanillaGrid(max.x) + (double)offset.func_177958_n(), context.toVanillaGrid(max.y) + (double)offset.func_177956_o(), context.toVanillaGrid(max.z) + (double)offset.func_177952_p());
            if (entityBox.func_72326_a((AxisAlignedBB)bb)) {
                collidingBoxes.add((AxisAlignedBB)bb);
            }
        }
    }

    @Override
    public int[] getArray() {
        return new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.slice.getSliceID(), Float.floatToIntBits(this.startOne), Float.floatToIntBits(this.startTwo), Float.floatToIntBits(this.endOne), Float.floatToIntBits(this.endTwo)};
    }

    @Override
    public void convertTo(LittleGridContext from, LittleGridContext to) {
        super.convertTo(from, to);
        if (from.size > to.size) {
            int ratio = from.size / to.size;
            this.startOne /= (float)ratio;
            this.startTwo /= (float)ratio;
            this.endOne /= (float)ratio;
            this.endTwo /= (float)ratio;
        } else {
            int ratio = to.size / from.size;
            this.startOne *= (float)ratio;
            this.startTwo *= (float)ratio;
            this.endOne *= (float)ratio;
            this.endTwo *= (float)ratio;
        }
    }

    @Override
    public void convertTo(int from, int to) {
        super.convertTo(from, to);
        if (from > to) {
            int ratio = from / to;
            this.startOne /= (float)ratio;
            this.startTwo /= (float)ratio;
            this.endOne /= (float)ratio;
            this.endTwo /= (float)ratio;
        } else {
            int ratio = to / from;
            this.startOne *= (float)ratio;
            this.startTwo *= (float)ratio;
            this.endOne *= (float)ratio;
            this.endTwo *= (float)ratio;
        }
    }

    @Override
    public double getVolume() {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        return (double)this.getSize(this.slice.axis) * (this.slice.isFacingPositive(one) ? this.getMaxSlice(one) - (double)this.getMin(one) : (double)this.getMax(one) - this.getMinSlice(one)) * (this.slice.isFacingPositive(two) ? this.getMaxSlice(two) - (double)this.getMin(two) : (double)this.getMax(two) - this.getMinSlice(two)) - (double)(Math.abs(this.startOne - this.endOne) * Math.abs(this.startTwo - this.endTwo) * (float)this.getSize(this.slice.axis)) / 2.0;
    }

    @Override
    public Vec3d getExactCorner(BoxUtils.BoxCorner corner) {
        return new Vec3d(this.slice.isFacingPositive(EnumFacing.Axis.X) == corner.isFacingPositive(EnumFacing.Axis.X) ? this.getSliceCornerValue(corner, EnumFacing.Axis.X) : (double)this.getCornerX(corner), this.slice.isFacingPositive(EnumFacing.Axis.Y) == corner.isFacingPositive(EnumFacing.Axis.Y) ? this.getSliceCornerValue(corner, EnumFacing.Axis.Y) : (double)this.getCornerY(corner), this.slice.isFacingPositive(EnumFacing.Axis.Z) == corner.isFacingPositive(EnumFacing.Axis.Z) ? this.getSliceCornerValue(corner, EnumFacing.Axis.Z) : (double)this.getCornerZ(corner));
    }

    @Override
    public LittleTileBox createOutsideBlockBox(LittleGridContext context, EnumFacing facing) {
        if (facing == this.slice.emptySideOne || facing == this.slice.emptySideTwo) {
            return null;
        }
        if (facing.func_176740_k() == this.slice.axis) {
            LittleTileSlicedBox box = this.copy();
            switch (facing) {
                case EAST: {
                    box.minX = 0;
                    box.maxX -= context.size;
                    break;
                }
                case WEST: {
                    box.minX += context.size;
                    box.maxX = context.size;
                    break;
                }
                case UP: {
                    box.minY = 0;
                    box.maxY -= context.size;
                    break;
                }
                case DOWN: {
                    box.minY += context.size;
                    box.maxY = context.size;
                    break;
                }
                case SOUTH: {
                    box.minZ = 0;
                    box.maxZ -= context.size;
                    break;
                }
                case NORTH: {
                    box.minZ += context.size;
                    box.maxZ = context.size;
                }
            }
            return box;
        }
        return super.createOutsideBlockBox(context, facing);
    }

    @Override
    public LittleTileBox combineBoxes(LittleTileBox box, BasicCombiner combiner) {
        if (box instanceof LittleTileSlicedOrdinaryBox && ((LittleTileSlicedOrdinaryBox)box).slice == this.slice) {
            EnumFacing.Axis two;
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            if (!LittleUtils.equals(this.getSliceAngle(one, two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis)), ((LittleTileSlicedOrdinaryBox)box).getSliceAngle(one, two))) {
                return null;
            }
            EnumFacing facing = this.sharedBoxFace(box);
            if (facing != null) {
                boolean facePositive;
                EnumFacing.Axis axis = facing.func_176740_k();
                if (((LittleTileSlicedOrdinaryBox)box).isOrdinary()) {
                    return null;
                }
                if (axis == this.slice.axis) {
                    LittleTileSlicedBox slicedBox = (LittleTileSlicedBox)box;
                    if (!(LittleUtils.equals(this.getMaxSlice(one), slicedBox.getMaxSlice(one)) && LittleUtils.equals(this.getMinSlice(one), slicedBox.getMinSlice(one)) && LittleUtils.equals(this.getMaxSlice(two), slicedBox.getMaxSlice(two)) && LittleUtils.equals(this.getMinSlice(two), slicedBox.getMinSlice(two)))) {
                        return null;
                    }
                    LittleTileSlicedBox newBox = this.copy();
                    if (facing.func_176743_c() != EnumFacing.AxisDirection.POSITIVE) {
                        newBox.setMax(this.slice.axis, box.getMax(this.slice.axis));
                    } else {
                        newBox.setMin(this.slice.axis, box.getMin(this.slice.axis));
                    }
                    return newBox;
                }
                LittleTileSlicedBox sliceBox = (LittleTileSlicedBox)box;
                EnumFacing.Axis other = axis == one ? two : one;
                boolean bl = facePositive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                if (!facePositive ? LittleUtils.equals(this.getMaxSlice(axis), sliceBox.getMinSlice(axis)) : LittleUtils.equals(this.getMinSlice(axis), sliceBox.getMaxSlice(axis))) {
                    if (this.slice.start.isFacingPositive(axis) == facePositive ? !LittleUtils.equals(facePositive ? this.getStart(other) : this.getEnd(other), !facePositive ? sliceBox.getStart(other) : sliceBox.getEnd(other)) : !LittleUtils.equals(!facePositive ? this.getStart(other) : this.getEnd(other), facePositive ? sliceBox.getStart(other) : sliceBox.getEnd(other))) {
                        return null;
                    }
                    double startOne = this.slice.start.isFacingPositive(one) ? Math.max(this.getMaxSlice(one), sliceBox.getMaxSlice(one)) : Math.min(this.getMinSlice(one), sliceBox.getMinSlice(one));
                    double startTwo = this.slice.start.isFacingPositive(two) ? Math.max(this.getMaxSlice(two), sliceBox.getMaxSlice(two)) : Math.min(this.getMinSlice(two), sliceBox.getMinSlice(two));
                    double endOne = this.slice.end.isFacingPositive(one) ? Math.max(this.getMaxSlice(one), sliceBox.getMaxSlice(one)) : Math.min(this.getMinSlice(one), sliceBox.getMinSlice(one));
                    double endTwo = this.slice.end.isFacingPositive(two) ? Math.max(this.getMaxSlice(two), sliceBox.getMaxSlice(two)) : Math.min(this.getMinSlice(two), sliceBox.getMinSlice(two));
                    LittleTileSlicedBox newBox = this.copy();
                    newBox.minX = Math.min(newBox.minX, box.minX);
                    newBox.minY = Math.min(newBox.minY, box.minY);
                    newBox.minZ = Math.min(newBox.minZ, box.minZ);
                    newBox.maxX = Math.max(newBox.maxX, box.maxX);
                    newBox.maxY = Math.max(newBox.maxY, box.maxY);
                    newBox.maxZ = Math.max(newBox.maxZ, box.maxZ);
                    newBox.startOne = (float)(startOne - (double)newBox.getMin(one));
                    newBox.startTwo = (float)(startTwo - (double)newBox.getMin(two));
                    newBox.endOne = (float)(endOne - (double)newBox.getMin(one));
                    newBox.endTwo = (float)(endTwo - (double)newBox.getMin(two));
                    if (newBox.getMinSlice(one) == 0.0 && newBox.getMinSlice(two) == 0.0 && newBox.getMaxSlice(one) == (double)newBox.getSize(one) && newBox.getMaxSlice(two) == (double)newBox.getSize(two)) {
                        return new LittleTileSlicedOrdinaryBox((LittleTileBox)newBox, this.slice);
                    }
                    return newBox;
                }
                return null;
            }
            if (this.getMin(this.slice.axis) == box.getMin(this.slice.axis) && this.getMax(this.slice.axis) == box.getMax(this.slice.axis)) {
                LittleTileSlicedOrdinaryBox slicedBox = (LittleTileSlicedOrdinaryBox)box;
                double minSliceOne = slicedBox.isOrdinary() ? (double)slicedBox.getMin(one) : ((LittleTileSlicedBox)slicedBox).getMinSlice(one);
                double minSliceTwo = slicedBox.isOrdinary() ? (double)slicedBox.getMin(two) : ((LittleTileSlicedBox)slicedBox).getMinSlice(two);
                double maxSliceOne = slicedBox.isOrdinary() ? (double)slicedBox.getMax(one) : ((LittleTileSlicedBox)slicedBox).getMaxSlice(one);
                double maxSliceTwo = slicedBox.isOrdinary() ? (double)slicedBox.getMax(two) : ((LittleTileSlicedBox)slicedBox).getMaxSlice(two);
                boolean shareOnePostive = LittleUtils.equals(this.getMaxSlice(one), minSliceOne);
                boolean shareOneNegative = LittleUtils.equals(this.getMinSlice(one), maxSliceOne);
                boolean shareTwoPostive = LittleUtils.equals(this.getMaxSlice(two), minSliceTwo);
                boolean shareTwoNegative = LittleUtils.equals(this.getMinSlice(two), maxSliceTwo);
                if (shareOnePostive ^ shareOneNegative && shareTwoPostive ^ shareTwoNegative) {
                    boolean postiveOne = this.slice.isFacingPositive(one);
                    boolean postiveTwo = this.slice.isFacingPositive(two);
                    if (postiveOne == shareOnePostive && postiveTwo == shareTwoPostive || postiveOne != shareOnePostive && postiveTwo != shareTwoPostive) {
                        return null;
                    }
                    LittleTileBox boxInBetween = new LittleTileBox(this);
                    if (shareOnePostive != postiveOne) {
                        boxInBetween.setMin(one, box.getMin(one));
                        boxInBetween.setMax(one, box.getMax(one));
                    } else if (shareOnePostive) {
                        boxInBetween.setMax(one, box.getMin(one));
                    } else {
                        boxInBetween.setMin(one, box.getMax(one));
                    }
                    if (shareTwoPostive != postiveTwo) {
                        boxInBetween.setMin(two, box.getMin(two));
                        boxInBetween.setMax(two, box.getMax(two));
                    } else if (shareTwoPostive) {
                        boxInBetween.setMax(two, box.getMin(two));
                    } else {
                        boxInBetween.setMin(two, box.getMax(two));
                    }
                    if (combiner.cutOut(boxInBetween)) {
                        LittleTileSlicedBox newBox = this.copy();
                        newBox.minX = Math.min(newBox.minX, box.minX);
                        newBox.minY = Math.min(newBox.minY, box.minY);
                        newBox.minZ = Math.min(newBox.minZ, box.minZ);
                        newBox.maxX = Math.max(newBox.maxX, box.maxX);
                        newBox.maxY = Math.max(newBox.maxY, box.maxY);
                        newBox.maxZ = Math.max(newBox.maxZ, box.maxZ);
                        double startOne = this.slice.start.isFacingPositive(one) ? Math.max(this.getMaxSlice(one), maxSliceOne) : Math.min(this.getMinSlice(one), minSliceOne);
                        double startTwo = this.slice.start.isFacingPositive(two) ? Math.max(this.getMaxSlice(two), maxSliceTwo) : Math.min(this.getMinSlice(two), minSliceTwo);
                        double endOne = this.slice.end.isFacingPositive(one) ? Math.max(this.getMaxSlice(one), maxSliceOne) : Math.min(this.getMinSlice(one), minSliceOne);
                        double endTwo = this.slice.end.isFacingPositive(two) ? Math.max(this.getMaxSlice(two), maxSliceTwo) : Math.min(this.getMinSlice(two), minSliceTwo);
                        newBox.startOne = (float)(startOne - (double)newBox.getMin(one));
                        newBox.startTwo = (float)(startTwo - (double)newBox.getMin(two));
                        newBox.endOne = (float)(endOne - (double)newBox.getMin(one));
                        newBox.endTwo = (float)(endTwo - (double)newBox.getMin(two));
                        if (newBox.getMinSlice(one) == 0.0 && newBox.getMinSlice(two) == 0.0 && newBox.getMaxSlice(one) == (double)newBox.getSize(one) && newBox.getMaxSlice(two) == (double)newBox.getSize(two)) {
                            return new LittleTileSlicedOrdinaryBox((LittleTileBox)newBox, this.slice);
                        }
                        return newBox;
                    }
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public EnumFacing sharedBoxFace(LittleTileBox box) {
        boolean z;
        boolean y;
        boolean x;
        boolean bl = this.slice.axis == EnumFacing.Axis.X ? this.minX == box.minX && this.maxX == box.maxX : (this.slice.isFacingPositive(EnumFacing.Axis.X) ? this.minX == box.minX : (x = this.maxX == box.maxX));
        boolean bl2 = this.slice.axis == EnumFacing.Axis.Y ? this.minY == box.minY && this.maxY == box.maxY : (this.slice.isFacingPositive(EnumFacing.Axis.Y) ? this.minY == box.minY : (y = this.maxY == box.maxY));
        boolean bl3 = this.slice.axis == EnumFacing.Axis.Z ? this.minZ == box.minZ && this.maxZ == box.maxZ : (this.slice.isFacingPositive(EnumFacing.Axis.Z) ? this.minZ == box.minZ : (z = this.maxZ == box.maxZ));
        if (x && y && z) {
            return null;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return EnumFacing.SOUTH;
            }
            if (this.maxZ == box.minZ) {
                return EnumFacing.NORTH;
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return EnumFacing.UP;
            }
            if (this.maxY == box.minY) {
                return EnumFacing.DOWN;
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return EnumFacing.EAST;
            }
            if (this.maxX == box.minX) {
                return EnumFacing.WEST;
            }
        }
        return null;
    }

    @Override
    public boolean isVecInsideBoxNoEdge(Vec3d vec) {
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        if (x >= (double)this.minX && x < (double)this.maxX && y >= (double)this.minY && y < (double)this.maxY && z >= (double)this.minZ && z < (double)this.maxZ) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            double posOne = RotationUtils.get((EnumFacing.Axis)one, (double)x, (double)y, (double)z);
            double posTwo = RotationUtils.get((EnumFacing.Axis)two, (double)x, (double)y, (double)z);
            if (this.slice.isFacingPositive(one) ? posOne <= this.getMinSlice(one) : posOne >= this.getMaxSlice(one)) {
                return true;
            }
            if (this.slice.isFacingPositive(two) ? posTwo <= this.getMinSlice(two) : posTwo >= this.getMaxSlice(two)) {
                return true;
            }
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs(this.getSliceCornerValue(corner, one) - posOne);
            double difTwo = Math.abs(this.getSliceCornerValue(corner, two) - posTwo);
            float sizeOne = this.getSliceSize(one);
            float sizeTwo = this.getSliceSize(two);
            double diff = difOne / (double)sizeOne + difTwo / (double)sizeTwo;
            return (double)sizeOne >= difOne && (double)sizeTwo >= difTwo && diff <= 1.0;
        }
        return false;
    }

    @Override
    protected boolean intersectsWithBetweenSliceAndBoxInternally(LittleTileBox box) {
        EnumFacing ignoreFace = RotationUtils.getFacing((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis axisOne = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis axisTwo = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        BoxUtils.BoxCorner cornerMin = BoxUtils.BoxCorner.getCornerUnsorted((EnumFacing)ignoreFace, (EnumFacing)this.slice.emptySideOne.func_176734_d(), (EnumFacing)this.slice.emptySideTwo.func_176734_d());
        BoxUtils.BoxCorner cornerMax = BoxUtils.BoxCorner.getCornerUnsorted((EnumFacing)ignoreFace, (EnumFacing)this.slice.emptySideOne, (EnumFacing)this.slice.emptySideTwo);
        double pointOne = this.getSliceValueOfFacing(this.slice.getEmptySide(axisOne).func_176734_d());
        double pointTwo = this.getSliceValueOfFacing(this.slice.getEmptySide(axisTwo).func_176734_d());
        Vec3d minVec = box.getExactCorner(cornerMin);
        Vec3d maxVec = box.getExactCorner(cornerMax);
        if (this.isVecInsideBoxNoEdge(minVec)) {
            return true;
        }
        if (this.isVecInsideBoxNoEdge(maxVec)) {
            return true;
        }
        if (this.slice.isFacingPositive(axisOne) ? RotationUtils.get((EnumFacing.Axis)axisOne, (Vec3d)minVec) <= pointOne : RotationUtils.get((EnumFacing.Axis)axisOne, (Vec3d)minVec) >= pointOne) {
            return true;
        }
        return this.slice.isFacingPositive(axisTwo) ? RotationUtils.get((EnumFacing.Axis)axisTwo, (Vec3d)minVec) <= pointTwo : RotationUtils.get((EnumFacing.Axis)axisTwo, (Vec3d)minVec) >= pointTwo;
    }

    @Override
    public boolean isVecInsideBoxRelative(Vec3d vec) {
        if (vec.field_72450_a >= (double)this.minX && vec.field_72450_a < (double)this.maxX && vec.field_72448_b >= (double)this.minY && vec.field_72448_b < (double)this.maxY && vec.field_72449_c >= (double)this.minZ && vec.field_72449_c < (double)this.maxZ) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            double posOne = RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec);
            double posTwo = RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec);
            if (this.slice.isFacingPositive(one) ? posOne <= this.getMinSlice(one) : posOne >= this.getMaxSlice(one)) {
                return true;
            }
            if (this.slice.isFacingPositive(two) ? posTwo <= this.getMinSlice(two) : posTwo >= this.getMaxSlice(two)) {
                return true;
            }
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs(this.getSliceCornerValue(corner, one) - posOne);
            double difTwo = Math.abs(this.getSliceCornerValue(corner, two) - posTwo);
            float sizeOne = this.getSliceSize(one);
            float sizeTwo = this.getSliceSize(two);
            double diff = difOne / (double)sizeOne + difTwo / (double)sizeTwo;
            return (double)sizeOne >= difOne && (double)sizeTwo >= difTwo && diff <= 1.0;
        }
        return false;
    }

    @Override
    public boolean isVecInsideBox(int x, int y, int z) {
        if (x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY && z >= this.minZ && z < this.maxZ) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            int posOne = RotationUtils.get((EnumFacing.Axis)one, (int)x, (int)y, (int)z);
            int posTwo = RotationUtils.get((EnumFacing.Axis)two, (int)x, (int)y, (int)z);
            if (!this.slice.isFacingPositive(one)) {
                ++posOne;
            }
            if (!this.slice.isFacingPositive(two)) {
                ++posTwo;
            }
            if (this.slice.isFacingPositive(one) ? (double)posOne <= this.getMinSlice(one) : (double)posOne >= this.getMaxSlice(one)) {
                return true;
            }
            if (this.slice.isFacingPositive(two) ? (double)posTwo <= this.getMinSlice(two) : (double)posTwo >= this.getMaxSlice(two)) {
                return true;
            }
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs(this.getSliceCornerValue(corner, one) - (double)posOne);
            double difTwo = Math.abs(this.getSliceCornerValue(corner, two) - (double)posTwo);
            double sizeOne = this.getSliceSize(one);
            double sizeTwo = this.getSliceSize(two);
            double diff = difOne / sizeOne + difTwo / sizeTwo;
            return sizeOne >= difOne && sizeTwo >= difTwo && (diff < 1.0 || LittleUtils.equals(diff, 1.0));
        }
        return false;
    }

    @Override
    public boolean intersectsWithFace(EnumFacing facing, LittleTileVec vec, boolean completely) {
        if (!super.intersectsWithFace(facing, vec, completely)) {
            return false;
        }
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        LittleTileVec copy = vec.copy();
        if (facing.func_176740_k() == this.slice.axis) {
            if (completely == this.slice.isFacingPositive(one)) {
                copy.set(one, copy.get(one) + 1);
            }
            if (completely == this.slice.isFacingPositive(two)) {
                copy.set(two, copy.get(two) + 1);
            }
        } else {
            if (completely == this.slice.isFacingPositive(one)) {
                copy.set(one, copy.get(one) + 1);
            }
            if (completely == this.slice.isFacingPositive(two)) {
                copy.set(two, copy.get(two) + 1);
            }
        }
        return this.intersectsWithFaceRelative(facing, new Vec3d((double)copy.x, (double)copy.y, (double)copy.z));
    }

    public boolean intersectsWithFaceRelative(EnumFacing facing, Vec3d vec) {
        EnumFacing.Axis axis = facing.func_176740_k();
        if (this.slice.axis == axis) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            double posOne = RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec);
            double posTwo = RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec);
            if (this.slice.isFacingPositive(one) ? posOne <= this.getMinSlice(one) : posOne > this.getMaxSlice(one)) {
                return true;
            }
            if (this.slice.isFacingPositive(two) ? posTwo <= this.getMinSlice(two) : posTwo > this.getMaxSlice(two)) {
                return true;
            }
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs(this.getSliceCornerValue(corner, one) - posOne);
            double difTwo = Math.abs(this.getSliceCornerValue(corner, two) - posTwo);
            double sizeOne = this.getSliceSize(one);
            double sizeTwo = this.getSliceSize(two);
            double diff = difOne / sizeOne + difTwo / sizeTwo;
            return sizeOne >= difOne && sizeTwo >= difTwo && diff <= 1.0;
        }
        EnumFacing.Axis other = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis) == axis ? RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis) : RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        if (this.slice.isFacingPositive(axis) == (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE)) {
            if (this.slice.isFacingPositive(other)) {
                return RotationUtils.get((EnumFacing.Axis)other, (Vec3d)vec) <= this.getMinSlice(other);
            }
            return RotationUtils.get((EnumFacing.Axis)other, (Vec3d)vec) >= this.getMaxSlice(other);
        }
        if (this.slice.isFacingPositive(other)) {
            return RotationUtils.get((EnumFacing.Axis)other, (Vec3d)vec) <= this.getMaxSlice(other);
        }
        return RotationUtils.get((EnumFacing.Axis)other, (Vec3d)vec) >= this.getMinSlice(other);
    }

    public boolean intersectsWithFace(LittleGridContext context, EnumFacing facing, Vec3d vec) {
        EnumFacing.Axis axis = facing.func_176740_k();
        if (this.slice.axis == axis) {
            switch (axis) {
                case X: {
                    if (this.intersectsWithYZ(context, vec)) break;
                    return false;
                }
                case Y: {
                    if (this.intersectsWithXZ(context, vec)) break;
                    return false;
                }
                case Z: {
                    if (this.intersectsWithXY(context, vec)) break;
                    return false;
                }
            }
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            double posOne = RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec);
            double posTwo = RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec);
            if (this.slice.isFacingPositive(one) ? posOne <= this.getMinSlice(one) / (double)context.size : posOne > this.getMaxSlice(one) / (double)context.size) {
                return true;
            }
            if (this.slice.isFacingPositive(two) ? posTwo <= this.getMinSlice(two) / (double)context.size : posTwo > this.getMaxSlice(two) / (double)context.size) {
                return true;
            }
            BoxUtils.BoxCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs(this.getSliceCornerValue(corner, one) / (double)context.size - posOne);
            double difTwo = Math.abs(this.getSliceCornerValue(corner, two) / (double)context.size - posTwo);
            double sizeOne = (double)this.getSliceSize(one) / (double)context.size;
            double sizeTwo = (double)this.getSliceSize(two) / (double)context.size;
            double diff = difOne / sizeOne + difTwo / sizeTwo;
            return sizeOne >= difOne && sizeTwo >= difTwo && diff <= 1.0;
        }
        if (!super.intersectsWithAxis(context, axis, vec)) {
            return false;
        }
        EnumFacing.Axis other = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis) == axis ? RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis) : RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        if (this.slice.isFacingPositive(axis) == (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE)) {
            if (this.slice.isFacingPositive(other)) {
                return RotationUtils.get((EnumFacing.Axis)other, (Vec3d)vec) <= this.getMinSlice(other) / (double)context.size;
            }
            return RotationUtils.get((EnumFacing.Axis)other, (Vec3d)vec) > this.getMaxSlice(other) / (double)context.size;
        }
        if (this.slice.isFacingPositive(other)) {
            return RotationUtils.get((EnumFacing.Axis)other, (Vec3d)vec) < this.getMaxSlice(other) / (double)context.size;
        }
        return RotationUtils.get((EnumFacing.Axis)other, (Vec3d)vec) >= this.getMinSlice(other) / (double)context.size;
    }

    @Nullable
    protected Vec3d collideWithPlane(LittleGridContext context, EnumFacing facing, double value, Vec3d vecA, Vec3d vecB) {
        EnumFacing.Axis axis = facing.func_176740_k();
        Vec3d vec3d = axis != EnumFacing.Axis.X ? (axis != EnumFacing.Axis.Y ? vecA.func_72434_d(vecB, value) : vecA.func_72435_c(vecB, value)) : vecA.func_72429_b(vecB, value);
        return vec3d != null && this.intersectsWithFace(context, facing, vec3d) ? vec3d : null;
    }

    @Override
    @Nullable
    public RayTraceResult calculateIntercept(LittleGridContext context, BlockPos pos, Vec3d vecA, Vec3d vecB) {
        vecA = vecA.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        vecB = vecB.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d collision = null;
        EnumFacing collided = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Vec3d temp = this.collideWithPlane(context, facing, (double)this.getValueOfFacing(facing) / (double)context.size, vecA, vecB);
            if (temp == null || !LittleTileSlicedBox.isClosest(vecA, collision, temp)) continue;
            collided = facing;
            collision = temp;
        }
        EnumFacing diagonal = this.slice.getPreferedSide(this.getSizeOfSlice());
        Vector3d sliceCorner = this.getSliceCorner(this.slice.start);
        Vec3d temp = LittleTileSlicedBox.linePlaneIntersection(new Vec3d(sliceCorner.x / (double)context.size, sliceCorner.y / (double)context.size, sliceCorner.z / (double)context.size), this.getSliceNormal(), vecA, vecB.func_178788_d(vecA));
        if (temp != null) {
            boolean inside = false;
            switch (diagonal.func_176740_k()) {
                case X: {
                    inside = this.intersectsWithYZ(context, temp);
                    break;
                }
                case Y: {
                    inside = this.intersectsWithXZ(context, temp);
                    break;
                }
                case Z: {
                    inside = this.intersectsWithXY(context, temp);
                }
            }
            if (inside && LittleTileSlicedBox.isClosest(vecA, collision, temp)) {
                collision = temp;
                collided = diagonal;
            }
        }
        if (collision == null) {
            return null;
        }
        return new RayTraceResult(collision.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), collided, pos);
    }

    @Override
    public void rotateBox(Rotation rotation, LittleTileVec doubledCenter) {
        EnumFacing.Axis beforeOne = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis beforeTwo = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        Vector3d start = new Vector3d(0.0, 0.0, 0.0);
        Vector3d end = new Vector3d(0.0, 0.0, 0.0);
        RotationUtils.setValue((Tuple3d)start, (double)((this.startOne + (float)this.getMin(beforeOne)) * 2.0f), (EnumFacing.Axis)beforeOne);
        RotationUtils.setValue((Tuple3d)start, (double)((this.startTwo + (float)this.getMin(beforeTwo)) * 2.0f), (EnumFacing.Axis)beforeTwo);
        RotationUtils.setValue((Tuple3d)end, (double)((this.endOne + (float)this.getMin(beforeOne)) * 2.0f), (EnumFacing.Axis)beforeOne);
        RotationUtils.setValue((Tuple3d)end, (double)((this.endTwo + (float)this.getMin(beforeTwo)) * 2.0f), (EnumFacing.Axis)beforeTwo);
        LittleSlice before = this.slice;
        super.rotateBox(rotation, doubledCenter);
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        start.x -= (double)doubledCenter.x;
        start.y -= (double)doubledCenter.y;
        start.z -= (double)doubledCenter.z;
        end.x -= (double)doubledCenter.x;
        end.y -= (double)doubledCenter.y;
        end.z -= (double)doubledCenter.z;
        RotationUtils.rotate((Vector3d)start, (Rotation)rotation);
        RotationUtils.rotate((Vector3d)end, (Rotation)rotation);
        beforeOne = RotationUtils.rotate((EnumFacing.Axis)beforeOne, (Rotation)rotation);
        beforeTwo = RotationUtils.rotate((EnumFacing.Axis)beforeTwo, (Rotation)rotation);
        start.x += (double)doubledCenter.x;
        start.y += (double)doubledCenter.y;
        start.z += (double)doubledCenter.z;
        end.x += (double)doubledCenter.x;
        end.y += (double)doubledCenter.y;
        end.z += (double)doubledCenter.z;
        RotationUtils.setValue((Tuple3d)start, (double)(RotationUtils.get((EnumFacing.Axis)beforeOne, (Tuple3d)start) - (double)(this.getMin(beforeOne) * 2)), (EnumFacing.Axis)beforeOne);
        RotationUtils.setValue((Tuple3d)start, (double)(RotationUtils.get((EnumFacing.Axis)beforeTwo, (Tuple3d)start) - (double)(this.getMin(beforeTwo) * 2)), (EnumFacing.Axis)beforeTwo);
        RotationUtils.setValue((Tuple3d)end, (double)(RotationUtils.get((EnumFacing.Axis)beforeOne, (Tuple3d)end) - (double)(this.getMin(beforeOne) * 2)), (EnumFacing.Axis)beforeOne);
        RotationUtils.setValue((Tuple3d)end, (double)(RotationUtils.get((EnumFacing.Axis)beforeTwo, (Tuple3d)end) - (double)(this.getMin(beforeTwo) * 2)), (EnumFacing.Axis)beforeTwo);
        this.startOne = (float)(this.slice.start.isFacingPositive(one) ? Math.max(RotationUtils.get((EnumFacing.Axis)one, (Tuple3d)start), RotationUtils.get((EnumFacing.Axis)one, (Tuple3d)end)) : Math.min(RotationUtils.get((EnumFacing.Axis)one, (Tuple3d)start), RotationUtils.get((EnumFacing.Axis)one, (Tuple3d)end))) / 2.0f;
        this.startTwo = (float)(this.slice.start.isFacingPositive(two) ? Math.max(RotationUtils.get((EnumFacing.Axis)two, (Tuple3d)start), RotationUtils.get((EnumFacing.Axis)two, (Tuple3d)end)) : Math.min(RotationUtils.get((EnumFacing.Axis)two, (Tuple3d)start), RotationUtils.get((EnumFacing.Axis)two, (Tuple3d)end))) / 2.0f;
        this.endOne = (float)(!this.slice.start.isFacingPositive(one) ? Math.max(RotationUtils.get((EnumFacing.Axis)one, (Tuple3d)start), RotationUtils.get((EnumFacing.Axis)one, (Tuple3d)end)) : Math.min(RotationUtils.get((EnumFacing.Axis)one, (Tuple3d)start), RotationUtils.get((EnumFacing.Axis)one, (Tuple3d)end))) / 2.0f;
        this.endTwo = (float)(!this.slice.start.isFacingPositive(two) ? Math.max(RotationUtils.get((EnumFacing.Axis)two, (Tuple3d)start), RotationUtils.get((EnumFacing.Axis)two, (Tuple3d)end)) : Math.min(RotationUtils.get((EnumFacing.Axis)two, (Tuple3d)start), RotationUtils.get((EnumFacing.Axis)two, (Tuple3d)end))) / 2.0f;
    }

    @Override
    public void flipBox(EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        if (axis == this.slice.axis) {
            super.flipBox(axis, doubledCenter);
            return;
        }
        float startBefore = ((float)this.getMax(axis) - this.getStart(axis)) * 2.0f;
        float endBefore = ((float)this.getMax(axis) - this.getEnd(axis)) * 2.0f;
        super.flipBox(axis, doubledCenter);
        EnumFacing.Axis other = axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis) ? RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis) : RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        this.setStartRelative(axis, (this.slice.start.isFacingPositive(axis) ? Math.max(startBefore, endBefore) : Math.min(startBefore, endBefore)) / 2.0f);
        this.setEndRelative(axis, (!this.slice.start.isFacingPositive(axis) ? Math.max(startBefore, endBefore) : Math.min(startBefore, endBefore)) / 2.0f);
        startBefore = this.slice.start.isFacingPositive(other) ? Math.max(this.getStartRelative(other), this.getEndRelative(other)) : Math.min(this.getStartRelative(other), this.getEndRelative(other));
        this.setEndRelative(other, !this.slice.start.isFacingPositive(other) ? Math.max(this.getStartRelative(other), this.getEndRelative(other)) : Math.min(this.getStartRelative(other), this.getEndRelative(other)));
        this.setStartRelative(other, startBefore);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LittleTileSlicedBox) {
            return super.equals(object) && LittleUtils.equals(((LittleTileSlicedBox)object).startOne, this.startOne) && LittleUtils.equals(((LittleTileSlicedBox)object).startTwo, this.startTwo) && LittleUtils.equals(((LittleTileSlicedBox)object).endOne, this.endOne) && LittleUtils.equals(((LittleTileSlicedBox)object).endTwo, this.endTwo);
        }
        return false;
    }

    @Override
    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.minZ + " -> " + this.maxX + "," + this.maxY + "," + this.maxZ + "," + this.slice.name() + "," + this.startOne + "," + this.startTwo + "," + this.endOne + "," + this.endTwo + "]";
    }

    @Override
    public LittleTileSlicedBox copy() {
        return new LittleTileSlicedBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.slice, this.startOne, this.startTwo, this.endOne, this.endTwo);
    }

    @Override
    public Vec3d getSliceNormal() {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        Vector3d vec = new Vector3d();
        RotationUtils.setValue((Tuple3d)vec, (double)(this.getSliceSize(one) * (float)this.slice.getDirectionScale(one)), (EnumFacing.Axis)one);
        RotationUtils.setValue((Tuple3d)vec, (double)(this.getSliceSize(two) * (float)this.slice.getDirectionScale(two)), (EnumFacing.Axis)two);
        RotationUtils.rotate((Vector3d)vec, (Rotation)Rotation.getRotation((EnumFacing.Axis)this.slice.axis, (boolean)this.slice.isRight));
        vec.normalize();
        return new Vec3d(vec.x, vec.y, vec.z);
    }

    @Override
    public Ray2d getSliceLine() {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        return new Ray2d(one, two, this.getSliceCorner(this.slice.start), (double)(this.getSliceSize(one) * (float)this.slice.getDirectionScale(one)), (double)(this.getSliceSize(two) * (float)this.slice.getDirectionScale(two)));
    }

    @Override
    public LittleTileBox grow(EnumFacing direction) {
        LittleTileSlicedBox box = (LittleTileSlicedBox)super.grow(direction);
        double delta = (double)box.getSize(direction.func_176740_k()) / (double)this.getSize(direction.func_176740_k());
        if (direction.func_176740_k() == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis)) {
            box.startOne = (float)((double)box.startOne * delta);
            box.endOne = (float)((double)box.endOne * delta);
        } else if (direction.func_176740_k() == RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis)) {
            box.startTwo = (float)((double)box.startTwo * delta);
            box.endTwo = (float)((double)box.endTwo * delta);
        }
        return box;
    }

    @Override
    public LittleTileBox shrink(EnumFacing direction, boolean toLimit) {
        LittleTileSlicedBox box = (LittleTileSlicedBox)super.shrink(direction, toLimit);
        if (box == null) {
            return null;
        }
        double delta = (double)box.getSize(direction.func_176740_k()) / (double)this.getSize(direction.func_176740_k());
        if (direction.func_176740_k() == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis)) {
            box.startOne = (float)((double)box.startOne * delta);
            box.endOne = (float)((double)box.endOne * delta);
        } else if (direction.func_176740_k() == RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis)) {
            box.startTwo = (float)((double)box.startTwo * delta);
            box.endTwo = (float)((double)box.endTwo * delta);
        }
        return box;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleRenderingCube getRenderingCube(LittleGridContext context, CubeObject cube, Block block, int meta) {
        return new LittleSlicedRenderingCube(context, cube, this, block, meta);
    }

    @Override
    public double getSliceAngle(EnumFacing.Axis one, EnumFacing.Axis two) {
        return this.getSliceSize(one) / this.getSliceSize(two);
    }

    public double getSliceValueOfFacing(EnumFacing facing) {
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            return this.getMaxSlice(facing.func_176740_k());
        }
        return this.getMinSlice(facing.func_176740_k());
    }

    public double getSliceCornerValue(BoxUtils.BoxCorner corner, EnumFacing.Axis axis) {
        return this.getSliceValueOfFacing(corner.getFacing(axis));
    }

    public Vector3d getSliceCorner(BoxUtils.BoxCorner corner) {
        return new Vector3d(corner.x.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMaxSlice(EnumFacing.Axis.X) : this.getMinSlice(EnumFacing.Axis.X), corner.y.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMaxSlice(EnumFacing.Axis.Y) : this.getMinSlice(EnumFacing.Axis.Y), corner.z.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMaxSlice(EnumFacing.Axis.Z) : this.getMinSlice(EnumFacing.Axis.Z));
    }

    public boolean hasAdditionalBoxOne() {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        if (this.slice.isFacingPositive(one)) {
            return this.getMinSlice(one) > (double)this.getMin(one);
        }
        return this.getMaxSlice(one) < (double)(this.getSize(one) + this.getMin(one));
    }

    public boolean hasAdditionalBoxTwo() {
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        if (this.slice.isFacingPositive(two)) {
            return this.getMinSlice(two) > (double)this.getMin(two);
        }
        return this.getMaxSlice(two) < (double)(this.getSize(two) + this.getMin(two));
    }

    public void setStartRelative(EnumFacing.Axis axis, float value) {
        if (axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis)) {
            this.startOne = value;
        } else if (axis == RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis)) {
            this.startTwo = value;
        }
    }

    public void setEndRelative(EnumFacing.Axis axis, float value) {
        if (axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis)) {
            this.endOne = value;
        } else if (axis == RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis)) {
            this.endTwo = value;
        }
    }

    public float getStartRelative(EnumFacing.Axis axis) {
        if (axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis)) {
            return this.startOne;
        }
        return this.startTwo;
    }

    public float getEndRelative(EnumFacing.Axis axis) {
        if (axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis)) {
            return this.endOne;
        }
        return this.endTwo;
    }

    public float getStart(EnumFacing.Axis axis) {
        if (axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis)) {
            return (float)this.getMin(axis) + this.startOne;
        }
        return (float)this.getMin(axis) + this.startTwo;
    }

    public float getEnd(EnumFacing.Axis axis) {
        if (axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis)) {
            return (float)this.getMin(axis) + this.endOne;
        }
        return (float)this.getMin(axis) + this.endTwo;
    }

    public float getMinSliceRelative(EnumFacing.Axis axis) {
        boolean axisOne;
        if (this.slice.axis == axis) {
            return 0.0f;
        }
        boolean bl = axisOne = axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        if (!this.slice.start.isFacingPositive(axis)) {
            if (axisOne) {
                return this.startOne;
            }
            return this.startTwo;
        }
        if (axisOne) {
            return this.endOne;
        }
        return this.endTwo;
    }

    public float getMaxSliceRelative(EnumFacing.Axis axis) {
        boolean axisOne;
        if (this.slice.axis == axis) {
            return 0.0f;
        }
        boolean bl = axisOne = axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        if (this.slice.start.isFacingPositive(axis)) {
            if (axisOne) {
                return this.startOne;
            }
            return this.startTwo;
        }
        if (axisOne) {
            return this.endOne;
        }
        return this.endTwo;
    }

    public double getMinSlice(EnumFacing.Axis axis) {
        boolean axisOne;
        if (this.slice.axis == axis) {
            return super.getMin(axis);
        }
        boolean bl = axisOne = axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        if (!this.slice.start.isFacingPositive(axis)) {
            if (axisOne) {
                return this.startOne + (float)this.getMin(axis);
            }
            return this.startTwo + (float)this.getMin(axis);
        }
        if (axisOne) {
            return this.endOne + (float)this.getMin(axis);
        }
        return this.endTwo + (float)this.getMin(axis);
    }

    public double getMaxSlice(EnumFacing.Axis axis) {
        boolean axisOne;
        if (this.slice.axis == axis) {
            return super.getMax(axis);
        }
        boolean bl = axisOne = axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        if (this.slice.start.isFacingPositive(axis)) {
            if (axisOne) {
                return this.startOne + (float)this.getMin(axis);
            }
            return this.startTwo + (float)this.getMin(axis);
        }
        if (axisOne) {
            return this.endOne + (float)this.getMin(axis);
        }
        return this.endTwo + (float)this.getMin(axis);
    }

    public float getSliceSize(EnumFacing.Axis axis) {
        if (this.slice.axis == axis) {
            return super.getSize(axis);
        }
        if (axis == RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis)) {
            return Math.abs(this.startOne - this.endOne);
        }
        return Math.abs(this.startTwo - this.endTwo);
    }

    public Vector3d getSizeOfSlice() {
        Vector3d vec = new Vector3d((double)(this.maxX - this.minX), (double)(this.maxY - this.minY), (double)(this.maxZ - this.minZ));
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        RotationUtils.setValue((Tuple3d)vec, (double)this.getSliceSize(one), (EnumFacing.Axis)one);
        RotationUtils.setValue((Tuple3d)vec, (double)this.getSliceSize(two), (EnumFacing.Axis)two);
        return vec;
    }

    public CubeObject getSlicedCube(LittleGridContext context) {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        CubeObject cube = super.getCube(context);
        cube.setMin(one, context.toVanillaGrid((float)this.getMinSlice(one)));
        cube.setMax(one, context.toVanillaGrid((float)this.getMaxSlice(one)));
        cube.setMin(two, context.toVanillaGrid((float)this.getMinSlice(two)));
        cube.setMax(two, context.toVanillaGrid((float)this.getMaxSlice(two)));
        return cube;
    }

    @Override
    public boolean isOrdinary() {
        return false;
    }
}

