/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.preview;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;

public class LittlePreviewsStructure
extends LittlePreviews {
    public NBTTagCompound nbt;
    private LittleStructure structure;

    public LittlePreviewsStructure(NBTTagCompound nbt, LittlePreviews previews) {
        super(previews);
        this.nbt = nbt;
    }

    public LittlePreviewsStructure(NBTTagCompound nbt, LittleGridContext context) {
        super(context);
        this.nbt = nbt;
    }

    @Override
    public boolean hasStructure() {
        return true;
    }

    @Override
    public void deleteCachedStructure() {
        super.deleteCachedStructure();
        this.structure = null;
    }

    @Override
    public LittleStructure getStructure() {
        if (this.structure == null) {
            this.structure = LittleStructure.createAndLoadStructure(this.nbt, null);
            this.structure.tempChildren = new ArrayList<LittleStructure>();
            for (LittlePreviews child : this.getChildren()) {
                this.structure.tempChildren.add(child.getStructure());
            }
        }
        return this.structure;
    }

    @Override
    public NBTTagCompound getStructureData() {
        return this.nbt;
    }

    @Override
    public LittlePreviewsStructure copy() {
        LittlePreviewsStructure previews = new LittlePreviewsStructure(this.nbt, this.context);
        previews.previews.addAll(this.previews);
        previews.children.addAll(this.children);
        return previews;
    }
}

