/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.place;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PlacePreviewTile {
    public static final Vec3d white = new Vec3d(1.0, 1.0, 1.0);
    public LittleTileBox box;
    public LittleTilePreview preview;
    public LittlePreviews structurePreview;

    public PlacePreviewTile(LittleTileBox box, LittleTilePreview preview, LittlePreviews previews) {
        this.box = box;
        this.preview = preview;
        if (previews != null && previews.hasStructure()) {
            this.structurePreview = previews;
        }
    }

    public PlacePreviewTile copy() {
        return new PlacePreviewTile(this.box.copy(), this.preview.copy(), this.structurePreview);
    }

    public boolean needsCollisionTest() {
        return true;
    }

    public List<LittleRenderingCube> getPreviews(LittleGridContext context) {
        ArrayList<LittleRenderingCube> previews = new ArrayList<LittleRenderingCube>();
        previews.add(this.box.getRenderingCube(context, null, 0));
        return previews;
    }

    public List<LittleTile> placeTile(@Nullable EntityPlayer player, @Nullable ItemStack stack, BlockPos pos, LittleGridContext context, TileEntityLittleTiles te, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, PlacementMode mode, @Nullable EnumFacing facing, boolean requiresCollisionTest) {
        LittleTile LT = this.preview.getLittleTile(te);
        if (LT == null) {
            return Collections.EMPTY_LIST;
        }
        LT.box = this.box.copy();
        List<LittleTile> tiles = mode.placeTile(te, LT, unplaceableTiles, removedTiles, requiresCollisionTest);
        for (LittleTile tile : tiles) {
            tile.place();
            tile.onPlaced(player, stack, facing);
        }
        return tiles;
    }

    public PlacePreviewTile copyWithBox(LittleTileBox box) {
        PlacePreviewTile tile = this.copy();
        tile.box = box;
        return tile;
    }

    public boolean split(LittleGridContext context, HashMapList<BlockPos, PlacePreviewTile> tiles, BlockPos pos) {
        if (!this.requiresSplit()) {
            tiles.add((Object)pos, (Object)this);
            return true;
        }
        if (this.canSplit() && this.box.needsMultipleBlocks(context)) {
            return false;
        }
        HashMapList boxes = new HashMapList();
        this.box.split(context, pos, (HashMapList<BlockPos, LittleTileBox>)boxes);
        for (Map.Entry entry : boxes.entrySet()) {
            for (LittleTileBox box : (ArrayList)entry.getValue()) {
                tiles.add(entry.getKey(), (Object)this.copyWithBox(box));
            }
        }
        return true;
    }

    public boolean requiresSplit() {
        return true;
    }

    public boolean canSplit() {
        return this.preview != null && !this.preview.canSplit;
    }

    public void add(LittleTileVec vec) {
        this.box.add(vec);
    }

    public void convertTo(LittleGridContext context, LittleGridContext to) {
        this.box.convertTo(context, to);
    }

    public int getSmallestContext(LittleGridContext context) {
        return this.box.getSmallestContext(context);
    }
}

