/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.connection;

import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.connection.IStructureConnector;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierStructure;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class StructureLinkBase<T>
extends LittleTileIdentifierStructure
implements IStructureConnector<T> {
    protected LittleStructure structure;
    protected final T parent;
    protected boolean loadingStructure;

    public StructureLinkBase(TileEntity te, BlockPos coord, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, T parent) {
        super(te, coord, context, identifier, attribute);
        this.parent = parent;
    }

    public StructureLinkBase(BlockPos origin, BlockPos coord, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, T parent) {
        super(origin, coord, context, identifier, attribute);
        this.parent = parent;
    }

    public StructureLinkBase(int baseX, int baseY, int baseZ, BlockPos coord, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, T parent) {
        super(baseX, baseY, baseZ, coord, context, identifier, attribute);
        this.parent = parent;
    }

    public StructureLinkBase(NBTTagCompound nbt, T parent) {
        super(nbt);
        this.parent = parent;
    }

    protected StructureLinkBase(int relativeX, int relativeY, int relativeZ, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, T parent) {
        super(relativeX, relativeY, relativeZ, context, identifier, attribute);
        this.parent = parent;
    }

    protected abstract void connect(World var1, LittleTile var2);

    protected abstract void failedConnect(World var1);

    @Override
    public LittleStructure getStructureWithoutLoading() {
        return this.structure;
    }

    @Override
    public boolean isConnected(World world) {
        if (this.loadingStructure) {
            new RuntimeException("Attempted to load structure twice!").printStackTrace();
            return false;
        }
        if (this.structure != null) {
            return true;
        }
        if (world == null) {
            return false;
        }
        this.loadingStructure = true;
        BlockPos absoluteCoord = this.getStructurePosition();
        Chunk chunk = world.func_175726_f(absoluteCoord);
        if (WorldUtils.checkIfChunkExists((Chunk)chunk)) {
            LittleTile tile;
            TileEntity te = world.func_175625_s(absoluteCoord);
            if (te instanceof TileEntityLittleTiles && (tile = ((TileEntityLittleTiles)te).getTile(this.context, this.identifier)) != null && tile.isChildOfStructure() && !tile.connection.isLink()) {
                this.connect(world, tile);
            }
            if (this.structure == null && !world.field_72995_K) {
                this.failedConnect(world);
            }
            this.loadingStructure = false;
            return this.structure != null;
        }
        this.loadingStructure = false;
        return false;
    }

    @Override
    public LittleStructure getStructure(World world) {
        if (this.isConnected(world)) {
            return this.structure;
        }
        return null;
    }

    @Override
    public void setLoadedStructure(LittleStructure structure, LittleStructureAttribute attribute) {
        this.structure = structure;
        this.attribute = attribute;
    }

    @Override
    public void reset() {
        this.structure = null;
    }

    @Override
    public boolean isLink() {
        return true;
    }

    @Override
    public boolean is(LittleTile mainTile) {
        return mainTile.is(this.context, this.identifier);
    }

    @Override
    public LittleStructureAttribute getAttribute() {
        return this.attribute;
    }
}

