/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.animation.AnimationController;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityAnimationController
extends AnimationController {
    private static HashMap<String, Class<? extends EntityAnimationController>> controllerTypes = new HashMap();
    private static HashMap<Class<? extends EntityAnimationController>, String> controllerTypesInv = new HashMap();
    public EntityAnimation parent;

    public static void registerControllerType(String id, Class<? extends EntityAnimationController> controllerType) {
        controllerTypes.put(id, controllerType);
        controllerTypesInv.put(controllerType, id);
    }

    public abstract boolean onRightClick();

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("id", controllerTypesInv.get(this.getClass()));
        this.writeToNBTExtra(nbt);
        return nbt;
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    protected abstract void readFromNBT(NBTTagCompound var1);

    public EntityPlayer activator() {
        return null;
    }

    public void onServerApproves() {
    }

    @SideOnly(value=Side.CLIENT)
    public void removeWaitingTe(TileEntityLittleTiles te) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isWaitingForRender() {
        return false;
    }

    public static EntityAnimationController parseController(EntityAnimation animation, NBTTagCompound nbt) {
        Class<? extends EntityAnimationController> controllerType = controllerTypes.get(nbt.func_74779_i("id"));
        if (controllerType == null) {
            throw new RuntimeException("Unkown controller type '" + nbt.func_74779_i("id") + "'");
        }
        try {
            EntityAnimationController controller = controllerType.getConstructor(new Class[0]).newInstance(new Object[0]);
            controller.parent = animation;
            controller.readFromNBT(nbt);
            return controller;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        EntityAnimationController.registerControllerType("door", DoorController.class);
    }
}

