/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.container;

import com.creativemd.creativecore.common.gui.controls.container.SlotControl;
import com.creativemd.creativecore.common.gui.event.container.SlotChangeEvent;
import com.creativemd.creativecore.common.gui.premade.SubContainerHeldItem;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.gui.controls.SlotControlBlockIngredient;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.ColorUnit;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import com.creativemd.littletiles.common.utils.ingredients.Ingredients;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.DyeUtils;

public class SubContainerTileContainer
extends SubContainerHeldItem {
    private static Field dyeColor = ReflectionHelper.findField(EnumDyeColor.class, (String[])new String[]{"colorValue", "field_193351_w"});
    public InventoryBasic bagInventory;

    public SubContainerTileContainer(EntityPlayer player) {
        super(player);
    }

    @CustomEventSubscribe
    public void onSlotChange(SlotChangeEvent event) {
        if (event.source instanceof SlotControl) {
            if (event.source instanceof SlotControlBlockIngredient) {
                SlotControlBlockIngredient slot = (SlotControlBlockIngredient)event.source;
                if (slot.slot.func_75211_c().func_190926_b()) {
                    slot.ingredient = null;
                } else if (slot.ingredient != null) {
                    slot.ingredient.value = (double)slot.slot.func_75211_c().func_190916_E() / (double)LittleGridContext.get().maxTilesPerBlock;
                }
                ArrayList<BlockIngredient> inventory = new ArrayList<BlockIngredient>();
                for (int y = 0; y < ItemTileContainer.inventoryHeight; ++y) {
                    for (int x = 0; x < ItemTileContainer.inventoryWidth; ++x) {
                        int index = x + y * ItemTileContainer.inventoryWidth;
                        BlockIngredient ingredient = ((SlotControlBlockIngredient)this.get((String)new StringBuilder().append((String)"item").append((int)index).toString())).ingredient;
                        if (ingredient == null) continue;
                        inventory.add(ingredient);
                    }
                }
                ItemTileContainer.saveInventory(this.stack, inventory);
                this.reloadControls();
            } else if (event.source.name.startsWith("input")) {
                ItemStack input = ((SlotControl)event.source).slot.func_75211_c();
                Ingredients ingredients = IngredientUtils.getIngredientsOfStack(input);
                boolean containedColor = false;
                if (ingredients != null) {
                    ColorUnit result = ItemTileContainer.storeColor(this.stack, ingredients.color, true);
                    if (result != null && result.equals(ingredients.color)) {
                        return;
                    }
                    boolean bl = containedColor = !ingredients.color.isEmpty();
                    while (!input.func_190926_b() && ItemTileContainer.storeBlocks(this.stack, ingredients.block.copy(), true) == null) {
                        input.func_190918_g(1);
                        ItemTileContainer.storeBlocks(this.stack, ingredients.block.copy(), false);
                        if (ItemTileContainer.storeColor(this.stack, ingredients.color, false) == null) continue;
                    }
                    this.updateSlots();
                    this.player.func_184185_a(SoundEvents.field_187626_cN, 1.0f, 1.0f);
                } else if (DyeUtils.isDye((ItemStack)input)) {
                    try {
                        Optional optional = DyeUtils.colorFromStack((ItemStack)input);
                        if (!optional.isPresent()) {
                            return;
                        }
                        ColorUnit color = ColorUnit.getColors(dyeColor.getInt(optional.get()));
                        color.scale(2.0);
                        ColorUnit result = ItemTileContainer.storeColor(this.stack, color, true);
                        if (result != null && result.equals(color)) {
                            return;
                        }
                        while (!input.func_190926_b()) {
                            input.func_190918_g(1);
                            if (ItemTileContainer.storeColor(this.stack, color, false) == null) continue;
                        }
                        containedColor = true;
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
                if (containedColor) {
                    this.reloadControls();
                    this.player.func_184185_a(SoundEvents.field_187621_J, 1.0f, 1.0f);
                }
            }
        }
    }

    public void reloadControls() {
        this.controls.clear();
        this.createControls();
        this.refreshControls();
        NBTTagCompound nbt = this.stack.func_77978_p().func_74737_b();
        nbt.func_74757_a("reload", true);
        this.sendNBTToGui(nbt);
    }

    public void updateSlots() {
        List<BlockIngredient> inventory = ItemTileContainer.loadInventory(this.stack);
        for (int y = 0; y < ItemTileContainer.inventoryHeight; ++y) {
            for (int x = 0; x < ItemTileContainer.inventoryWidth; ++x) {
                int index;
                this.bagInventory.func_70299_a(index, (index = x + y * ItemTileContainer.inventoryWidth) < inventory.size() ? inventory.get(index).getTileItemStack() : ItemStack.field_190927_a);
                ((SlotControlBlockIngredient)this.get((String)new StringBuilder().append((String)"item").append((int)index).toString())).ingredient = index < inventory.size() ? inventory.get(index) : null;
            }
        }
    }

    public void createControls() {
        List<BlockIngredient> inventory = ItemTileContainer.loadInventory(this.stack);
        this.bagInventory = new InventoryBasic("item", false, ItemTileContainer.inventorySize){

            public int func_70297_j_() {
                return ItemTileContainer.maxStackSizeOfTiles;
            }
        };
        for (int y = 0; y < ItemTileContainer.inventoryHeight; ++y) {
            for (int x = 0; x < ItemTileContainer.inventoryWidth; ++x) {
                int index;
                this.bagInventory.func_70299_a(index, (index = x + y * ItemTileContainer.inventoryWidth) < inventory.size() ? inventory.get(index).getTileItemStack() : ItemStack.field_190927_a);
                this.controls.add(new SlotControlBlockIngredient(new Slot((IInventory)this.bagInventory, index, 5 + x * 18, 5 + y * 18){

                    public boolean func_75214_a(ItemStack stack) {
                        return false;
                    }
                }, index < inventory.size() ? inventory.get(index) : null));
            }
        }
        InventoryBasic input = new InventoryBasic("input", false, 1);
        this.addSlotToContainer(new Slot((IInventory)input, 0, 120, 5));
        this.addPlayerSlotsToContainer(this.player);
    }

    public void onClosed() {
        this.player.field_71071_by.field_70462_a.set(this.currentIndex, (Object)this.stack);
        ItemStack stack = ((SlotControl)this.get((String)"input0")).slot.func_75211_c();
        if (!stack.func_190926_b()) {
            WorldUtils.dropItem((EntityPlayer)this.player, (ItemStack)stack);
        }
    }

    public void onPacketReceive(NBTTagCompound nbt) {
    }
}

