/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.api.blocks;

import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ISpecialBlockHandler {
    default public boolean canBeConvertedToVanilla(LittleTileBlock tile) {
        return true;
    }

    default public List<LittleTileBox> getCollisionBoxes(LittleTileBlock tile, List<LittleTileBox> defaultBoxes) {
        return defaultBoxes;
    }

    default public boolean onBlockActivated(LittleTileBlock tile, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    default public void onTileExplodes(LittleTileBlock tile, Explosion explosion) {
    }

    default public void randomDisplayTick(LittleTileBlock tile, IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    default public boolean isMaterial(LittleTileBlock tile, Material material) {
        return tile.getBlockState().func_185904_a() == material;
    }

    default public boolean isLiquid(LittleTileBlock tile) {
        return tile.getBlockState().func_185904_a().func_76224_d();
    }

    default public Vec3d modifyAcceleration(LittleTileBlock tile, Entity entityIn, Vec3d motion) {
        return null;
    }

    default public LittleTilePreview getPreview(LittleTileBlock tile) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean canBeRenderCombined(LittleTileBlock thisTile, LittleTileBlock tile) {
        return false;
    }

    default public boolean shouldCheckForCollision(LittleTileBlock tile) {
        return false;
    }

    default public void onEntityCollidedWithBlock(World worldIn, LittleTileBlock tile, BlockPos pos, IBlockState state, Entity entityIn) {
    }
}

