/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.entity;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.vec.MatrixUtils;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.render.RenderingThread;
import com.creativemd.littletiles.client.render.entity.LittleRenderChunk;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.events.LittleEvent;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.Iterator;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.VertexBufferUploader;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.optifine.shaders.ShadersRender;
import org.lwjgl.opengl.GL11;

public class RenderAnimation
extends Render<EntityAnimation> {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static final VertexBufferUploader uploader = new VertexBufferUploader();

    public RenderAnimation(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityAnimation entity, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean first;
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        boolean bl = first = MinecraftForgeClient.getRenderPass() == 0 || MinecraftForgeClient.getRenderPass() == -1;
        if (entity.field_70128_L) {
            return;
        }
        if (first) {
            if (entity.renderChunks == null) {
                entity.createClient();
            }
            if (entity.renderQueue != null) {
                Iterator<Object> iterator = entity.renderQueue.iterator();
                while (iterator.hasNext()) {
                    TileEntityLittleTiles te = (TileEntityLittleTiles)iterator.next();
                    if (te.rendering.get()) continue;
                    if (te.getBuffer() == null) {
                        RenderingThread.addCoordToUpdate(te, 0.0, false);
                        continue;
                    }
                    BlockPos renderChunkPos = RenderAnimation.getRenderChunkPos(te.func_174877_v());
                    LittleRenderChunk chunk = entity.renderChunks.get(renderChunkPos);
                    if (chunk == null) {
                        chunk = new LittleRenderChunk(renderChunkPos);
                        entity.renderChunks.put(renderChunkPos, chunk);
                    }
                    chunk.addRenderData(te);
                    iterator.remove();
                }
            }
            for (LittleRenderChunk chunk : entity.renderChunks.values()) {
                chunk.uploadBuffer();
            }
            if (entity.renderQueue != null && entity.renderQueue.isEmpty()) {
                for (LittleRenderChunk chunk : entity.renderChunks.values()) {
                    chunk.markCompleted();
                }
                entity.renderQueue = null;
            }
        }
        Vec3d rotation = entity.getRotationVector(partialTicks);
        Vec3d offset = entity.getOffsetVector(partialTicks);
        LittleGridContext context = entity.center.inBlockOffset.context;
        this.func_110776_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_187410_q((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32886);
        float f = (float)RenderAnimation.mc.func_175606_aa().field_70165_t;
        float f1 = (float)RenderAnimation.mc.func_175606_aa().field_70163_u + mc.func_175606_aa().func_70047_e();
        float f2 = (float)RenderAnimation.mc.func_175606_aa().field_70161_v;
        if (first) {
            GlStateManager.func_179118_c();
            this.renderBlockLayer(BlockRenderLayer.SOLID, entity, f, f1, f2, x, y, z, offset, rotation);
            GlStateManager.func_179141_d();
            mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, RenderAnimation.mc.field_71474_y.field_151442_I > 0);
            this.renderBlockLayer(BlockRenderLayer.CUTOUT_MIPPED, entity, f, f1, f2, x, y, z, offset, rotation);
            mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
            mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            this.renderBlockLayer(BlockRenderLayer.CUTOUT, entity, f, f1, f2, x, y, z, offset, rotation);
            mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        } else {
            this.renderBlockLayer(BlockRenderLayer.TRANSLUCENT, entity, f, f1, f2, x, y, z, offset, rotation);
        }
        for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
            VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
            int i1 = vertexformatelement.func_177369_e();
            switch (vertexformatelement$enumusage) {
                case POSITION: {
                    GlStateManager.func_187429_p((int)32884);
                    break;
                }
                case UV: {
                    OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + i1));
                    GlStateManager.func_187429_p((int)32888);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                    break;
                }
                case COLOR: {
                    GlStateManager.func_187429_p((int)32886);
                    GlStateManager.func_179117_G();
                }
            }
        }
        GlStateManager.func_179103_j((int)7424);
        if (!first) {
            return;
        }
        GlStateManager.func_179091_B();
        for (TileEntityLittleTiles te : entity.blocks) {
            if (!te.shouldRenderInPass(0)) continue;
            GlStateManager.func_179094_E();
            BlockPos blockpos = te.func_174877_v();
            BlockPos newpos = te.func_174877_v().func_177973_b((Vec3i)entity.center.baseOffset);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179137_b((double)offset.field_72450_a, (double)offset.field_72448_b, (double)offset.field_72449_c);
            GlStateManager.func_179137_b((double)entity.center.rotationCenterInsideBlock.x, (double)entity.center.rotationCenterInsideBlock.y, (double)entity.center.rotationCenterInsideBlock.z);
            GL11.glRotated((double)rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
            GlStateManager.func_179137_b((double)(-((double)blockpos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b) + (double)newpos.func_177958_n()), (double)(-((double)blockpos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c) + (double)newpos.func_177956_o()), (double)(-((double)blockpos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d) + (double)newpos.func_177952_p()));
            GlStateManager.func_179137_b((double)(-entity.center.rotationCenterInsideBlock.x), (double)(-entity.center.rotationCenterInsideBlock.y), (double)(-entity.center.rotationCenterInsideBlock.z));
            this.render(te, partialTicks, -1);
            GlStateManager.func_179137_b((double)(-entity.center.inBlockOffset.getPosX() - context.gridMCLength / 2.0), (double)(-entity.center.inBlockOffset.getPosY() - context.gridMCLength / 2.0), (double)(-entity.center.inBlockOffset.getPosZ() - context.gridMCLength / 2.0));
            GlStateManager.func_179121_F();
        }
        RenderHelper.func_74519_b();
        if (mc.func_175598_ae().func_178634_b() && !mc.func_189648_am()) {
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_179084_k();
            GlStateManager.func_187441_d((float)4.0f);
            GlStateManager.func_179094_E();
            double rotY = entity.worldRotY - entity.prevWorldRotY;
            Matrix3d rotationY = MatrixUtils.createRotationMatrixY((double)rotY);
            AxisAlignedBB moveBB = BoxUtils.getRotatedSurrounding((AxisAlignedBB)entity.worldBoundingBox, (Vector3d)entity.center.rotationCenter, (Matrix3d)entity.origin.rotation(), (Vector3d)entity.origin.translation(), null, (double)0.0, (Matrix3d)rotationY, (double)rotY, null, (double)0.0, null);
            RenderGlobal.func_189694_a((double)(moveBB.field_72340_a - entity.field_70165_t + x), (double)(moveBB.field_72338_b - entity.field_70163_u + y), (double)(moveBB.field_72339_c - entity.field_70161_v + z), (double)(moveBB.field_72336_d - entity.field_70165_t + x), (double)(moveBB.field_72337_e - entity.field_70163_u + y), (double)(moveBB.field_72334_f - entity.field_70161_v + z), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    public void render(TileEntityLittleTiles tileentityIn, float partialTicks, int destroyStage) {
        if (tileentityIn.func_145835_a(TileEntityRendererDispatcher.field_147556_a.field_147560_j, TileEntityRendererDispatcher.field_147556_a.field_147561_k, TileEntityRendererDispatcher.field_147556_a.field_147558_l) < tileentityIn.func_145833_n()) {
            if (!tileentityIn.hasFastRenderer()) {
                RenderHelper.func_74519_b();
                int i = tileentityIn.func_145831_w().func_175626_b(tileentityIn.func_174877_v(), 0);
                int j = i % 65536;
                int k = i / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            BlockPos blockpos = tileentityIn.func_174877_v();
            LittleTilesClient.tileEntityRenderer.render(tileentityIn, (double)blockpos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b, (double)blockpos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c, (double)blockpos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d, partialTicks, destroyStage, 1.0f);
        }
    }

    public void renderBlockLayer(BlockRenderLayer layer, EntityAnimation entity, float f, float f1, float f2, double x, double y, double z, Vec3d offset, Vec3d rotation) {
        if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
            ShadersRender.preRenderChunkLayer((BlockRenderLayer)layer);
        }
        for (LittleRenderChunk chunk : entity.renderChunks.values()) {
            VertexBuffer buffer;
            if (layer == BlockRenderLayer.TRANSLUCENT) {
                chunk.resortTransparency(LittleEvent.transparencySortingIndex, f, f1, f2);
            }
            if ((buffer = chunk.getLayerBuffer(layer)) == null) continue;
            GlStateManager.func_179094_E();
            RenderAnimation.mc.field_71460_t.func_180436_i();
            double posX = (chunk.pos.func_177958_n() - entity.center.chunkOffset.func_177958_n()) * 16 - entity.center.inChunkOffset.func_177958_n();
            double posY = (chunk.pos.func_177956_o() - entity.center.chunkOffset.func_177956_o()) * 16 - entity.center.inChunkOffset.func_177956_o();
            double posZ = (chunk.pos.func_177952_p() - entity.center.chunkOffset.func_177952_p()) * 16 - entity.center.inChunkOffset.func_177952_p();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179137_b((double)offset.field_72450_a, (double)offset.field_72448_b, (double)offset.field_72449_c);
            GlStateManager.func_179137_b((double)entity.center.rotationCenterInsideBlock.x, (double)entity.center.rotationCenterInsideBlock.y, (double)entity.center.rotationCenterInsideBlock.z);
            GL11.glRotated((double)rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
            GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
            if (layer == BlockRenderLayer.TRANSLUCENT) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
            } else {
                GlStateManager.func_179084_k();
                GlStateManager.func_179141_d();
            }
            GlStateManager.func_179137_b((double)(-entity.center.rotationCenterInsideBlock.x), (double)(-entity.center.rotationCenterInsideBlock.y), (double)(-entity.center.rotationCenterInsideBlock.z));
            buffer.func_177359_a();
            if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                ShadersRender.setupArrayPointersVbo();
            } else {
                GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
                GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
                GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            }
            buffer.func_177358_a(7);
            buffer.func_177361_b();
            RenderAnimation.mc.field_71460_t.func_175072_h();
            GlStateManager.func_179121_F();
        }
        if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
            ShadersRender.postRenderChunkLayer((BlockRenderLayer)layer);
        }
    }

    protected ResourceLocation getEntityTexture(EntityAnimation entity) {
        return TextureMap.field_110575_b;
    }

    public static BlockPos getRenderChunkPos(BlockPos blockPos) {
        return new BlockPos(blockPos.func_177958_n() >> 4, blockPos.func_177956_o() >> 4, blockPos.func_177952_p() >> 4);
    }
}

