/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCubeLayerCache {
    private List<LittleRenderingCube> solid;
    private List<LittleRenderingCube> cutout_mipped;
    private List<LittleRenderingCube> cutout;
    private List<LittleRenderingCube> translucent;

    public List<LittleRenderingCube> getCubesByLayer(BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                return this.solid;
            }
            case CUTOUT_MIPPED: {
                return this.cutout_mipped;
            }
            case CUTOUT: {
                return this.cutout;
            }
            case TRANSLUCENT: {
                return this.translucent;
            }
        }
        return null;
    }

    public void setCubesByLayer(List<LittleRenderingCube> cubes, BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                this.solid = cubes;
                break;
            }
            case CUTOUT_MIPPED: {
                this.cutout_mipped = cubes;
                break;
            }
            case CUTOUT: {
                this.cutout = cubes;
                break;
            }
            case TRANSLUCENT: {
                this.translucent = cubes;
            }
        }
    }

    public boolean doesNeedUpdate() {
        return this.solid == null || this.cutout_mipped == null || this.cutout == null || this.translucent == null;
    }

    public void clearCache() {
        this.solid = null;
        this.cutout_mipped = null;
        this.cutout = null;
        this.translucent = null;
    }

    public void sortCache() {
        if (!OptifineHelper.isActive()) {
            return;
        }
        Iterator<LittleRenderingCube> iterator = this.solid.iterator();
        while (iterator.hasNext()) {
            LittleRenderingCube littleRenderingCube = iterator.next();
            if (!littleRenderingCube.isEmissive) continue;
            this.cutout_mipped.add(littleRenderingCube);
            iterator.remove();
        }
    }
}

