/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.tweaks;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.config.ModConfig;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TweakToolBreaking {
    public static Map<Item, Integer> overrides = new HashMap<Item, Integer>();

    public static void configure(Configuration config) {
        ConfigCategory category = config.getCategory("tweaks");
        String[] values = config.get(category.getName(), "tool_breaking_thresholds", new String[0]).getStringList();
        category.get("tool_breaking_thresholds").setComment("Here you can define custom tool breaking thresholds for tools.\n- Syntax: modid:itemid=threshold\n- Example: minecraft:iron_pickaxe=20\n- This makes it so Iron Pickaxes become useless with 20 uses left.\n- This config is mostly meant for things like TF hammers that use more than 1 durability at a time, if they don't already work fine.");
        for (String value : values) {
            int threshold;
            String[] parts = value.split("=");
            if (parts.length != 2) {
                PickleTweaks.LOGGER.error("Invalid tool breaking threshold syntax length: " + value);
                continue;
            }
            String[] name = parts[0].split(":");
            try {
                threshold = Integer.valueOf(parts[1]);
            }
            catch (NumberFormatException e) {
                PickleTweaks.LOGGER.error("Invalid tool breaking threshold value: " + value);
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name[0], name[1]));
            if (item == null) continue;
            overrides.put(item, threshold);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        if (!ModConfig.confBrokenTools) {
            return;
        }
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemTool) && !(stack.func_77973_b() instanceof ItemSword)) {
            return;
        }
        if (stack.func_77984_f() && TweakToolBreaking.isBroken(stack, stack.func_77973_b() instanceof ItemSword ? 1 : 0)) {
            event.setNewSpeed(0.0f);
        }
    }

    public void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        if (!ModConfig.confBrokenTools) {
            return;
        }
        if (event.getHarvester() == null) {
            return;
        }
        ItemStack stack = event.getHarvester().func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77984_f() && TweakToolBreaking.isBroken(stack, stack.func_77973_b() instanceof ItemSword ? 1 : 0)) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!ModConfig.confBrokenTools) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemTool) && !(stack.func_77973_b() instanceof ItemSword)) {
            return;
        }
        if (stack.func_77984_f() && TweakToolBreaking.isBroken(stack, stack.func_77973_b() instanceof ItemSword ? 1 : 0)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onUseHoe(UseHoeEvent event) {
        if (!ModConfig.confBrokenTools) {
            return;
        }
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemHoe)) {
            return;
        }
        if (stack.func_77984_f() && TweakToolBreaking.isBroken(stack, 0)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onHitEntity(LivingHurtEvent event) {
        int unbreaking;
        if (!ModConfig.confBrokenTools) {
            return;
        }
        if (!event.getSource().func_76355_l().equals("player")) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemHoe)) {
            return;
        }
        if (stack.func_77984_f() && TweakToolBreaking.isBroken(stack, (unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack)) > 0 ? 1 : 0)) {
            if (overrides.containsKey(stack.func_77973_b())) {
                stack.func_77964_b(stack.func_77958_k() - overrides.get(stack.func_77973_b()));
            } else {
                stack.func_77964_b(stack.func_77958_k() - 1);
            }
            event.setAmount(0.5f);
        }
    }

    @SubscribeEvent
    public void onUseBow(PlayerInteractEvent.RightClickItem event) {
        if (!ModConfig.confBrokenTools) {
            return;
        }
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemBow)) {
            return;
        }
        if (stack.func_77984_f() && TweakToolBreaking.isBroken(stack, 0)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onUseShovel(PlayerInteractEvent.RightClickBlock event) {
        if (!ModConfig.confBrokenTools) {
            return;
        }
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSpade)) {
            return;
        }
        if (stack.func_77984_f() && TweakToolBreaking.isBroken(stack, 0)) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!ModConfig.confBrokenTools) {
            return;
        }
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!(stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemHoe || stack.func_77973_b() instanceof ItemBow)) {
            return;
        }
        ListIterator<String> itr = event.getToolTip().listIterator();
        if (stack.func_77984_f() && TweakToolBreaking.isBroken(stack, stack.func_77973_b() instanceof ItemSword ? 1 : 0)) {
            if (itr.hasNext()) {
                itr.next();
                itr.add("\u00a7c" + Utils.localize((String)"tooltip.pt.broken"));
            }
            while (itr.hasNext()) {
                if (!((String)itr.next()).contains(I18n.func_74838_a((String)"attribute.name.generic.attackDamage"))) continue;
                itr.set(" 0.5 " + Utils.localize((String)"attribute.name.generic.attackDamage"));
            }
        }
    }

    public static boolean isBroken(ItemStack stack, int offset) {
        int baseOffset = offset;
        if (overrides.containsKey(stack.func_77973_b())) {
            offset += overrides.get(stack.func_77973_b()).intValue();
        }
        return stack.func_77958_k() > 1 + baseOffset && stack.func_77952_i() >= stack.func_77958_k() - offset;
    }
}

