/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait.charger;

import com.tictim.ceu.energy.ElectricItemFE;
import com.tictim.ceu.energy.EnergyStorageGteu;
import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.mte.trait.charger.ChargeHandler;
import com.tictim.ceu.util.Numbers;
import gregtech.api.capability.IElectricItem;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ChargeHandlerFE
extends ChargeHandler {
    public ChargeHandlerFE(MTECeu ceu) {
        super(ceu);
    }

    @Override
    public Number getStoredSum(Energy e, boolean includeWrapped) {
        if (e == Energy.GTEU) {
            return this.storedEU(includeWrapped);
        }
        if (e != Energy.FE) {
            throw new IllegalArgumentException();
        }
        return this.storedFE(Integer.MAX_VALUE, includeWrapped);
    }

    @Override
    public Number getCapacitySum(Energy e, boolean includeWrapped) {
        if (e == Energy.GTEU) {
            return this.capacityEU(includeWrapped);
        }
        if (e != Energy.FE) {
            throw new IllegalArgumentException();
        }
        return this.capacityFE(Integer.MAX_VALUE, includeWrapped);
    }

    @Override
    public Number extractEnergy(Energy e, Number max, boolean extractWrapped, boolean simulate) {
        if (e == Energy.GTEU) {
            return this.dischargeEU(max.longValue(), false, true, extractWrapped, simulate);
        }
        if (e != Energy.FE) {
            throw new IllegalArgumentException();
        }
        return this.dischargeFE(max.longValue(), extractWrapped, simulate);
    }

    @Override
    public Number insertEnergy(Energy e, Number max, boolean insertWrapped, boolean simulate) {
        if (e == Energy.GTEU) {
            return this.chargeEU(max.longValue(), false, insertWrapped, simulate);
        }
        if (e != Energy.FE) {
            throw new IllegalArgumentException();
        }
        return this.chargeFE(max.longValue(), insertWrapped, simulate);
    }

    public long chargeFE(long maxReceive, boolean chargeWrapped, boolean simulate) {
        if (maxReceive <= 0L) {
            return 0L;
        }
        long total = 0L;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IEnergyStorage storage;
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || (storage = this.getItemEnergyStorage(s, chargeWrapped)) == null || (total += (long)storage.receiveEnergy((int)Math.min(maxReceive - total, Integer.MAX_VALUE), simulate)) < maxReceive) continue;
            return maxReceive;
        }
        return total;
    }

    public long dischargeFE(long maxExtract, boolean dischargeWrapped, boolean simulate) {
        if (maxExtract <= 0L) {
            return 0L;
        }
        long total = 0L;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IEnergyStorage storage;
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || (storage = this.getItemEnergyStorage(s, dischargeWrapped)) == null || (total += (long)storage.extractEnergy((int)Math.min(maxExtract - total, Integer.MAX_VALUE), simulate)) < maxExtract) continue;
            return maxExtract;
        }
        return total;
    }

    public long capacityFE(long limit, boolean includeWrapped) {
        if (limit <= 0L) {
            return 0L;
        }
        long total = 0L;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IEnergyStorage storage;
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || (storage = this.getItemEnergyStorage(s, includeWrapped)) == null || (total = Numbers.addWithOverflowCheck((long)storage.getMaxEnergyStored(), total)) < limit) continue;
            return limit;
        }
        return total;
    }

    public long storedFE(long limit, boolean includeWrapped) {
        if (limit <= 0L) {
            return 0L;
        }
        long total = 0L;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IEnergyStorage storage;
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || (storage = this.getItemEnergyStorage(s, includeWrapped)) == null || (total = Numbers.addWithOverflowCheck((long)storage.getEnergyStored(), total)) < limit) continue;
            return limit;
        }
        return total;
    }

    @Override
    @Nullable
    protected IElectricItem getWrappedBatteryContainer(ItemStack s) {
        IEnergyStorage storage = this.getItemEnergyStorage(s, false);
        return storage != null ? new ElectricItemFE(this.ceu, storage) : null;
    }

    @Nullable
    protected IEnergyStorage getItemEnergyStorage(ItemStack s, boolean wrapEUBattery) {
        IEnergyStorage storage = (IEnergyStorage)s.getCapability(CapabilityEnergy.ENERGY, null);
        if (storage != null && (this.ceu.isCeu() ? storage.canReceive() : storage.canExtract())) {
            return storage;
        }
        if (wrapEUBattery) {
            IElectricItem i = this.getBatteryContainer(s, false);
            return i != null ? new EnergyStorageGteu(this.ceu, i) : null;
        }
        return null;
    }
}

