/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait;

import com.tictim.ceu.energy.Ic2EuFlag;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.util.Numbers;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TraitIc2EuIn
extends MTETrait {
    private final MTECeu ceu;
    private SinkWrapper sinkWrapper;

    public TraitIc2EuIn(MTECeu ceu) {
        super((MetaTileEntity)ceu);
        this.ceu = ceu;
    }

    public String getName() {
        return "TraitIc2EuIn";
    }

    public int getNetworkID() {
        return 0;
    }

    @Nullable
    public Capability<?> getImplementingCapability() {
        return Ic2EuFlag.CAP;
    }

    public void update() {
        if (!this.ceu.getWorld().field_72995_K && this.sinkWrapper == null) {
            this.sinkWrapper = new SinkWrapper();
            if (Loader.isModLoaded((String)"ic2")) {
                this.sinkWrapper.addToENet();
            }
        }
    }

    @Optional.InterfaceList(value={@Optional.Interface(modid="ic2", iface="ic2.api.energy.tile.IEnergySink"), @Optional.Interface(modid="ic2", iface="ic2.api.energy.tile.IEnergyEmitter"), @Optional.Interface(modid="ic2", iface="ic2.api.energy.tile.IEnergyTile")})
    private class SinkWrapper
    extends TileEntity
    implements IEnergySink {
        private SinkWrapper() {
            this.func_145834_a(TraitIc2EuIn.this.ceu.getWorld());
            this.func_174878_a(TraitIc2EuIn.this.ceu.getPos());
        }

        @Optional.Method(modid="ic2")
        public void addToENet() {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }

        @Optional.Method(modid="ic2")
        public void removeFromENet() {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }

        @Optional.Method(modid="ic2")
        public double getDemandedEnergy() {
            long a = TraitIc2EuIn.this.ceu.getEnergyStorage().getEnergyCapacity() - TraitIc2EuIn.this.ceu.getEnergyStorage().getEnergyStored();
            return a <= 0L ? 0.0 : TraitIc2EuIn.this.ceu.ratio().reverse().convertToDouble(a);
        }

        @Optional.Method(modid="ic2")
        public int getSinkTier() {
            return TraitIc2EuIn.this.ceu.getTier();
        }

        @Optional.Method(modid="ic2")
        public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
            if (TraitIc2EuIn.this.ceu.getFrontFacing() != directionFrom && amount > 0.0 && voltage > 0.0) {
                long consumedAmpere;
                long voltageGt = Numbers.toLong(voltage);
                long amountGt = TraitIc2EuIn.this.ceu.ratio().convertToLong(amount);
                long ampere = amountGt / voltageGt;
                if (ampere > 0L && (consumedAmpere = TraitIc2EuIn.this.ceu.getEnergyStorage().acceptEnergyFromNetwork(directionFrom, voltageGt, ampere)) <= 0L) {
                    return Math.max(amount - TraitIc2EuIn.this.ceu.ratio().reverse().convertToDouble(consumedAmpere * voltageGt), 0.0);
                }
            }
            return amount;
        }

        @Optional.Method(modid="ic2")
        public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
            return TraitIc2EuIn.this.ceu.getFrontFacing() != side;
        }
    }
}

