/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.tictim.ceu.CeuResources;
import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteEnergy;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.SimpleOverlayRenderer;
import gregtech.api.render.SimpleSidedCubeRenderer;
import gregtech.api.render.Textures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MTEInfiniteEnergy
extends MetaTileEntity {
    protected TraitInfiniteEnergy trait;
    private final Energy energy;
    private final boolean isEmitter;

    public MTEInfiniteEnergy(ResourceLocation metaTileEntityId, Energy energy, boolean isEmitter) {
        super(metaTileEntityId);
        this.energy = energy;
        this.isEmitter = isEmitter;
        this.initTrait();
    }

    protected void initTrait() {
        this.trait = this.isEmitter ? this.energy.createInfiniteEnergyEmitterTrait(this) : this.energy.createInfiniteEnergyReceiverTrait(this);
    }

    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MTEInfiniteEnergy(this.metaTileEntityId, this.energy, this.isEmitter);
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.trait.createUI((IUIHolder)this.getHolder(), entityPlayer);
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.VOLTAGE_CASINGS[9].render(renderState, translation, pipeline);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.getOverlay().renderSided(facing, renderState, translation, pipeline);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected SimpleOverlayRenderer getOverlay() {
        return (SimpleOverlayRenderer)(this.isEmitter ? CeuResources.EMITTER_FACES : CeuResources.RECEIVER_FACES).get((Object)this.energy);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return Textures.VOLTAGE_CASINGS[9].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.TOP);
    }
}

