/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.config;

import com.google.common.collect.ImmutableMap;
import com.tictim.ceu.Ceu;
import com.tictim.ceu.config.Configurable;
import com.tictim.ceu.config.PropertyHandler;
import com.tictim.ceu.enums.CeuType;
import com.tictim.ceu.enums.ConverterType;
import com.tictim.ceu.enums.UseGACircuit;
import com.tictim.ceu.message.MessageConfigSync;
import com.tictim.ceu.util.Ratio;
import gregtech.api.GTValues;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public final class CeuConfig
implements Configurable {
    public static final String COMMENT_CIRCUIT_TYPE = "'GTCE' for GTCE default circuit.\n'GA' for Gregic Additions circuit(circuitGA~~).\nOtherwise, it depends on whether or not GA is installed.";
    private static Configuration cfg;
    private static CeuConfig config;
    @Nullable
    private static CeuConfig configSynced;
    private final ImmutableMap<CeuType, CeuVoltageCategory> ceuSettings;
    private final UseGACircuit useGACircuit;

    public static void load(FMLPreInitializationEvent event) {
        File fileRetro = new File(event.getModConfigurationDirectory(), "gregtech_ceu.cfg");
        Configuration retro = fileRetro.exists() ? new Configuration(fileRetro) : null;
        cfg = new Configuration(new File(event.getModConfigurationDirectory(), "ceu.cfg"));
        config = new CeuConfig(retro);
        cfg.save();
    }

    @SubscribeEvent
    public static void reregister(RegistryEvent.Register event) {
        configSynced = null;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            Ceu.NET.sendTo((IMessage)new MessageConfigSync(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ceu")) {
            config = new CeuConfig(cfg);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                    Ceu.NET.sendTo((IMessage)new MessageConfigSync(), p);
                }
            }
            cfg.save();
        }
    }

    public static CeuConfig instance() {
        return configSynced == null ? config : configSynced;
    }

    public static CeuConfig dedicatedInstance() {
        return config;
    }

    public static void setSyncedConfig(@Nullable CeuConfig config) {
        configSynced = config;
    }

    public CeuConfig(@Nullable Configuration retro) {
        this.useGACircuit = UseGACircuit.get(new PropertyHandler(cfg, "general", "circuitsUsing", "", COMMENT_CIRCUIT_TYPE).requiresMcRestart().replace(new PropertyHandler(retro, "general", "circuitsUsing", "", COMMENT_CIRCUIT_TYPE)).getString());
        ImmutableMap.Builder b = new ImmutableMap.Builder();
        for (CeuType type : CeuType.values()) {
            b.put((Object)type, (Object)new CeuVoltageCategory(retro, type));
        }
        this.ceuSettings = b.build();
    }

    public CeuConfig(NBTTagCompound nbt) {
        this.useGACircuit = UseGACircuit.get(nbt.func_74779_i("circuitsUsing"));
        ImmutableMap.Builder b = new ImmutableMap.Builder();
        for (CeuType type : CeuType.values()) {
            b.put((Object)type, (Object)new CeuVoltageCategory(nbt, type));
        }
        this.ceuSettings = b.build();
    }

    public boolean useGACircuit() {
        return this.useGACircuit.useGACircuit();
    }

    public boolean isDisabled(CeuType type, int tier) {
        return ((CeuVoltageCategory)this.ceuSettings.get((Object)type)).getSetting(tier).disable;
    }

    public Ratio getRatio(CeuType type, int tier) {
        return ((CeuVoltageCategory)this.ceuSettings.get((Object)type)).getSetting(tier).conversionRatio;
    }

    @Override
    public void collectProperties(List<IConfigElement> list) {
        list.add((IConfigElement)new ConfigElement(cfg.getCategory("general")));
    }

    @Override
    public void serialize(NBTTagCompound nbt) {
        nbt.func_74778_a("circuitsUsing", this.useGACircuit.toString());
        for (CeuVoltageCategory category : this.ceuSettings.values()) {
            category.serialize(nbt);
        }
    }

    private static class CeuSetting
    implements Configurable {
        private final CeuType type;
        private final int tier;
        private final String category;
        private final Ratio conversionRatio;
        private final boolean disable;

        public CeuSetting(@Nullable Configuration retro, CeuType type, int tier) {
            this.type = type;
            this.tier = tier;
            this.category = "general." + type.toString().toLowerCase() + "." + GTValues.VN[tier];
            if (type.getConverterType() == ConverterType.CEU_CEF) {
                this.conversionRatio = Ratio.ratioOf(new PropertyHandler(cfg, this.category, "conversionRatio", type.getDefaultConversionRate().toString(), "Conversion ratio between two energy units (INPUT:OUTPUT)").replace(new PropertyHandler(retro, GTValues.VN[tier], type == CeuType.CEU ? "CEURatio" : "CEFRatio", "4:1", ""), (p, pRetro) -> {
                    if (type == CeuType.CEU) {
                        p.set(Ratio.PATTERN.matcher(pRetro.getString()).replaceAll("$2:$1"));
                    } else {
                        p.set(pRetro.getString());
                    }
                }), type.getDefaultConversionRate());
                this.disable = new PropertyHandler(cfg, this.category, "disable", false, "").replace(new PropertyHandler(retro, GTValues.VN[tier], type == CeuType.CEU ? "CEUDisabled" : "CEFDisabled", false, "")).getBoolean();
            } else {
                this.conversionRatio = Ratio.ratioOf(cfg.get(this.category, "conversionRatio", type.getDefaultConversionRate().toString(), "Conversion ratio between two energy units (INPUT:OUTPUT)"), type.getDefaultConversionRate());
                this.disable = cfg.get(this.category, "disable", false, "").getBoolean();
            }
        }

        public CeuSetting(NBTTagCompound nbt, CeuType type, int tier) {
            this.type = type;
            this.tier = tier;
            this.category = "general." + type.toString().toLowerCase() + "." + GTValues.VN[tier];
            NBTTagCompound subnbt = nbt.func_74775_l(GTValues.VN[tier]);
            this.conversionRatio = Ratio.ratioOf(subnbt);
            this.disable = subnbt.func_74767_n("disable");
        }

        @Override
        public void collectProperties(List<IConfigElement> list) {
            list.add((IConfigElement)new ConfigElement(cfg.get(this.category, "conversionRatio", this.type.getDefaultConversionRate().toString(), "Conversion ratio between two energy units (INPUT:OUTPUT)")));
            list.add((IConfigElement)new ConfigElement(cfg.get(this.category, "disable", false, "")));
        }

        @Override
        public void serialize(NBTTagCompound nbt) {
            NBTTagCompound subnbt = new NBTTagCompound();
            subnbt.func_74757_a("disable", this.disable);
            this.conversionRatio.serialize(subnbt);
            nbt.func_74782_a(GTValues.VN[this.tier], (NBTBase)subnbt);
        }
    }

    private static class CeuVoltageCategory
    implements Configurable {
        private final CeuType type;
        private final CeuSetting[] settings;

        public CeuVoltageCategory(@Nullable Configuration retro, CeuType type) {
            this.type = type;
            this.settings = new CeuSetting[type.getConverterType().getMaxTier() - type.getConverterType().getMinTier()];
            for (int i = 0; i < this.settings.length; ++i) {
                this.settings[i] = new CeuSetting(retro, type, i + type.getConverterType().getMinTier());
            }
        }

        public CeuVoltageCategory(NBTTagCompound nbt, CeuType type) {
            this.type = type;
            NBTTagCompound subnbt = nbt.func_74775_l(type.name().toLowerCase());
            this.settings = new CeuSetting[type.getConverterType().getMaxTier() - type.getConverterType().getMinTier()];
            for (int i = 0; i < this.settings.length; ++i) {
                this.settings[i] = new CeuSetting(subnbt, type, i + type.getConverterType().getMinTier());
            }
        }

        public CeuSetting getSetting(int tier) {
            return this.settings[MathHelper.func_76125_a((int)tier, (int)this.type.getConverterType().getMinTier(), (int)this.type.getConverterType().getMaxTier()) - this.type.getConverterType().getMinTier()];
        }

        @Override
        public void collectProperties(List<IConfigElement> list) {
            for (CeuSetting setting : this.settings) {
                setting.collectProperties(list);
            }
        }

        @Override
        public void serialize(NBTTagCompound nbt) {
            NBTTagCompound subnbt = new NBTTagCompound();
            for (CeuSetting setting : this.settings) {
                setting.serialize(subnbt);
            }
            if (!subnbt.func_82582_d()) {
                nbt.func_74782_a(this.type.name().toLowerCase(), (NBTBase)subnbt);
            }
        }
    }
}

