/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.endermini;

import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelEnderman;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;
import teamroots.emberroot.config.ConfigManager;
import teamroots.emberroot.entity.endermini.EntityEnderminy;
import teamroots.emberroot.util.RenderUtil;

public class RenderEnderminy
extends RenderLiving<EntityEnderminy> {
    private static final ResourceLocation endermanEyesTexture = new ResourceLocation("emberroot", "textures/entity/enderminy_eyes.png");
    private ModelEnderman endermanModel;
    private Random rnd = new Random();

    public RenderEnderminy(RenderManager rm) {
        super(rm, (ModelBase)new ModelEnderman(0.0f), 0.5f);
        this.endermanModel = (ModelEnderman)this.field_77045_g;
        this.func_177094_a(new EyesLayer());
    }

    public void doRender(EntityEnderminy entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.endermanModel.field_78125_b = entity.isScreaming();
        if (entity.isScreaming()) {
            double d3 = 0.02;
            x += this.rnd.nextGaussian() * d3;
            z += this.rnd.nextGaussian() * d3;
        }
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        if (ConfigManager.renderDebugHitboxes) {
            RenderUtil.renderEntityBoundingBox((EntityLiving)entity, x, y, z);
        }
    }

    protected ResourceLocation getEntityTexture(EntityEnderminy entity) {
        String colour = entity.getVariantEnum().nameLower();
        return new ResourceLocation("emberroot", "textures/entity/endermini_" + colour + ".png");
    }

    protected void preRenderCallback(EntityEnderminy entity, float partialTickTime) {
        float s;
        this.field_76989_e = s = entity.getSizeSaved().floatValue();
        GL11.glScalef((float)s, (float)(s / 2.0f), (float)s);
    }

    public static class Factory
    implements IRenderFactory<EntityEnderminy> {
        public Render<? super EntityEnderminy> createRenderFor(RenderManager manager) {
            return new RenderEnderminy(manager);
        }
    }

    private class EyesLayer
    implements LayerRenderer<EntityEnderminy> {
        private EyesLayer() {
        }

        public void doRenderLayer(EntityEnderminy em, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            RenderEnderminy.this.func_110776_a(endermanEyesTexture);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((!em.func_82150_aj() ? 1 : 0) != 0);
            int i = 61680;
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179145_e();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderEnderminy.this.func_177087_b().func_78088_a((Entity)em, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            RenderEnderminy.this.func_177105_a((EntityLiving)em);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

