/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.IFixableData;

public abstract class TEFixer
implements IFixableData {
    private final Map<String, String> tileEntityNames = new HashMap<String, String>();

    protected abstract void lazyInit();

    protected void putEntry(String oldName, String newName) {
        this.tileEntityNames.put(oldName, newName);
        this.tileEntityNames.put("minecraft:" + oldName.toLowerCase(), newName);
    }

    public int func_188216_a() {
        return 1;
    }

    @Nonnull
    public NBTTagCompound func_188217_a(@Nonnull NBTTagCompound compound) {
        String tileEntityLocation;
        if (this.tileEntityNames.isEmpty()) {
            this.lazyInit();
        }
        if ((tileEntityLocation = compound.func_74779_i("id")).equals("mcmultipart:multipart.ticking") || tileEntityLocation.equals("mcmultipart:multipart.nonticking")) {
            if (compound.func_74764_b("parts")) {
                NBTTagCompound parts = compound.func_74775_l("parts");
                for (String sID : parts.func_150296_c()) {
                    NBTTagCompound part = parts.func_74775_l(sID);
                    if (!part.func_74764_b("tile")) continue;
                    this.func_188217_a(part.func_74775_l("tile"));
                }
            }
        } else {
            compound.func_74778_a("id", this.tileEntityNames.getOrDefault(tileEntityLocation, tileEntityLocation));
        }
        return compound;
    }

    public static class Generators
    extends TEFixer {
        @Override
        protected void lazyInit() {
            this.putEntry("ReactorFrame", "mekanismgenerators:reactor_frame");
            this.putEntry("ReactorGlass", "mekanismgenerators:reactor_glass");
            this.putEntry("ReactorLaserFocus", "mekanismgenerators:reactor_laser_focus");
            this.putEntry("ReactorPort", "mekanismgenerators:reactor_port");
            this.putEntry("ReactorLogicAdapter", "mekanismgenerators:reactor_logic_adapter");
            this.putEntry("RotationalComplex", "mekanismgenerators:rotational_complex");
            this.putEntry("ElectromagneticCoil", "mekanismgenerators:electromagnetic_coil");
            this.putEntry("SaturatingCondenser", "mekanismgenerators:saturating_condenser");
            this.putEntry("AdvancedSolarGenerator", "mekanismgenerators:advanced_solar_generator");
            this.putEntry("SolarGenerator", "mekanismgenerators:solar_generator");
            this.putEntry("BioGenerator", "mekanismgenerators:bio_generator");
            this.putEntry("HeatGenerator", "mekanismgenerators:heat_generator");
            this.putEntry("GasGenerator", "mekanismgenerators:gas_generator");
            this.putEntry("WindTurbine", "mekanismgenerators:wind_turbine");
            this.putEntry("ReactorController", "mekanismgenerators:reactor_controller");
            this.putEntry("TurbineRod", "mekanismgenerators:turbine_rod");
            this.putEntry("TurbineCasing", "mekanismgenerators:turbine_casing");
            this.putEntry("TurbineValve", "mekanismgenerators:turbine_valve");
            this.putEntry("TurbineVent", "mekanismgenerators:turbine_vent");
        }
    }

    public static class Mekanism
    extends TEFixer {
        @Override
        protected void lazyInit() {
            this.putEntry("BoundingBlock", "mekanism:bounding_block");
            this.putEntry("AdvancedBoundingBlock", "mekanism:advanced_bounding_block");
            this.putEntry("CardboardBox", "mekanism:cardboard_box");
            this.putEntry("ThermalEvaporationValve", "mekanism:thermal_evaporation_valve");
            this.putEntry("ThermalEvaporationBlock", "mekanism:thermal_evaporation_block");
            this.putEntry("PressureDisperser", "mekanism:pressure_disperser");
            this.putEntry("SuperheatingElement", "mekanism:superheating_element");
            this.putEntry("Laser", "mekanism:laser");
            this.putEntry("AmbientAccumulator", "mekanism:ambient_accumulator");
            this.putEntry("InductionCasing", "mekanism:induction_casing");
            this.putEntry("InductionPort", "mekanism:induction_port");
            this.putEntry("InductionCell", "mekanism:induction_cell");
            this.putEntry("InductionProvider", "mekanism:induction_provider");
            this.putEntry("Oredictionificator", "mekanism:oredictionificator");
            this.putEntry("StructuralGlass", "mekanism:structural_glass");
            this.putEntry("FuelwoodHeater", "mekanism:fuelwood_heater");
            this.putEntry("LaserAmplifier", "mekanism:laser_amplifier");
            this.putEntry("LaserTractorBeam", "mekanism:laser_tractor_beam");
            this.putEntry("ChemicalWasher", "mekanism:chemical_washer");
            this.putEntry("ElectrolyticSeparator", "mekanism:electrolytic_separator");
            this.putEntry("ChemicalOxidizer", "mekanism:chemical_oxidizer");
            this.putEntry("ChemicalInfuser", "mekanism:chemical_infuser");
            this.putEntry("RotaryCondensentrator", "mekanism:rotary_condensentrator");
            this.putEntry("ElectricPump", "mekanism:electric_pump");
            this.putEntry("FluidicPlenisher", "mekanism:fluidic_plenisher");
            this.putEntry("GlowPanel", "mekanism:glow_panel");
            this.putEntry("EnrichmentChamber", "mekanism:enrichment_chamber");
            this.putEntry("OsmiumCompressor", "mekanism:osmium_compressor");
            this.putEntry("Combiner", "mekanism:combiner");
            this.putEntry("Crusher", "mekanism:crusher");
            this.putEntry("SmeltingFactory", "mekanism:smelting_factory");
            this.putEntry("AdvancedSmeltingFactory", "mekanism:advanced_smelting_factory");
            this.putEntry("UltimateSmeltingFactory", "mekanism:ultimate_smelting_factory");
            this.putEntry("PurificationChamber", "mekanism:purification_chamber");
            this.putEntry("EnergizedSmelter", "mekanism:energized_smelter");
            this.putEntry("MetallurgicInfuser", "mekanism:metallurgic_infuser");
            this.putEntry("GasTank", "mekanism:gas_tank");
            this.putEntry("EnergyCube", "mekanism:energy_cube");
            this.putEntry("PersonalChest", "mekanism:personal_chest");
            this.putEntry("DynamicTank", "mekanism:dynamic_tank");
            this.putEntry("DynamicValve", "mekanism:dynamic_valve");
            this.putEntry("Chargepad", "mekanism:chargepad");
            this.putEntry("LogisticalSorter", "mekanism:logistical_sorter");
            this.putEntry("Bin", "mekanism:bin");
            this.putEntry("DigitalMiner", "mekanism:digital_miner");
            this.putEntry("MekanismTeleporter", "mekanism:mekanism_teleporter");
            this.putEntry("ChemicalInjectionChamber", "mekanism:chemical_injection_chamber");
            this.putEntry("ThermalEvaporationController", "mekanism:thermal_evaporation_controller");
            this.putEntry("PrecisionSawmill", "mekanism:precision_sawmill");
            this.putEntry("ChemicalCrystallizer", "mekanism:chemical_crystallizer");
            this.putEntry("SeismicVibrator", "mekanism:seismic_vibrator");
            this.putEntry("PressurizedReactionChamber", "mekanism:pressurized_reaction_chamber");
            this.putEntry("FluidTank", "mekanism:fluid_tank");
            this.putEntry("SolarNeutronActivator", "mekanism:solar_neutron_activator");
            this.putEntry("FormulaicAssemblicator", "mekanism:formulaic_assemblicator");
            this.putEntry("ResistiveHeater", "mekanism:resistive_heater");
            this.putEntry("BoilerCasing", "mekanism:boiler_casing");
            this.putEntry("BoilerValve", "mekanism:boiler_valve");
            this.putEntry("SecurityDesk", "mekanism:security_desk");
            this.putEntry("QuantumEntangloporter", "mekanism:quantum_entangloporter");
            this.putEntry("ChemicalDissolutionChamber", "mekanism:chemical_dissolution_chamber");
            this.putEntry("MechanicalPipe", "mekanism:mechanical_pipe");
            this.putEntry("UniversalCable", "mekanism:universal_cable");
            this.putEntry("ThermodynamicConductor", "mekanism:thermodynamic_conductor");
            this.putEntry("LogisticalTransporter", "mekanism:logistical_transporter");
            this.putEntry("PressurizedTube", "mekanism:pressurized_tube");
            this.putEntry("DiversionTransporter", "mekanism:diversion_transporter");
            this.putEntry("RestrictiveTransporter", "mekanism:restrictive_transporter");
        }
    }
}

