/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.LogHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientAny;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.solarneutronactivator")
@ModOnly(value="mtlib")
@ZenRegister
public class SolarNeutronActivator {
    public static final String NAME = "Mekanism Solar Neutron Activator";

    @ZenMethod
    public static void addRecipe(IGasStack gasInput, IGasStack gasOutput) {
        if (gasInput == null || gasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        SolarNeutronRecipe recipe = new SolarNeutronRecipe(GasHelper.toGas(gasInput), GasHelper.toGas(gasOutput));
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe<GasInput, SolarNeutronRecipe>(NAME, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient gasInput, @Optional IIngredient gasOutput) {
        if (gasInput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (gasOutput == null) {
            gasOutput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get(), gasInput, gasOutput));
    }

    private static class Remove
    extends RemoveMekanismRecipe<GasInput, SolarNeutronRecipe> {
        private IIngredient gasInput;
        private IIngredient gasOutput;

        public Remove(String name, Map<GasInput, SolarNeutronRecipe> map, IIngredient gasInput, IIngredient gasOutput) {
            super(name, map);
            this.gasInput = gasInput;
            this.gasOutput = gasOutput;
        }

        @Override
        public void addRecipes() {
            HashMap<GasInput, SolarNeutronRecipe> recipesToRemove = new HashMap<GasInput, SolarNeutronRecipe>();
            for (Map.Entry<GasInput, SolarNeutronRecipe> entry : RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get().entrySet()) {
                CraftTweakerGasStack inputGas = new CraftTweakerGasStack(entry.getKey().ingredient);
                CraftTweakerGasStack outputGas = new CraftTweakerGasStack(((GasOutput)entry.getValue().recipeOutput).output);
                if (!GasHelper.matches(this.gasInput, inputGas) || !GasHelper.matches(this.gasOutput, outputGas)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logInfo((String)String.format("No %s recipe found for %s and %s. Command ignored!", SolarNeutronActivator.NAME, this.gasInput.toString(), this.gasOutput.toString()));
            }
        }
    }
}

