/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.chemical.crystallizer")
@ModOnly(value="mtlib")
@ZenRegister
public class ChemicalCrystallizer {
    public static final String NAME = "Mekanism Chemical Crystallizer";

    @ZenMethod
    public static void addRecipe(IGasStack gasInput, IItemStack itemOutput) {
        if (gasInput == null || itemOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        CrystallizerRecipe recipe = new CrystallizerRecipe(GasHelper.toGas(gasInput), InputHelper.toStack((IItemStack)itemOutput));
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe<GasInput, CrystallizerRecipe>(NAME, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient gasInput) {
        if (itemOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (gasInput == null) {
            gasInput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get(), itemOutput, gasInput));
    }

    private static class Remove
    extends RemoveMekanismRecipe<GasInput, CrystallizerRecipe> {
        private IIngredient itemOutput;
        private IIngredient gasInput;

        public Remove(String name, Map<GasInput, CrystallizerRecipe> map, IIngredient itemOutput, IIngredient gasInput) {
            super(name, map);
            this.itemOutput = itemOutput;
            this.gasInput = gasInput;
        }

        @Override
        public void addRecipes() {
            HashMap<GasInput, CrystallizerRecipe> recipesToRemove = new HashMap<GasInput, CrystallizerRecipe>();
            for (Map.Entry<GasInput, CrystallizerRecipe> entry : RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get().entrySet()) {
                CraftTweakerGasStack inputGas = new CraftTweakerGasStack(entry.getKey().ingredient);
                IItemStack outputItem = InputHelper.toIItemStack((ItemStack)((ItemStackOutput)entry.getValue().recipeOutput).output);
                if (!StackHelper.matches((IIngredient)this.itemOutput, (IItemStack)outputItem) || !GasHelper.matches(this.gasInput, inputGas)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logInfo((String)String.format("No %s recipe found for %s and %s. Command ignored!", ChemicalCrystallizer.NAME, this.gasInput.toString(), this.itemOutput.toString()));
            }
        }
    }
}

