/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.EnumColor;
import mekanism.common.MekanismItems;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.LangUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public enum Upgrade {
    SPEED("speed", 8, EnumColor.RED),
    ENERGY("energy", 8, EnumColor.BRIGHT_GREEN),
    FILTER("filter", 1, EnumColor.DARK_AQUA),
    GAS("gas", 8, EnumColor.YELLOW),
    MUFFLING("muffling", 4, EnumColor.DARK_GREY),
    ANCHOR("anchor", 1, EnumColor.DARK_GREEN);

    private String name;
    private int maxStack;
    private EnumColor color;

    private Upgrade(String s, int max, EnumColor c) {
        this.name = s;
        this.maxStack = max;
        this.color = c;
    }

    public String getName() {
        return LangUtils.localize("upgrade." + this.name);
    }

    public String getDescription() {
        return LangUtils.localize("upgrade." + this.name + ".desc");
    }

    public int getMax() {
        return this.maxStack;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public boolean canMultiply() {
        return this.getMax() > 1;
    }

    public ItemStack getStack() {
        switch (this) {
            case SPEED: {
                return new ItemStack(MekanismItems.SpeedUpgrade);
            }
            case ENERGY: {
                return new ItemStack(MekanismItems.EnergyUpgrade);
            }
            case FILTER: {
                return new ItemStack(MekanismItems.FilterUpgrade);
            }
            case MUFFLING: {
                return new ItemStack(MekanismItems.MufflingUpgrade);
            }
            case GAS: {
                return new ItemStack(MekanismItems.GasUpgrade);
            }
            case ANCHOR: {
                return new ItemStack(MekanismItems.AnchorUpgrade);
            }
        }
        return ItemStack.field_190927_a;
    }

    public List<String> getInfo(TileEntity tile) {
        List<String> ret = new ArrayList<String>();
        if (tile instanceof IUpgradeTile) {
            if (tile instanceof IUpgradeInfoHandler) {
                return ((IUpgradeInfoHandler)tile).getInfo(this);
            }
            ret = this.getMultScaledInfo((IUpgradeTile)tile);
        }
        return ret;
    }

    public List<String> getMultScaledInfo(IUpgradeTile tile) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.canMultiply()) {
            double effect = Math.pow(MekanismConfig.current().general.maxUpgradeMultiplier.val(), (float)tile.getComponent().getUpgrades(this) / (float)this.getMax());
            ret.add(LangUtils.localize("gui.upgrades.effect") + ": " + (float)Math.round(effect * 100.0) / 100.0f + "x");
        }
        return ret;
    }

    public List<String> getExpScaledInfo(IUpgradeTile tile) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.canMultiply()) {
            double effect = Math.pow(2.0, tile.getComponent().getUpgrades(this));
            ret.add(LangUtils.localize("gui.upgrades.effect") + ": " + effect + "x");
        }
        return ret;
    }

    public static Map<Upgrade, Integer> buildMap(@Nullable NBTTagCompound nbtTags) {
        HashMap<Upgrade, Integer> upgrades = new HashMap<Upgrade, Integer>();
        if (nbtTags != null && nbtTags.func_74764_b("upgrades")) {
            NBTTagList list = nbtTags.func_150295_c("upgrades", 10);
            for (int tagCount = 0; tagCount < list.func_74745_c(); ++tagCount) {
                NBTTagCompound compound = list.func_150305_b(tagCount);
                Upgrade upgrade = Upgrade.values()[compound.func_74762_e("type")];
                upgrades.put(upgrade, compound.func_74762_e("amount"));
            }
        }
        return upgrades;
    }

    public static void saveMap(Map<Upgrade, Integer> upgrades, NBTTagCompound nbtTags) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
            list.func_74742_a((NBTBase)Upgrade.getTagFor(entry.getKey(), entry.getValue()));
        }
        nbtTags.func_74782_a("upgrades", (NBTBase)list);
    }

    public static NBTTagCompound getTagFor(Upgrade upgrade, int amount) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("type", upgrade.ordinal());
        compound.func_74768_a("amount", amount);
        return compound;
    }

    public static interface IUpgradeInfoHandler {
        public List<String> getInfo(Upgrade var1);
    }
}

