/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSideConfigurationTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiTransporterConfigTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerGasTank;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiGasTank
extends GuiMekanism {
    public TileEntityGasTank tileEntity;

    public GuiGasTank(InventoryPlayer inventory, TileEntityGasTank tentity) {
        super(tentity, new ContainerGasTank(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiGasTank.png")));
        this.guiElements.add(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiGasTank.png")));
        this.guiElements.add(new GuiSideConfigurationTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiGasTank.png")));
        this.guiElements.add(new GuiTransporterConfigTab(this, 34, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiGasTank.png")));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiGasTank.png"), 7, 7).with(GuiSlot.SlotOverlay.PLUS));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiGasTank.png"), 7, 39).with(GuiSlot.SlotOverlay.MINUS));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        String stored = "" + (this.tileEntity.gasTank.getStored() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(this.tileEntity.gasTank.getStored()));
        String capacityInfo = stored + " / " + (this.tileEntity.tier.getStorage() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(this.tileEntity.tier.getStorage()));
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(capacityInfo, 45, 40, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.gas") + ": " + (this.tileEntity.gasTank.getGas() != null ? this.tileEntity.gasTank.getGas().getGas().getLocalizedName() : LangUtils.localize("gui.none")), 45, 49, 0x404040, 112);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        String name = this.chooseByMode(this.tileEntity.dumping, LangUtils.localize("gui.idle"), LangUtils.localize("gui.dumping"), LangUtils.localize("gui.dumping_excess"));
        this.field_146289_q.func_78276_b(name, 156 - this.field_146289_q.func_78256_a(name), 73, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiGasTank.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int displayInt = this.chooseByMode(this.tileEntity.dumping, 10, 18, 26);
        this.func_73729_b(guiWidth + 160, guiHeight + 73, 176, displayInt, 8, 8);
        if (this.tileEntity.gasTank.getGas() != null) {
            int scale = (int)((double)this.tileEntity.gasTank.getStored() / (double)this.tileEntity.tier.getStorage() * 72.0);
            this.func_73729_b(guiWidth + 65, guiHeight + 17, 176, 0, scale, 10);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        int xAxis = x - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = y - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis > 160 && xAxis < 169 && yAxis > 73 && yAxis < 82) {
            TileNetworkList data = TileNetworkList.withContents(0);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }

    private <T> T chooseByMode(TileEntityGasTank.GasMode dumping, T idleOption, T dumpingOption, T dumpingExcessOption) {
        if (dumping.equals((Object)TileEntityGasTank.GasMode.IDLE)) {
            return idleOption;
        }
        if (dumping.equals((Object)TileEntityGasTank.GasMode.DUMPING)) {
            return dumpingOption;
        }
        if (dumping.equals((Object)TileEntityGasTank.GasMode.DUMPING_EXCESS)) {
            return dumpingExcessOption;
        }
        return idleOption;
    }
}

