/*
 * Decompiled with CFR 0.152.
 */
package uk.artdude.zenstages.stager;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.mc1120.oredict.MCOreDictEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import uk.artdude.zenstages.common.util.Helper;
import uk.artdude.zenstages.stager.ZenStager;
import uk.artdude.zenstages.stager.type.TypeBase;
import uk.artdude.zenstages.stager.type.TypeContainer;
import uk.artdude.zenstages.stager.type.TypeDimension;
import uk.artdude.zenstages.stager.type.TypeIngredient;
import uk.artdude.zenstages.stager.type.TypeIngredientOverride;
import uk.artdude.zenstages.stager.type.TypeMob;
import uk.artdude.zenstages.stager.type.TypeMod;
import uk.artdude.zenstages.stager.type.TypeMultiBlock;
import uk.artdude.zenstages.stager.type.TypeOre;
import uk.artdude.zenstages.stager.type.TypeOreById;
import uk.artdude.zenstages.stager.type.TypePackage;
import uk.artdude.zenstages.stager.type.TypeRecipeName;
import uk.artdude.zenstages.stager.type.TypeRecipeRegex;
import uk.artdude.zenstages.stager.type.TypeTinker;
import uk.artdude.zenstages.stager.type.enums.MultiBlockType;
import uk.artdude.zenstages.stager.type.enums.TinkerType;
import uk.artdude.zenstages.stager.util.Utils;

@ZenRegister
@ZenClass(value="mods.zenstages.Stage")
public class Stage {
    private String stage;
    private List<TypeBase> stagedEntries = new ArrayList<TypeBase>();

    Stage(String stage) {
        this.stage = stage;
    }

    @ZenGetter(value="stage")
    public String getStage() {
        return this.stage;
    }

    @ZenGetter(value="recipeRegex")
    public String getRecipeRegex() {
        return String.format(Utils.craftTweakerRegex, Utils.formatStage(this), ".*");
    }

    List<ILiquidStack> getStagedLiquids() {
        List<TypeIngredient> stagedIngredients = this.filterEntries(TypeIngredient.class);
        ArrayList<ILiquidStack> stackList = new ArrayList<ILiquidStack>();
        for (TypeIngredient stagedIngredientEntry : stagedIngredients) {
            IIngredient ingredient = (IIngredient)stagedIngredientEntry.getValue();
            if (!(ingredient instanceof ILiquidStack)) continue;
            stackList.add((ILiquidStack)ingredient);
        }
        return stackList;
    }

    Stage getRecipeNameStage(String recipeName) {
        return this.getStage(TypeRecipeName.class, recipeName);
    }

    Stage getDimensionStage(int dimension) {
        return this.getStage(TypeDimension.class, dimension);
    }

    Stage getMobStage(String mobName) {
        return this.getStage(TypeMob.class, mobName);
    }

    Stage getTiCMaterialStage(String material) {
        return this.getStage(TypeTinker.class, material);
    }

    Stage getTiCToolStage(String toolName) {
        return this.getStage(TypeTinker.class, toolName);
    }

    boolean isIngredientStaged(IIngredient ingredient) {
        return this.getIngredientStage(ingredient) != null;
    }

    @ZenMethod
    public boolean isCustomStaged(String slug, String value) {
        return Helper.getCustomTypeByValue(ZenStager.filterCustomByStage(this, slug), value) != null;
    }

    @ZenMethod
    public boolean isCustomStaged(String slug, String[] values) {
        return Helper.getCustomTypeByValue(ZenStager.filterCustomByStage(this, slug), values) != null;
    }

    @ZenMethod
    public boolean isCustomStaged(String slug, int value) {
        return Helper.getCustomTypeByValue(ZenStager.filterCustomByStage(this, slug), value) != null;
    }

    @ZenMethod
    public boolean isCustomStaged(String slug, int[] values) {
        return Helper.getCustomTypeByValue(ZenStager.filterCustomByStage(this, slug), values) != null;
    }

    @ZenMethod
    public boolean isCustomStaged(String slug, IIngredient value) {
        return Helper.getCustomTypeByValue(ZenStager.filterCustomByStage(this, slug), value) != null;
    }

    @ZenMethod
    public boolean isCustomStaged(String slug, IIngredient[] values) {
        return Helper.getCustomTypeByValue(ZenStager.filterCustomByStage(this, slug), values) != null;
    }

    @ZenMethod
    public Stage addIngredient(IIngredient ingredient, @Optional(valueBoolean=true) boolean recipeStage) {
        if (ingredient == null) {
            CraftTweakerAPI.logError((String)String.format("[Stage %s] Ingredient can not be null!", this.getStage()));
            return this;
        }
        this.stagedEntries.add(new TypeIngredient(ingredient, recipeStage));
        return this;
    }

    @ZenMethod
    public Stage addIngredients(IIngredient[] ingredients, @Optional(valueBoolean=true) boolean recipeStage) {
        if (ingredients == null) {
            CraftTweakerAPI.logError((String)String.format("[Stage %s] Ingredients can not be null!", this.getStage()));
            return this;
        }
        for (IIngredient ingredient : ingredients) {
            this.addIngredient(ingredient, recipeStage);
        }
        return this;
    }

    @ZenMethod
    public Stage addIngredientOverride(IIngredient ingredient, @Optional(valueBoolean=true) boolean recipeStage) {
        if (ingredient == null) {
            CraftTweakerAPI.logError((String)String.format("[Stage %s] Ingredient can not be null!", this.getStage()));
            return this;
        }
        if (ZenStager.stagingOverrides.contains(ingredient)) {
            CraftTweakerAPI.logError((String)String.format("[Stage %s] Failed to add override for %s as it's already been told to override!", this.getStage(), ingredient.toString()));
        }
        this.stagedEntries.add(new TypeIngredientOverride(ingredient, recipeStage));
        return this;
    }

    @ZenMethod
    public Stage addModId(String modId, @Optional(valueBoolean=false) boolean stageRecipesWithItems) {
        if (!Loader.isModLoaded((String)modId)) {
            CraftTweakerAPI.logError((String)String.format("[Stage %s] Failed to add `%s` as the mod is not even loaded?", this.getStage(), modId));
            return this;
        }
        this.stagedEntries.add(new TypeMod(modId, stageRecipesWithItems));
        return this;
    }

    @ZenMethod
    public Stage addModId(String[] modIds, @Optional(valueBoolean=false) boolean stageRecipesWithItems) {
        for (String modId : modIds) {
            this.addModId(modId, stageRecipesWithItems);
        }
        return this;
    }

    @ZenMethod
    public Stage addLiquid(ILiquidStack liquidStack) {
        this.addIngredient((IIngredient)liquidStack, false);
        return this;
    }

    @ZenMethod
    public Stage addLiquids(ILiquidStack[] liquidStacks) {
        this.addIngredients((IIngredient[])liquidStacks, false);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="dimstages")
    public Stage addDimension(int dimension) {
        this.stagedEntries.add(new TypeDimension(dimension));
        return this;
    }

    @Optional.Method(modid="recipestages")
    Stage addContainer(String container) {
        this.stagedEntries.add(new TypeContainer(container));
        return this;
    }

    @Optional.Method(modid="recipestages")
    Stage addPackage(String container) {
        this.stagedEntries.add(new TypePackage(container));
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="recipestages")
    public Stage addRecipeName(String recipeName) {
        if (Helper.validateRecipeName(recipeName) == null) {
            CraftTweakerAPI.logError((String)String.format("[Stage %s] Recipe name `%s` is not valid! Example: minecraft:boat", this.getStage(), recipeName));
            return this;
        }
        this.stagedEntries.add(new TypeRecipeName(recipeName));
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="recipestages")
    public Stage addRecipeRegex(String recipeRegex) {
        this.stagedEntries.add(new TypeRecipeRegex(recipeRegex));
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mobstages")
    public Stage addMobs(String[] mobNames) {
        for (String mobName : mobNames) {
            this.addMob(mobName);
        }
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mobstages")
    public Stage addMob(String mobName) {
        this.stagedEntries.add(new TypeMob(mobName));
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mobstages")
    public Stage addMobs(String[] mobNames, int dimension) {
        for (String mobName : mobNames) {
            this.addMob(mobName, dimension);
        }
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mobstages")
    public Stage addMob(String mobName, int dimensionId) {
        this.stagedEntries.add(new TypeMob(mobName, dimensionId));
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="tinkerstages")
    public Stage addTiCMaterials(String[] materialNames) {
        for (String materialName : materialNames) {
            this.addTiCMaterial(materialName);
        }
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="tinkerstages")
    public Stage addTiCMaterial(String materialName) {
        this.stagedEntries.add(new TypeTinker(TinkerType.MATERIAL, materialName));
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="tinkerstages")
    public Stage addTiCModifier(String modifierName) {
        this.stagedEntries.add(new TypeTinker(TinkerType.MODIFIER, modifierName));
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="tinkerstages")
    public Stage addTiCModifier(String[] modifierNames) {
        for (String modifierName : modifierNames) {
            this.addTiCModifier(modifierName);
        }
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="tinkerstages")
    public Stage addTiCToolTypes(String[] toolTypes) {
        for (String toolType : toolTypes) {
            this.addTiCToolType(toolType);
        }
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="tinkerstages")
    public Stage addTiCToolType(String toolType) {
        this.stagedEntries.add(new TypeTinker(TinkerType.TOOL, toolType));
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="multiblockstages")
    public Stage addIEMultiBlocks(String[] multiblocks) {
        for (String multiblock : multiblocks) {
            this.addIEMultiBlock(multiblock);
        }
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="multiblockstages")
    public Stage addIEMultiBlock(String multiblock) {
        this.stagedEntries.add(new TypeMultiBlock(MultiBlockType.IE, multiblock));
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="orestages")
    public Stage addOreReplacement(IIngredient blockToHide, @Optional(valueBoolean=false) boolean isNonDefaulting) {
        if (blockToHide == null) {
            CraftTweakerAPI.logError((String)String.format("[Stage %s] Ore can not be null!", this.getStage()));
            return this;
        }
        TypeOre typeOre = new TypeOre(blockToHide);
        typeOre.setNonDefaulting(isNonDefaulting);
        this.stagedEntries.add(typeOre);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="orestages")
    public Stage addOreReplacement(IIngredient blockToHide, IItemStack blockToShow, @Optional(valueBoolean=false) boolean isNonDefaulting) {
        if (blockToHide == null || blockToShow == null) {
            CraftTweakerAPI.logError((String)String.format("[Stage %s] Ore can not be null!", this.getStage()));
            return this;
        }
        TypeOre typeOre = new TypeOre(blockToHide, blockToShow);
        typeOre.setNonDefaulting(isNonDefaulting);
        this.stagedEntries.add(typeOre);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="orestages")
    public Stage addOreReplacement(String original, String replacement) {
        if (original == null || original.length() < 1 || replacement == null || replacement.length() < 1) {
            CraftTweakerAPI.logError((String)String.format("[Stage %s] Ore original or replacement can not be null or empty!", this.getStage()));
            return this;
        }
        this.stagedEntries.add(new TypeOreById(original, replacement));
        return this;
    }

    void build() {
        for (TypeBase newType : this.stagedEntries) {
            if (newType instanceof TypeRecipeRegex) continue;
            newType.build(this.getStage());
        }
    }

    void buildRecipe() {
        this.filterEntries(TypeRecipeRegex.class).forEach(t -> t.buildRecipe(this.getStage()));
    }

    <T> List<T> filterEntries(Class<T> clazz) {
        return this.stagedEntries.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    <T extends TypeBase, R> Stage getStage(Class<T> clazz, R value) {
        return this.filterEntries(clazz).stream().filter(t -> t.isStaged(value)).collect(Collectors.toSet()).size() > 0 ? this : null;
    }

    private Stage getIngredientStage(IIngredient testIngredient) {
        List<TypeIngredient> stagedIngredients = this.filterEntries(TypeIngredient.class);
        for (TypeIngredient stagedIngredientEntry : stagedIngredients) {
            IIngredient ingredient = (IIngredient)stagedIngredientEntry.getValue();
            if (!(testIngredient instanceof MCOreDictEntry ? ingredient instanceof MCOreDictEntry && ((MCOreDictEntry)testIngredient).getName().equals(((MCOreDictEntry)ingredient).getName()) : (ingredient instanceof MCOreDictEntry ? ingredient.contains(testIngredient) : (testIngredient instanceof ILiquidStack ? ingredient.matches((ILiquidStack)testIngredient) : (testIngredient instanceof IItemStack ? ingredient.matchesExact((IItemStack)testIngredient) : ingredient.contains(testIngredient)))))) continue;
            return this;
        }
        return null;
    }
}

