/*
 * Decompiled with CFR 0.152.
 */
package uk.artdude.zenstages.common.util;

import crafttweaker.api.item.IIngredient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import uk.artdude.zenstages.stager.type.TypeBase;
import uk.artdude.zenstages.stager.type.TypeCustom;

public class Helper {
    public static <T> void getDuplicates(Map<T, List<String>> duplicates, String stage, List<? extends TypeBase> currStage, List<? extends TypeBase> checkStage) {
        HashSet similar = new HashSet();
        HashSet checkSimilar = new HashSet();
        currStage.forEach(stagedIngredient -> similar.add(stagedIngredient.getValue()));
        checkStage.forEach(stagedIngredient -> checkSimilar.add(stagedIngredient.getValue()));
        similar.retainAll(checkSimilar);
        for (Object s : similar) {
            ArrayList<String> list = new ArrayList<String>();
            if (duplicates.containsKey(s)) {
                if (duplicates.get(s).contains(stage)) continue;
                list.addAll((Collection)duplicates.get(s));
                list.add(stage);
                duplicates.put(s, list);
                continue;
            }
            list.add(stage);
            duplicates.put(s, list);
        }
    }

    public static <T> TypeCustom getCustomTypeByValue(List<TypeCustom> customTypes, T value) {
        for (TypeCustom customType : customTypes) {
            if (customType == null || customType.getStage() == null) continue;
            if (customType.getValue() instanceof IIngredient[] && Arrays.asList((Object[])customType.getValue()).contains(value)) {
                return customType;
            }
            if (!customType.getValue().equals(value)) continue;
            return customType;
        }
        return null;
    }

    public static String validateRecipeName(String name) {
        String recipeNameRegex = "([a-z-A-Z0-9][\\w\\-/]*)$";
        Pattern withoutModId = Pattern.compile("^" + recipeNameRegex);
        if (withoutModId.matcher(name).matches()) {
            return String.format("minecraft:%s", name);
        }
        Pattern pattern = Pattern.compile("^([a-z-A-Z]\\w+):" + recipeNameRegex);
        return pattern.matcher(name).matches() ? name : null;
    }

    public static String cleanName(String uncleaned) {
        return uncleaned.replaceAll("[^A-Za-z_\\s]", "").replaceAll("\\s+", " ").replaceAll("\\s+", "_").toLowerCase();
    }
}

