/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.wired;

import com.enderio.core.api.common.util.IProgressTile;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.baselegacy.AbstractPowerConsumerEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.power.ILegacyPowerReceiver;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileWiredCharger
extends AbstractPowerConsumerEntity
implements ILegacyPowerReceiver,
IPaintable.IPaintableTileEntity,
IProgressTile {
    @Store(value={NBTAction.CLIENT})
    @Nonnull
    private ItemStack itemForClient = Prep.getEmpty();
    private float progress = 0.0f;

    protected TileWiredCharger(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    protected TileWiredCharger(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored) {
        this(slotDefinition, maxEnergyRecieved, maxEnergyStored, (ICapacitorKey)crazypants.enderio.base.capacitor.CapacitorKey.NO_POWER);
    }

    public TileWiredCharger() {
        this(new SlotDefinition(1, 1, 1), CapacitorKey.WIRED_POWER_INTAKE, CapacitorKey.WIRED_POWER_BUFFER);
    }

    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        if (i == this.getSlotDefinition().minInputSlot) {
            IEnergyStorage storage = PowerHandlerUtil.getCapability((ICapabilityProvider)itemstack, null);
            return storage != null && storage.receiveEnergy(1, true) > 0;
        }
        return false;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isActive() {
        return false;
    }

    protected boolean processTasks(boolean redstoneCheck) {
        int available;
        if (!redstoneCheck || this.getEnergyStored() <= 0) {
            return false;
        }
        ItemStack stack = this.getStackInSlot(this.getSlotDefinition().minInputSlot);
        if (Prep.isValid((ItemStack)stack) && (available = Math.min(this.getPowerUsePerTick(), this.getEnergyStored())) > 0) {
            int used;
            IEnergyStorage chargable = PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null);
            if (chargable != null && (used = chargable.receiveEnergy(available, false)) > 0) {
                this.usePower(used);
                this.progress = (float)chargable.getEnergyStored() / (float)chargable.getMaxEnergyStored();
                return false;
            }
            if (Prep.isInvalid((ItemStack)this.getStackInSlot(this.getSlotDefinition().minOutputSlot))) {
                this.setInventorySlotContents(this.getSlotDefinition().minOutputSlot, stack);
                this.setInventorySlotContents(this.getSlotDefinition().minInputSlot, Prep.getEmpty());
            }
        }
        this.progress = 0.0f;
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    protected ItemStack getItemToRender() {
        return this.itemForClient;
    }

    public void setInventorySlotContents(int slot, @Nonnull ItemStack contents) {
        super.setInventorySlotContents(slot, contents);
        if (slot == this.getSlotDefinition().minInputSlot) {
            this.itemForClient = contents;
            this.forceUpdatePlayers();
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Nonnull
    public TileEntity getTileEntity() {
        return this;
    }

    public int getPowerUsePerTick() {
        ItemStack stack;
        if (!(this instanceof Simple) && !(stack = this.getStackInSlot(this.getSlotDefinition().maxInputSlot)).func_190926_b()) {
            IEnergyStorage chargable = PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null);
            return chargable.getMaxEnergyStored() / CapacitorKey.WIRED_POWER_CHARGE.get(this.getCapacitorData());
        }
        return super.getPowerUsePerTick();
    }

    public static class Simple
    extends TileWiredCharger {
        public Simple() {
            super(new SlotDefinition(1, 1, 0), CapacitorKey.SIMPLE_WIRED_POWER_INTAKE, CapacitorKey.SIMPLE_WIRED_POWER_BUFFER, CapacitorKey.SIMPLE_WIRED_POWER_USE);
            this.setEnergyLoss(CapacitorKey.SIMPLE_WIRED_POWER_LOSS);
        }
    }

    public static class Enhanced
    extends TileWiredCharger {
        public Enhanced() {
            super(new SlotDefinition(1, 1, 1), CapacitorKey.ENHANCED_WIRED_POWER_INTAKE, CapacitorKey.ENHANCED_WIRED_POWER_BUFFER);
        }

        public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
            return (faceHit != EnumFacing.UP || mode == IoMode.NONE) && super.supportsMode(faceHit, mode);
        }
    }
}

