/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.spawner;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.modes.EntityAction;
import crazypants.enderio.base.machine.task.PoweredTask;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.spawner.DummyRecipe;
import crazypants.enderio.base.recipe.spawner.PoweredSpawnerRecipeRegistry;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.SpawnerConfig;
import crazypants.enderio.machines.machine.spawner.PacketSpawnerUpdateNotification;
import crazypants.enderio.machines.machine.spawner.SpawnerLogic;
import crazypants.enderio.machines.machine.spawner.SpawnerNotification;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TilePoweredSpawner
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity,
IRanged,
EntityAction.Implementer,
INotifier,
SpawnerLogic.ISpawnerCallback {
    @Store(value={NBTAction.CLIENT, NBTAction.SAVE})
    private CapturedMob capturedMob = null;
    @Store
    private boolean isSpawnMode = true;
    @Nonnull
    private final Set<SpawnerNotification> notification = EnumSet.noneOf(SpawnerNotification.class);
    private boolean sendNotification = false;
    @Nonnull
    private final SpawnerLogic logic = new SpawnerLogic(this);
    private double mobRotation;
    private double prevMobRotation;
    private Entity cachedEntity;
    private BoundingBox bounds;
    private boolean showingRange;
    @Nonnull
    private static final Vector4f color = new Vector4f(0.94f, 0.11f, 0.11f, 0.4f);

    public TilePoweredSpawner() {
        super(new SlotDefinition(1, 1, 1), (ICapacitorKey)CapacitorKey.SPAWNER_POWER_INTAKE, (ICapacitorKey)CapacitorKey.SPAWNER_POWER_BUFFER, (ICapacitorKey)CapacitorKey.SPAWNER_POWER_USE);
    }

    public boolean isSpawnMode() {
        return this.isSpawnMode;
    }

    public void setSpawnMode(boolean isSpawnMode) {
        if (isSpawnMode != this.isSpawnMode) {
            this.currentTask = null;
        }
        this.isSpawnMode = isSpawnMode;
    }

    protected void taskComplete() {
        super.taskComplete();
        if (this.hasEntity()) {
            if (this.isSpawnMode) {
                boolean spawnedOne = false;
                for (int i = 0; i < (Integer)SpawnerConfig.poweredSpawnerSpawnCount.get(); ++i) {
                    if (!this.logic.trySpawnEntity()) continue;
                    spawnedOne = true;
                }
                if (spawnedOne) {
                    this.clearNotification();
                }
            } else {
                this.clearNotification();
                if (Prep.isInvalid((ItemStack)this.getStackInSlot(0)) || Prep.isValid((ItemStack)this.getStackInSlot(1)) || !this.hasEntity()) {
                    return;
                }
                ItemStack res = this.capturedMob.toGenericStack(ModObject.itemSoulVial.getItemNN(), 1, 1);
                this.getStackInSlot(0).func_190918_g(1);
                this.setInventorySlotContents(1, res);
            }
        } else {
            this.field_145850_b.func_175655_b(this.func_174877_v(), true);
        }
        if (this.sendNotification) {
            if (this.hasNotification(SpawnerNotification.NO_LOCATION_FOUND)) {
                this.logic.anyLocationInRange();
            }
            this.sendNotification();
        }
    }

    public int getMaxUsage() {
        return this.getPowerUsePerTick();
    }

    public int getPowerUsePerTick() {
        ResourceLocation entityName = this.getEntityName();
        return (int)((double)super.getPowerUsePerTick() * (entityName == null ? 0.0 : PoweredSpawnerRecipeRegistry.getInstance().getCostMultiplierFor(entityName)));
    }

    public int getMaxEnergyRecieved(EnumFacing dir) {
        ResourceLocation entityName = this.getEntityName();
        return (int)((double)super.getMaxEnergyRecieved(dir) * (entityName == null ? 0.0 : PoweredSpawnerRecipeRegistry.getInstance().getCostMultiplierFor(entityName)));
    }

    @Nonnull
    public String getMachineName() {
        return "spawner";
    }

    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b() || this.isSpawnMode) {
            return false;
        }
        if (this.slotDefinition.isInputSlot(i)) {
            return itemstack.func_77973_b() == ModObject.itemSoulVial.getItem() && !CapturedMob.containsSoul((ItemStack)itemstack);
        }
        return false;
    }

    protected IMachineRecipe canStartNextTask(long nextSeed) {
        if (!this.hasEntity()) {
            this.field_145850_b.func_175655_b(this.func_174877_v(), true);
            return null;
        }
        if (this.isSpawnMode) {
            BlockPos p;
            if ((Integer)SpawnerConfig.poweredSpawnerMaxPlayerDistance.get() > 0 && this.field_145850_b.func_184137_a((double)(p = this.func_174877_v()).func_177958_n() + 0.5, (double)p.func_177958_n() + 0.5, (double)p.func_177958_n() + 0.5, (double)((Integer)SpawnerConfig.poweredSpawnerMaxPlayerDistance.get()).intValue(), false) == null) {
                this.setNotification(SpawnerNotification.NO_PLAYER);
                return null;
            }
            this.removeNotification(SpawnerNotification.NO_PLAYER);
        } else {
            this.clearNotification();
            if (Prep.isInvalid((ItemStack)this.getStackInSlot(0)) || Prep.isValid((ItemStack)this.getStackInSlot(1))) {
                return null;
            }
        }
        return new DummyRecipe();
    }

    protected boolean hasInputStacks() {
        return true;
    }

    protected boolean canInsertResult(long nextSeed, @Nonnull IMachineRecipe nextRecipe) {
        return true;
    }

    public void writeCustomNBT(@Nonnull ItemStack stack) {
        super.writeCustomNBT(stack);
        if (this.hasEntity()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            this.capturedMob.toNbt(stack.func_77978_p());
        }
    }

    double getMobRotation() {
        return this.mobRotation;
    }

    double getPrevMobRotation() {
        return this.prevMobRotation;
    }

    Entity getCachedEntity() {
        return this.cachedEntity;
    }

    protected void updateEntityClient() {
        if (this.isActive()) {
            double x = (float)this.func_174877_v().func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
            double y = (float)this.func_174877_v().func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
            double z = (float)this.func_174877_v().func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            this.prevMobRotation = this.mobRotation;
            this.mobRotation = (this.mobRotation + (double)(1000.0f / ((1.0f - this.getProgress()) * 800.0f + 200.0f))) % 360.0;
            if (this.cachedEntity == null && this.hasEntity()) {
                this.cachedEntity = this.capturedMob.getEntity(this.field_145850_b, this.field_174879_c, null, false);
                if (this.cachedEntity != null) {
                    this.cachedEntity.func_70106_y();
                }
            }
        }
        super.updateEntityClient();
    }

    protected IPoweredTask createTask(@Nonnull IMachineRecipe nextRecipe, long nextSeed) {
        PoweredTask res = new PoweredTask(nextRecipe, nextSeed, this.getRecipeInputs());
        int ticksDelay = this.isSpawnMode ? (Integer)SpawnerConfig.poweredSpawnerMinDelayTicks.get() + (int)Math.round((double)((Integer)SpawnerConfig.poweredSpawnerMaxDelayTicks.get() - (Integer)SpawnerConfig.poweredSpawnerMinDelayTicks.get()) * Math.random()) : (Integer)SpawnerConfig.poweredSpawnerMaxDelayTicks.get() - ((Integer)SpawnerConfig.poweredSpawnerMaxDelayTicks.get() - (Integer)SpawnerConfig.poweredSpawnerMinDelayTicks.get()) / 2;
        ticksDelay = (int)((float)ticksDelay / CapacitorKey.SPAWNER_SPEEDUP.getFloat(this.getCapacitorData()));
        int powerPerTick = this.getPowerUsePerTick();
        res.setRequiredEnergy((float)(powerPerTick * ticksDelay));
        return res;
    }

    public ResourceLocation getEntityName() {
        return this.capturedMob != null ? this.capturedMob.getEntityName() : null;
    }

    @Override
    public CapturedMob getEntity() {
        return this.capturedMob;
    }

    public boolean hasEntity() {
        return this.capturedMob != null;
    }

    public void readCustomNBT(@Nonnull ItemStack stack) {
        super.readCustomNBT(stack);
        this.capturedMob = CapturedMob.create((ItemStack)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new RangeParticle((TileEntity)this, color));
        }
    }

    public void onCapacitorDataChange() {
        super.onCapacitorDataChange();
        this.bounds = null;
    }

    @Override
    @Nonnull
    public BoundingBox getBounds() {
        if (this.isSpawnMode) {
            Entity ent;
            if (this.bounds != null) {
                return this.bounds;
            }
            this.bounds = SpawnerLogic.ISpawnerCallback.super.getBounds();
            if (this.capturedMob != null && (ent = this.capturedMob.getEntity(this.field_145850_b, false)) != null) {
                int height = Math.max((int)Math.ceil(ent.field_70131_O) - 1, 0);
                this.bounds = this.bounds.setMaxY(this.bounds.field_72337_e + (double)height);
                return this.bounds;
            }
        }
        return new BoundingBox(this.func_174877_v());
    }

    @Override
    public int getRange() {
        return (Integer)SpawnerConfig.poweredSpawnerSpawnRange.get();
    }

    @Override
    public void setNotification(@Nonnull SpawnerNotification note) {
        if (!this.notification.contains((Object)note)) {
            this.notification.add(note);
            this.sendNotification = true;
        }
    }

    @Override
    public void removeNotification(@Nonnull SpawnerNotification note) {
        if (this.getNotification().remove((Object)note)) {
            this.sendNotification = true;
        }
    }

    public void clearNotification() {
        if (this.hasNotification()) {
            this.getNotification().clear();
            this.sendNotification = true;
        }
    }

    public void replaceNotification(Set<SpawnerNotification> notes) {
        this.getNotification().clear();
        for (SpawnerNotification note : notes) {
            this.getNotification().add(note);
        }
    }

    public boolean hasNotification() {
        return !this.getNotification().isEmpty();
    }

    public boolean hasNotification(SpawnerNotification note) {
        return this.getNotification().contains((Object)note);
    }

    @Nonnull
    public Set<SpawnerNotification> getNotification() {
        return this.notification;
    }

    private void sendNotification() {
        this.sendNotification = false;
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketSpawnerUpdateNotification(this, this.getNotification()));
    }

    @Nonnull
    public NNList<CapturedMob> getEntities() {
        if (this.capturedMob != null) {
            return new NNList((Object[])new CapturedMob[]{this.capturedMob});
        }
        return NNList.emptyList();
    }

    @Nonnull
    public EntityAction getEntityAction() {
        return EntityAction.SPAWN;
    }

    @Override
    @Nonnull
    public World getSpawnerWorld() {
        return this.field_145850_b;
    }

    @Override
    @Nonnull
    public BlockPos getSpawnerPos() {
        return this.field_174879_c;
    }

    @Override
    public void resetCapturedMob() {
        this.capturedMob = null;
        this.func_70296_d();
    }
}

