/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.render;

import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.material.material.Material;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.obelisk.attractor.TileAttractor;
import crazypants.enderio.machines.machine.obelisk.aversion.AversionObeliskRenderer;
import crazypants.enderio.machines.machine.obelisk.aversion.TileAversionObelisk;
import crazypants.enderio.machines.machine.obelisk.inhibitor.TileInhibitorObelisk;
import crazypants.enderio.machines.machine.obelisk.relocator.RelocatorObeliskRenderer;
import crazypants.enderio.machines.machine.obelisk.relocator.TileRelocatorObelisk;
import crazypants.enderio.machines.machine.obelisk.render.ObeliskSpecialRenderer;
import crazypants.enderio.machines.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.machines.machine.obelisk.weather.WeatherObeliskSpecialRenderer;
import crazypants.enderio.machines.machine.obelisk.xp.TileExperienceObelisk;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ObeliskRenderManager {
    public static final ObeliskRenderManager INSTANCE = new ObeliskRenderManager();
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("enderio:obelisk");
    private TextureRegistry.TextureSupplier[] textures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture((String)"blocks/obelisk_bottom"), TextureRegistry.registerTexture((String)"blocks/block_soul_machine_top"), TextureRegistry.registerTexture((String)"blocks/block_attractor_side"), TextureRegistry.registerTexture((String)"blocks/block_attractor_side"), TextureRegistry.registerTexture((String)"blocks/block_attractor_side"), TextureRegistry.registerTexture((String)"blocks/block_attractor_side")};
    private TextureRegistry.TextureSupplier[] activeTextures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture((String)"blocks/obelisk_bottom"), TextureRegistry.registerTexture((String)"blocks/block_soul_machine_top"), TextureRegistry.registerTexture((String)"blocks/block_attractor_side_on"), TextureRegistry.registerTexture((String)"blocks/block_attractor_side_on"), TextureRegistry.registerTexture((String)"blocks/block_attractor_side_on"), TextureRegistry.registerTexture((String)"blocks/block_attractor_side_on")};

    private ObeliskRenderManager() {
    }

    public void registerRenderers() {
        ObeliskSpecialRenderer eor;
        Block block = MachineObject.block_experience_obelisk.getBlock();
        if (block != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack(ModObject.itemXpTransfer.getItemNN()), block);
            this.registerRenderer(block, (Class)TileExperienceObelisk.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = MachineObject.block_attractor_obelisk.getBlock()) != null) {
            eor = new ObeliskSpecialRenderer(Material.ATTRACTOR_CRYSTAL.getStack(), block);
            this.registerRenderer(block, (Class)TileAttractor.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = MachineObject.block_aversion_obelisk.getBlock()) != null) {
            eor = new AversionObeliskRenderer();
            this.registerRenderer(block, (Class)TileAversionObelisk.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = MachineObject.block_relocator_obelisk.getBlock()) != null) {
            eor = new RelocatorObeliskRenderer();
            this.registerRenderer(block, (Class)TileRelocatorObelisk.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = MachineObject.block_weather_obelisk.getBlock()) != null) {
            eor = new WeatherObeliskSpecialRenderer(new ItemStack(Items.field_151152_bP));
            this.registerRenderer(block, (Class)TileWeatherObelisk.class, (TileEntitySpecialRenderer)eor);
        }
        if ((block = MachineObject.block_inhibitor_obelisk.getBlock()) != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack(Items.field_151079_bi), block);
            this.registerRenderer(block, (Class)TileInhibitorObelisk.class, (TileEntitySpecialRenderer)eor);
        }
    }

    private <T extends AbstractMachineEntity> void registerRenderer(@Nonnull Block block, Class<T> tileClass, TileEntitySpecialRenderer<? super T> specialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, specialRenderer);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)block), (int)0, tileClass);
    }

    public TextureRegistry.TextureSupplier[] getTextures() {
        return this.textures;
    }

    public TextureRegistry.TextureSupplier[] getActiveTextures() {
        return this.activeTextures;
    }
}

