/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.attractor;

import com.mojang.authlib.GameProfile;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.fakeplayer.FakePlayerEIO;
import crazypants.enderio.base.machine.modes.EntityAction;
import crazypants.enderio.base.network.PacketSpawnParticles;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.AttractorConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.obelisk.attractor.BlockAttractor;
import crazypants.enderio.machines.machine.obelisk.attractor.handlers.AttractionHandlers;
import crazypants.enderio.machines.machine.obelisk.attractor.handlers.IMobAttractionHandler;
import crazypants.enderio.machines.machine.obelisk.base.AbstractMobObeliskEntity;
import info.loenwind.autosave.annotations.Storable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.TargetContext;

@Storable
public class TileAttractor
extends AbstractMobObeliskEntity {
    private FakePlayerEIO target;
    private Map<EntityLiving, IMobAttractionHandler> tracking = new HashMap<EntityLiving, IMobAttractionHandler>();

    public TileAttractor() {
        super(new SlotDefinition(12, 0), CapacitorKey.ATTRACTOR_POWER_INTAKE, CapacitorKey.ATTRACTOR_POWER_BUFFER, CapacitorKey.ATTRACTOR_POWER_USE);
    }

    @Override
    public float getRange() {
        return CapacitorKey.ATTRACTOR_RANGE.get(this.getCapacitorData());
    }

    @Nonnull
    public String getMachineName() {
        return MachineObject.block_attractor_obelisk.getUnlocalisedName();
    }

    private void untrackAll() {
        for (Map.Entry<EntityLiving, IMobAttractionHandler> tracked : this.tracking.entrySet()) {
            tracked.getValue().release(this, tracked.getKey());
        }
        this.tracking.clear();
    }

    private void cleanTrackedEntities() {
        Iterator<Map.Entry<EntityLiving, IMobAttractionHandler>> iterator = this.tracking.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EntityLiving, IMobAttractionHandler> next = iterator.next();
            if (next.getKey().field_70128_L) {
                iterator.remove();
                continue;
            }
            if (!this.canAttract(next.getKey())) {
                next.getValue().release(this, next.getKey());
                iterator.remove();
                continue;
            }
            if (next.getKey().field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            PacketSpawnParticles.create((Entity)((Entity)next.getKey()), (EnumParticleTypes[])new EnumParticleTypes[]{EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.VILLAGER_HAPPY});
        }
    }

    private void tickTrackedEntities() {
        for (Map.Entry<EntityLiving, IMobAttractionHandler> tracked : this.tracking.entrySet()) {
            if (tracked.getKey().field_70128_L) continue;
            tracked.getValue().tick(this, tracked.getKey());
        }
    }

    private void collectEntities() {
        for (EntityLiving entity : this.field_145850_b.func_72872_a(EntityLiving.class, (AxisAlignedBB)this.getBounds())) {
            if (entity.field_70128_L || this.tracking.containsKey(entity) || !this.canAttract(entity) || !PermissionAPI.hasPermission((GameProfile)this.getOwner().getAsGameProfile(), (String)BlockAttractor.permissionAttracting, (IContext)new TargetContext((EntityPlayer)this.getTarget(), (Entity)entity))) continue;
            this.collectEntity(entity);
            if (this.tracking.size() < (Integer)AttractorConfig.maxMobsAttracted.get()) continue;
            return;
        }
    }

    private void collectEntity(@Nonnull EntityLiving ent) {
        for (IMobAttractionHandler handler : AttractionHandlers.instance.getRegistry()) {
            if (!handler.canAttract(this, ent)) continue;
            handler.startAttracting(this, ent);
            this.tracking.put(ent, handler);
            PacketSpawnParticles.create((Entity)ent, (EnumParticleTypes[])new EnumParticleTypes[]{EnumParticleTypes.HEART, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.VILLAGER_HAPPY});
            return;
        }
        Log.warn((Object[])new Object[]{"Attractor Obelisk: Don't know how to attract " + EntityList.func_191301_a((Entity)ent)});
    }

    protected boolean processTasks(boolean redstoneCheck) {
        if (!(redstoneCheck && this.hasPower() && this.canWork())) {
            this.untrackAll();
            return false;
        }
        this.usePower();
        if (this.shouldDoWorkThisTick(60, 5)) {
            this.cleanTrackedEntities();
        }
        if (this.shouldDoWorkThisTick(10)) {
            this.tickTrackedEntities();
        }
        if (this.tracking.size() < (Integer)AttractorConfig.maxMobsAttracted.get() && this.shouldDoWorkThisTick(20, 5)) {
            this.collectEntities();
        }
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.untrackAll();
    }

    @Nonnull
    public FakePlayer getTarget() {
        return this.target != null ? this.target : (this.target = new Target(this.func_145831_w()).setOwner(this.getOwner()));
    }

    public boolean canAttract(EntityLiving mob) {
        return this.isMobInFilter((EntityLivingBase)mob) && this.getBounds().func_72326_a(mob.func_174813_aQ());
    }

    @Nonnull
    public EntityAction getEntityAction() {
        return EntityAction.ATTRACT;
    }

    private class Target
    extends FakePlayerEIO {
        public Target(World world) {
            super(world, TileAttractor.this.getLocation(), new GameProfile(null, MachineObject.block_attractor_obelisk.getUnlocalisedName() + ":" + TileAttractor.this.getLocation()));
            this.field_70163_u += 1.0;
        }
    }
}

