/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.killera;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.util.MagnetUtil;
import com.enderio.core.common.util.stackable.Things;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.tic.TicProxy;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.capability.LegacyKillerJoeWrapper;
import crazypants.enderio.machines.config.config.KillerJoeConfig;
import crazypants.enderio.machines.machine.generator.zombie.IHasNutrientTank;
import crazypants.enderio.machines.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.machines.machine.killera.Attackera;
import crazypants.enderio.machines.machine.killera.BlockKillerJoe;
import crazypants.enderio.machines.machine.killera.PacketSwing;
import crazypants.enderio.machines.machine.killera.ZombieCache;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.TargetContext;

@Storable
public class TileKillerJoe
extends AbstractInventoryMachineEntity
implements ITankAccess.IExtendedTankAccess,
IHasNutrientTank,
IRanged {
    private static final int IO_MB_TICK = 250;
    @Nonnull
    protected static final BoundingBox NULL_AABB = new BoundingBox(new BlockPos(0, 0, 0));
    @Nonnull
    protected AxisAlignedBB hooverBounds = NULL_AABB;
    @Nonnull
    protected BoundingBox killBounds = NULL_AABB;
    protected Attackera attackera;
    @Store
    final SmartTank tank = new SmartTank(Fluids.NUTRIENT_DISTILLATION.getFluid(), 2000);
    @Store(value={NBTAction.CLIENT})
    @Nonnull
    protected ItemStack renderWeapon = Prep.getEmpty();
    int lastFluidLevelUpdate;
    private boolean tanksDirty;
    private boolean isSwingInProgress;
    private int swingProgressInt;
    private float swingProgress;
    private float prevSwingProgress;
    private boolean hasSword = false;
    private boolean isMending = false;
    public static final Things WEAPONS = new Things(new String[]{"tconstruct:hatchet", "tconstruct:mattock", "tconstruct:hammer", "tconstruct:lumberaxe", "tconstruct:scythe", "tconstruct:broadsword", "tconstruct:longsword", "tconstruct:rapier", "tconstruct:frypan", "tconstruct:cleaver", "minecraft:stick"}).add(Items.field_151041_m).add(Items.field_151052_q).add(Items.field_151040_l).add(Items.field_151010_B).add(Items.field_151048_u).add(ModObject.itemDarkSteelSword.getItem()).add(Items.field_151053_p).add(Items.field_151036_c).add(Items.field_151006_E).add(Items.field_151056_x).add(ModObject.itemDarkSteelAxe.getItem());
    private static final double[][] faceMidPoints = new double[][]{{0.5, 0.0, 0.5}, {0.5, 1.0, 0.5}, {0.5, 0.5, 0.0}, {0.5, 0.5, 1.0}, {0.0, 0.5, 0.5}, {1.0, 0.5, 0.5}};
    private boolean showingRange = false;
    private static final Vector4f color = new Vector4f(0.94f, 0.11f, 0.11f, 0.4f);
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileKillerJoe() {
        super(new SlotDefinition(1, 0, 0));
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanDrain(false);
    }

    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        return (itemstack.func_77973_b() instanceof ItemSword || itemstack.func_77973_b() instanceof ItemAxe || WEAPONS.contains(itemstack)) && !TicProxy.isBroken((ItemStack)itemstack);
    }

    public boolean isActive() {
        return false;
    }

    protected void updateEntityClient() {
        super.updateEntityClient();
        this.updateArmSwingProgress();
    }

    private void endMending() {
        this.isMending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processTasks(boolean redstoneCheck) {
        this.updateArmSwingProgress();
        if (Prep.isValid((ItemStack)this.getWeapon()) != this.hasSword) {
            this.hasSword = Prep.isValid((ItemStack)this.getWeapon());
            this.forceUpdatePlayers();
        }
        if (this.tanksDirty && this.shouldDoWorkThisTick(20)) {
            PacketHandler.sendToAllAround((IMessage)new PacketNutrientTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        if (!redstoneCheck) {
            return false;
        }
        if (this.tank.getFluidAmount() < this.getActivationAmount()) {
            return false;
        }
        if (!this.hasSword || TicProxy.isBroken((ItemStack)this.getWeapon())) {
            return false;
        }
        if (this.doMending()) {
            this.hooverXP();
            if (!this.needsMending()) {
                this.endMending();
            }
        }
        this.getAttackera().func_70071_h_();
        Attackera atackera = this.getAttackera();
        if ((float)atackera.getTicksSinceLastSwing() < atackera.func_184818_cX()) {
            return false;
        }
        List entsInBounds = this.field_145850_b.func_72872_a(EntityLivingBase.class, (AxisAlignedBB)this.getKillBounds());
        for (EntityLivingBase ent : entsInBounds) {
            if (ent.field_70128_L || ent.field_70725_aQ > 0 || ent.func_180431_b(DamageSource.field_76377_j) || ent.field_70172_ad != 0 || ent instanceof EntityPlayer && ((EntityPlayer)ent).field_71075_bZ.field_75102_a) continue;
            boolean togglePvp = false;
            if (ent instanceof EntityPlayer && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W()) {
                if (((Boolean)KillerJoeConfig.killerPvPoffDisablesSwing.get()).booleanValue()) continue;
                if (((Boolean)KillerJoeConfig.killerPvPoffIsIgnored.get()).booleanValue()) {
                    togglePvp = true;
                }
            }
            if (((Boolean)KillerJoeConfig.killerJoeMustSee.get()).booleanValue() && !this.canJoeSee(ent) || !PermissionAPI.hasPermission((GameProfile)this.getOwner().getAsGameProfile(), (String)BlockKillerJoe.permissionAttacking, (IContext)new TargetContext((EntityPlayer)atackera, (Entity)ent))) continue;
            if (ent instanceof EntityZombie) {
                ZombieCache.cache.add(ent.func_110124_au());
            }
            try {
                if (togglePvp) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71188_g(true);
                }
                atackera.func_71059_n((Entity)ent);
            }
            finally {
                if (togglePvp) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71188_g(false);
                }
            }
            atackera.func_184821_cY();
            this.useNutrient();
            this.swingWeapon();
            return false;
        }
        return false;
    }

    int getActivationAmount() {
        return (int)((float)this.tank.getCapacity() * 0.7f);
    }

    private boolean canJoeSee(EntityLivingBase ent) {
        Vec3d entPos = new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v);
        for (EnumFacing facing1 : new EnumFacing[]{this.facing, this.facing.func_176746_e(), this.facing.func_176735_f()}) {
            if (this.field_145850_b.func_72933_a(new Vec3d((double)this.func_174877_v().func_177958_n() + faceMidPoints[facing1.ordinal()][0], (double)this.func_174877_v().func_177956_o() + faceMidPoints[facing1.ordinal()][1], (double)this.func_174877_v().func_177952_p() + faceMidPoints[facing1.ordinal()][2]), entPos) != null) continue;
            return true;
        }
        return false;
    }

    private void hooverXP() {
        double maxDist = Math.max((Double)KillerJoeConfig.killerJoeHooverXpHeight.get(), Math.max((Double)KillerJoeConfig.killerJoeHooverXpLength.get(), (Double)KillerJoeConfig.killerJoeHooverXpWidth.get()));
        List xp = this.field_145850_b.func_175647_a(EntityXPOrb.class, this.getHooverBounds(), null);
        for (EntityXPOrb entity : xp) {
            boolean silent;
            double zDist;
            double yDist;
            double xDist = (double)this.func_174877_v().func_177958_n() + 0.5 - entity.field_70165_t;
            double totalDistance = Math.sqrt(xDist * xDist + (yDist = (double)this.func_174877_v().func_177956_o() + 0.5 - entity.field_70163_u) * yDist + (zDist = (double)this.func_174877_v().func_177952_p() + 0.5 - entity.field_70161_v) * zDist);
            if (totalDistance < 1.5) {
                this.hooverXP(entity);
                if (this.needsMending()) continue;
                return;
            }
            if (!MagnetUtil.shouldAttract((BlockPos)this.func_174877_v(), (Entity)entity, (boolean)true)) continue;
            double d = 1.0 - Math.max(0.1, totalDistance) / maxDist;
            double speed = 0.01 + d * 0.02;
            entity.field_70159_w += xDist / totalDistance * speed;
            entity.field_70179_y += zDist / totalDistance * speed;
            entity.field_70181_x += yDist / totalDistance * speed;
            if (yDist > 0.5) {
                entity.field_70181_x = 0.12;
            }
            entity.func_174810_b(!(silent = entity.func_174814_R()));
            entity.func_174810_b(silent);
        }
    }

    private void hooverXP(EntityXPOrb entity) {
        if (!entity.field_70128_L) {
            int xpValue = entity.func_70526_d();
            int i = Math.min(this.xpToDurability(xpValue), this.getWeapon().func_77952_i());
            this.getWeapon().func_77964_b(this.getWeapon().func_77952_i() - i);
            this.func_70296_d();
            if ((xpValue -= this.durabilityToXp(i)) > 0) {
                entity.field_70530_e = xpValue;
                MagnetUtil.release((Entity)entity);
            } else {
                entity.func_70106_y();
            }
        }
    }

    private boolean doMending() {
        if (!this.needsMending()) {
            this.endMending();
            return false;
        }
        if (this.isMending) {
            return true;
        }
        this.isMending = this.getWeapon().func_77973_b().getDurabilityForDisplay(this.getWeapon()) > 0.1;
        return this.isMending;
    }

    private boolean needsMending() {
        return (Boolean)KillerJoeConfig.killerMendingEnabled.get() != false && this.getWeapon().func_77951_h() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)this.getWeapon()) > 0;
    }

    private int durabilityToXp(int durability) {
        return durability / 2;
    }

    private int xpToDurability(int xp) {
        return xp * 2;
    }

    void swingWeapon() {
        if (Prep.isInvalid((ItemStack)this.renderWeapon)) {
            return;
        }
        if (!this.isSwingInProgress || this.swingProgressInt >= this.getArmSwingAnimationEnd() / 2 || this.swingProgressInt < 0) {
            this.swingProgressInt = -1;
            this.isSwingInProgress = true;
            if (this.field_145850_b instanceof WorldServer) {
                PacketHandler.sendToAllAround((IMessage)new PacketSwing(this), (TileEntity)this);
            }
        }
    }

    float getSwingProgress(float p_70678_1_) {
        float f1 = this.swingProgress - this.prevSwingProgress;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.prevSwingProgress + f1 * p_70678_1_;
    }

    private void updateArmSwingProgress() {
        this.prevSwingProgress = this.swingProgress;
        int i = this.getArmSwingAnimationEnd();
        if (this.isSwingInProgress) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= i) {
                this.swingProgressInt = 0;
                this.isSwingInProgress = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / (float)i;
    }

    private int getArmSwingAnimationEnd() {
        return 6;
    }

    private Attackera getAttackera() {
        if (this.attackera == null) {
            this.attackera = new Attackera(this, this.getOwner());
        }
        return this.attackera;
    }

    @Nonnull
    private BoundingBox getKillBounds() {
        if (this.killBounds == NULL_AABB) {
            double killerJoeAttackHeight = (Double)KillerJoeConfig.killerJoeAttackHeight.get();
            double killerJoeAttackLength = (Double)KillerJoeConfig.killerJoeAttackLength.get();
            double killerJoeAttackWidth = (Double)KillerJoeConfig.killerJoeAttackWidth.get();
            BoundingBox bb = new BoundingBox(this.getLocation());
            Vector3d min = bb.getMin();
            Vector3d max = bb.getMax();
            max.y += killerJoeAttackHeight;
            min.y -= killerJoeAttackHeight;
            EnumFacing facingDir = this.facing;
            if (ForgeDirectionOffsets.isPositiveOffset((EnumFacing)facingDir)) {
                max.add(ForgeDirectionOffsets.offsetScaled((EnumFacing)facingDir, (double)killerJoeAttackLength));
                min.add(ForgeDirectionOffsets.forDir((EnumFacing)facingDir));
            } else {
                min.add(ForgeDirectionOffsets.offsetScaled((EnumFacing)facingDir, (double)killerJoeAttackLength));
                max.add(ForgeDirectionOffsets.forDir((EnumFacing)facingDir));
            }
            if (facingDir.func_82601_c() == 0) {
                min.x -= killerJoeAttackWidth;
                max.x += killerJoeAttackWidth;
            } else {
                min.z -= killerJoeAttackWidth;
                max.z += killerJoeAttackWidth;
            }
            this.killBounds = new BoundingBox(min.x, min.y, min.z, max.x, max.y, max.z);
        }
        return this.killBounds;
    }

    @Nonnull
    private AxisAlignedBB getHooverBounds() {
        if (this.hooverBounds == NULL_AABB) {
            double killerJoeHooverXpHeight = (Double)KillerJoeConfig.killerJoeHooverXpHeight.get();
            double killerJoeHooverXpLength = (Double)KillerJoeConfig.killerJoeHooverXpLength.get();
            double killerJoeHooverXpWidth = (Double)KillerJoeConfig.killerJoeHooverXpWidth.get();
            BoundingBox bb = new BoundingBox(this.getLocation());
            Vector3d min = bb.getMin();
            Vector3d max = bb.getMax();
            max.y += killerJoeHooverXpHeight;
            min.y -= killerJoeHooverXpHeight;
            EnumFacing facingDir = this.facing;
            if (ForgeDirectionOffsets.isPositiveOffset((EnumFacing)facingDir)) {
                max.add(ForgeDirectionOffsets.offsetScaled((EnumFacing)facingDir, (double)killerJoeHooverXpLength));
                min.add(ForgeDirectionOffsets.forDir((EnumFacing)facingDir));
            } else {
                min.add(ForgeDirectionOffsets.offsetScaled((EnumFacing)facingDir, (double)killerJoeHooverXpLength));
                max.add(ForgeDirectionOffsets.forDir((EnumFacing)facingDir));
            }
            if (facingDir.func_82601_c() == 0) {
                min.x -= killerJoeHooverXpWidth * 2.0;
                max.x += killerJoeHooverXpWidth * 2.0;
            } else {
                min.z -= killerJoeHooverXpWidth * 2.0;
                max.z += killerJoeHooverXpWidth * 2.0;
            }
            this.hooverBounds = new AxisAlignedBB(min.x, min.y, min.z, max.x, max.y, max.z);
        }
        return this.hooverBounds;
    }

    private void useNutrient() {
        this.tank.removeFluidAmount(((Integer)KillerJoeConfig.killerJoeNutrientUsePerAttackMb.get()).intValue());
    }

    protected boolean doPull(@Nullable EnumFacing dir) {
        if (super.doPull(dir)) {
            return true;
        }
        if (dir != null && this.tank.getFluidAmount() < this.tank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.tank, (int)250) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == Fluids.NUTRIENT_DISTILLATION.getFluid()) {
            return this.tank;
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Override
    public SmartTank getNutrientTank() {
        return this.tank;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new RangeParticle((TileEntity)this, color));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @Nonnull
    public BoundingBox getBounds() {
        return this.getKillBounds();
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileKillerJoe.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileKillerJoe.this.tank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler((IIoConfigurable)this, new IFluidHandler[]{this.tank});
        }
        return this.smartTankFluidHandler;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getSmartTankFluidHandler().get(facingIn));
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facingIn != null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new LegacyKillerJoeWrapper(this, facingIn));
        }
        return (T)super.getCapability(capability, facingIn);
    }

    protected boolean hasStuffToPush() {
        return Prep.isValid((ItemStack)this.getStackInSlot(0));
    }

    @Nonnull
    public ItemStack getWeapon() {
        if (!this.field_145850_b.field_72995_K) {
            this.renderWeapon = this.getStackInSlot(0);
        }
        return this.renderWeapon;
    }

    public void setInventorySlotContents(int slot, @Nonnull ItemStack contents) {
        super.setInventorySlotContents(slot, contents);
        this.getWeapon();
        this.forceUpdatePlayers();
    }
}

