/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.zombie;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.machine.baselegacy.AbstractGeneratorEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.power.PowerDistributor;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.EnderGenConfig;
import crazypants.enderio.machines.config.config.ZombieGenConfig;
import crazypants.enderio.machines.machine.generator.zombie.IHasNutrientTank;
import crazypants.enderio.machines.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.machines.network.PacketHandler;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileZombieGenerator
extends AbstractGeneratorEntity
implements ITankAccess.IExtendedTankAccess,
IHasNutrientTank {
    protected int ticksPerBucketOfFuel = (Integer)ZombieGenConfig.ticksPerBucketOfFuel.get();
    protected float minimumTankLevel = ((Float)ZombieGenConfig.minimumTankLevel.get()).floatValue();
    private static int IO_MB_TICK = 250;
    @Store
    @Nonnull
    final SmartTank tank = new SmartTank(this.getFluidType(), 2000);
    private boolean tanksDirty;
    @Store(value={NBTAction.CLIENT})
    private boolean active = false;
    private PowerDistributor powerDis;
    @Store
    private float ticksRemaingFuel;
    private boolean inPause;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileZombieGenerator() {
        this(new SlotDefinition(0, 0, 1), CapacitorKey.ZOMBIE_POWER_BUFFER, CapacitorKey.ZOMBIE_POWER_GEN);
        this.setEnergyLoss(CapacitorKey.ZOMBIE_POWER_LOSS);
    }

    protected TileZombieGenerator(@Nonnull SlotDefinition slotDef, @Nonnull ICapacitorKey buffer, @Nonnull ICapacitorKey gen) {
        super(slotDef, buffer, gen);
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanDrain(false);
    }

    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode != IoMode.PUSH && mode != IoMode.PUSH_PULL;
    }

    protected boolean doPull(@Nullable EnumFacing dir) {
        if (super.doPull(dir)) {
            return true;
        }
        if (dir != null && this.tank.getFluidAmount() < this.tank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.tank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void onNeighborBlockChange(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos posIn, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        super.onNeighborBlockChange(state, worldIn, posIn, blockIn, fromPos);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    protected boolean processTasks(boolean redstoneCheck) {
        boolean res = false;
        if (!redstoneCheck) {
            if (this.active) {
                this.active = false;
                res = true;
            }
            return res;
        }
        boolean isActive = this.generateEnergy();
        if (isActive != this.active) {
            this.active = isActive;
            res = true;
        }
        if (this.getEnergyStored() >= this.getMaxEnergyStored()) {
            this.inPause = true;
        }
        this.transmitEnergy();
        if (this.tanksDirty) {
            PacketHandler.sendToAllAround((IMessage)new PacketNutrientTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        return res;
    }

    private boolean generateEnergy() {
        if (this.getCapacitorData() == DefaultCapacitorData.NONE) {
            return false;
        }
        if (this.ticksRemaingFuel >= 1.0f) {
            this.doGenerateEnergy();
            return true;
        }
        if (this.tank.getFluidAmount() < this.getActivationAmount()) {
            return false;
        }
        if (this.inPause && this.getEnergyStored() >= this.getMaxEnergyStored() - this.getPowerUsePerTick() * 200 && this.getEnergyStored() > this.getMaxEnergyStored() / 8) {
            return false;
        }
        this.inPause = false;
        while (this.ticksRemaingFuel < 1.0f && this.tank.getFluidAmount() > 0) {
            this.tank.removeFluidAmount(1);
            this.ticksRemaingFuel += (float)this.ticksPerBucketOfFuel / 1000.0f;
        }
        if (this.ticksRemaingFuel >= 1.0f) {
            this.doGenerateEnergy();
            return true;
        }
        return false;
    }

    private void doGenerateEnergy() {
        this.ticksRemaingFuel -= 1.0f;
        this.setEnergyStored(this.getEnergyStored() + this.getPowerUsePerTick());
    }

    int getActivationAmount() {
        return (int)((float)this.tank.getCapacity() * this.minimumTankLevel);
    }

    private boolean transmitEnergy() {
        if (this.getEnergyStored() <= 0) {
            return false;
        }
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(BlockCoord.get((TileEntity)this));
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, Math.min(this.getPowerUsePerTick() * 2, this.getEnergyStored()));
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    public int getFluidStored(EnumFacing from) {
        return this.tank.getFluidAmount();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == this.getFluidType()) {
            return this.tank;
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Override
    public SmartTank getNutrientTank() {
        return this.tank;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileZombieGenerator.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileZombieGenerator.this.tank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler((IIoConfigurable)this, new IFluidHandler[]{this.tank});
        }
        return this.smartTankFluidHandler;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }

    @Nonnull
    protected Fluid getFluidType() {
        return Fluids.NUTRIENT_DISTILLATION.getFluid();
    }

    public int getTicksPerBucketOfFuel() {
        return this.ticksPerBucketOfFuel;
    }

    public static class TileEnderGenerator
    extends TileZombieGenerator {
        public TileEnderGenerator() {
            super(new SlotDefinition(0, 0, 1), CapacitorKey.ENDER_POWER_BUFFER, CapacitorKey.ENDER_POWER_GEN);
            this.setEnergyLoss(CapacitorKey.ENDER_POWER_LOSS);
            this.ticksPerBucketOfFuel = (Integer)EnderGenConfig.ticksPerBucketOfFuel.get();
            this.minimumTankLevel = ((Float)EnderGenConfig.minimumTankLevel.get()).floatValue();
        }

        @Override
        @Nonnull
        protected Fluid getFluidType() {
            return Fluids.ENDER_DISTILLATION.getFluid();
        }
    }

    public static class TileFrankenZombieGenerator
    extends TileZombieGenerator {
        public TileFrankenZombieGenerator() {
            super(new SlotDefinition(0, 0, 1), CapacitorKey.FRANK_N_ZOMBIE_POWER_BUFFER, CapacitorKey.FRANK_N_ZOMBIE_POWER_GEN);
            this.setEnergyLoss(CapacitorKey.FRANK_N_ZOMBIE_POWER_LOSS);
        }
    }
}

