/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blocks;

import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.McJtyRegister;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.api.Infusable;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericItemBlock;
import mcjty.lib.compat.CofhApiItemCompatibility;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.WrenchChecker;
import mcjty.lib.varia.WrenchUsage;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.redstone.IRedstoneConnectable", modid="enderio")})
public abstract class GenericBlock<T extends GenericTileEntity, C extends Container>
extends BaseBlock
implements ITileEntityProvider,
IRedstoneConnectable {
    protected final Class<? extends T> tileEntityClass;
    private final BiFunction<EntityPlayer, IInventory, C> containerFactory;
    private boolean needsRedstoneCheck = false;
    private boolean hasRedstoneOutput = false;
    private boolean infusable = this instanceof Infusable;
    private IModuleSupport moduleSupport = null;
    @SideOnly(value=Side.CLIENT)
    private BiFunction<T, C, GenericGuiContainer<? super T>> guiFactory;
    private int guiId = -1;

    public GenericBlock(ModBase mod, Material material, Class<? extends T> tileEntityClass, BiFunction<EntityPlayer, IInventory, C> containerFactory, String name, boolean isContainer) {
        this(mod, material, tileEntityClass, containerFactory, GenericItemBlock::new, name, isContainer);
    }

    public GenericBlock(ModBase mod, Material material, Class<? extends T> tileEntityClass, BiFunction<EntityPlayer, IInventory, C> containerFactory, Function<Block, ItemBlock> itemBlockFactory, String name, boolean isContainer) {
        super(mod, material, name, itemBlockFactory);
        this.field_149758_A = isContainer;
        this.tileEntityClass = tileEntityClass;
        this.containerFactory = containerFactory;
        McJtyRegister.registerLater(this, tileEntityClass);
    }

    public boolean needsRedstoneCheck() {
        return this.needsRedstoneCheck;
    }

    public boolean hasRedstoneOutput() {
        return this.hasRedstoneOutput;
    }

    public void setInfusable(boolean infusable) {
        this.infusable = infusable;
    }

    public boolean isInfusable() {
        return this.infusable;
    }

    public void setNeedsRedstoneCheck(boolean needsRedstoneCheck) {
        this.needsRedstoneCheck = needsRedstoneCheck;
    }

    public void setHasRedstoneOutput(boolean hasRedstoneOutput) {
        this.hasRedstoneOutput = hasRedstoneOutput;
    }

    @Deprecated
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, EnumFacing from) {
        throw new AbstractMethodError();
    }

    @Optional.Method(modid="enderio")
    public boolean shouldRedstoneConduitConnect(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing from) {
        return this.needsRedstoneCheck() || this.hasRedstoneOutput();
    }

    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return -1;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.hasRedstoneOutput();
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity && !world.field_72995_K) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onBlockBreak(world, pos, state);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        BlockPos pos = data.getPos();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    @Override
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        currenttip = super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)tileEntity;
            genericTileEntity.addWailaBody(itemStack, currenttip, accessor, config);
        }
        return currenttip;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        this.intAddInformation(stack, tooltip);
        super.func_190948_a(stack, world, tooltip, flags);
    }

    protected void intAddInformation(ItemStack itemStack, List<String> list) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            if (tagCompound.func_74764_b("Energy")) {
                long energy = tagCompound.func_74763_f("Energy");
                list.add(TextFormatting.GREEN + "Energy: " + energy + " rf");
            }
            if (this.isInfusable()) {
                int infused = tagCompound.func_74762_e("infused");
                int pct = infused * 100 / GeneralConfig.maxInfuse;
                list.add(TextFormatting.YELLOW + "Infused: " + pct + "%");
            }
            if (GeneralConfig.manageOwnership && tagCompound.func_74764_b("owner")) {
                String owner = tagCompound.func_74779_i("owner");
                int securityChannel = -1;
                if (tagCompound.func_74764_b("secChannel")) {
                    securityChannel = tagCompound.func_74762_e("secChannel");
                }
                if (securityChannel == -1) {
                    list.add(TextFormatting.YELLOW + "Owned by: " + owner);
                } else {
                    list.add(TextFormatting.YELLOW + "Owned by: " + owner + " (channel " + securityChannel + ")");
                }
                if (!tagCompound.func_74764_b("idM")) {
                    list.add(TextFormatting.RED + "Warning! Ownership not correctly set! Please place block again!");
                }
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.needsRedstoneCheck()) {
            this.checkRedstone(world, pos);
        }
    }

    public void getDrops(NonNullList<ItemStack> result, IBlockAccess world, BlockPos pos, IBlockState metadata, int fortune) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GenericTileEntity) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((GenericTileEntity)tileEntity).writeRestorableToNBT(tagCompound);
            stack.func_77982_d(tagCompound);
            result.add((Object)stack);
            ((GenericTileEntity)tileEntity).getDrops(result, world, pos, metadata, fortune);
        } else {
            super.getDrops(result, world, pos, metadata, fortune);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public TileEntity createTileEntity(World world, IBlockState metadata) {
        try {
            return (TileEntity)this.tileEntityClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private WrenchUsage testWrenchUsage(BlockPos pos, EntityPlayer player) {
        Item item;
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        WrenchUsage wrenchUsed = WrenchUsage.NOT;
        if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) != null) {
            wrenchUsed = this.getWrenchUsage(pos, player, itemStack, wrenchUsed, item);
        }
        if (wrenchUsed == WrenchUsage.NORMAL && player.func_70093_af()) {
            wrenchUsed = WrenchUsage.SNEAKING;
        }
        return wrenchUsed;
    }

    protected WrenchUsage getWrenchUsage(BlockPos pos, EntityPlayer player, ItemStack itemStack, WrenchUsage wrenchUsed, Item item) {
        if (item instanceof SmartWrench) {
            switch (((SmartWrench)item).getMode(itemStack)) {
                case MODE_WRENCH: {
                    return WrenchUsage.NORMAL;
                }
                case MODE_SELECT: {
                    return player.func_70093_af() ? WrenchUsage.SNEAK_SELECT : WrenchUsage.SELECT;
                }
            }
            throw new RuntimeException("SmartWrench in unknown mode!");
        }
        if (McJtyLib.cofhapiitem && CofhApiItemCompatibility.isToolHammer(item)) {
            return CofhApiItemCompatibility.getWrenchUsage(item, itemStack, player, pos);
        }
        if (WrenchChecker.isAWrench(item)) {
            return WrenchUsage.NORMAL;
        }
        return wrenchUsed;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.handleModule(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ)) {
            return true;
        }
        WrenchUsage wrenchUsed = this.testWrenchUsage(pos, player);
        switch (wrenchUsed) {
            case NOT: {
                return this.openGui(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player);
            }
            case NORMAL: {
                return this.wrenchUse(world, pos, side, player);
            }
            case SNEAKING: {
                return this.wrenchSneak(world, pos, player);
            }
            case DISABLED: {
                return this.wrenchDisabled(world, pos, player);
            }
            case SELECT: {
                return this.wrenchSelect(world, pos, player);
            }
            case SNEAK_SELECT: {
                return this.wrenchSneakSelect(world, pos, player);
            }
        }
        return false;
    }

    protected IModuleSupport getModuleSupport() {
        return this.moduleSupport;
    }

    public void setModuleSupport(IModuleSupport moduleSupport) {
        this.moduleSupport = moduleSupport;
    }

    public boolean handleModule(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IModuleSupport support;
        return !heldItem.func_190926_b() && (support = this.getModuleSupport()) != null && support.isModule(heldItem) && InventoryHelper.installModule(player, heldItem, hand, pos, support.getFirstSlot(), support.getLastSlot());
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        boolean rc = super.rotateBlock(world, pos, axis);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GenericTileEntity) {
            ((GenericTileEntity)tileEntity).rotateBlock(axis);
        }
        return rc;
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GenericTileEntity) {
            if (!((GenericTileEntity)tileEntity).wrenchUse(world, pos, side, player)) {
                this.rotateBlock(world, pos, EnumFacing.UP);
            }
        } else {
            this.rotateBlock(world, pos, EnumFacing.UP);
        }
        return true;
    }

    protected boolean wrenchSneak(World world, BlockPos pos, EntityPlayer player) {
        this.breakAndRemember(world, player, pos);
        return true;
    }

    protected boolean wrenchDisabled(World world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    protected boolean wrenchSelect(World world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer player) {
        if (this.getGuiID() != -1) {
            if (world.field_72995_K) {
                return true;
            }
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (this.checkAccess(world, player, te)) {
                return true;
            }
            player.openGui((Object)this.modBase, this.getGuiID(), world, x, y, z);
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        this.restoreBlockFromNBT(world, pos, stack);
        if (!world.field_72995_K && GeneralConfig.manageOwnership) {
            this.setOwner(world, pos, placer);
        }
        if ((te = world.func_175625_s(pos)) instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onBlockPlacedBy(world, pos, state, placer, stack);
        }
        if (this.needsRedstoneCheck()) {
            this.checkRedstone(world, pos);
        }
    }

    protected void setOwner(World world, BlockPos pos, EntityLivingBase entityLivingBase) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity && entityLivingBase instanceof EntityPlayer) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            genericTileEntity.setOwner(player);
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    protected void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity) {
            ((GenericTileEntity)te).checkRedstone(world, pos);
        }
    }

    protected void breakAndRemember(World world, EntityPlayer player, BlockPos pos) {
        if (!world.field_72995_K) {
            this.func_180657_a(world, player, pos, world.func_180495_p(pos), world.func_175625_s(pos), ItemStack.field_190927_a);
        }
    }

    protected void restoreBlockFromNBT(World world, BlockPos pos, ItemStack itemStack) {
        TileEntity te;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (te = world.func_175625_s(pos)) instanceof GenericTileEntity) {
            ((GenericTileEntity)te).readRestorableFromNBT(tagCompound);
        }
    }

    public int getGuiID() {
        return this.guiId;
    }

    public void setGuiId(int guiId) {
        this.guiId = guiId;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        if (this.field_149758_A) {
            super.func_189539_a(state, worldIn, pos, id, param);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            return tileentity == null ? false : tileentity.func_145842_c(id, param);
        }
        return super.func_189539_a(state, worldIn, pos, id, param);
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<T, C, GenericGuiContainer<? super T>> getGuiFactory() {
        return this.guiFactory;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGuiFactory(BiFunction<T, C, GenericGuiContainer<? super T>> guiFactory) {
        this.guiFactory = guiFactory;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        IInventory inventory = tileEntity instanceof IInventory ? (IInventory)tileEntity : null;
        Container container = (Container)this.containerFactory.apply(entityPlayer, inventory);
        return this.getGuiFactory().apply((GenericTileEntity)tileEntity, container);
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        if (tileEntity instanceof IInventory) {
            return (Container)this.containerFactory.apply(entityPlayer, (IInventory)tileEntity);
        }
        return (Container)this.containerFactory.apply(entityPlayer, null);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof GenericTileEntity) {
            return ((GenericTileEntity)te).getActualState(state);
        }
        return super.func_176221_a(state, world, pos);
    }

    protected boolean checkAccess(World world, EntityPlayer player, TileEntity te) {
        if (te instanceof GenericTileEntity) {
            ((GenericTileEntity)te).checkAccess(player);
        }
        return false;
    }
}

