/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileUtils {
    public static ItemStack storeTileEntityInStack(ItemStack stack, TileEntity te, boolean addNBTLore) {
        return TileUtils.storeTileEntityNBTInStack(stack, te.func_189515_b(new NBTTagCompound()), addNBTLore);
    }

    public static ItemStack storeTileEntityNBTInStack(ItemStack stack, NBTTagCompound nbt, boolean addNBTLore) {
        nbt.func_82580_o("x");
        nbt.func_82580_o("y");
        nbt.func_82580_o("z");
        if (stack.func_77973_b() == Items.field_151144_bL && nbt.func_74764_b("Owner")) {
            NBTTagCompound tagOwner = nbt.func_74775_l("Owner");
            NBTTagCompound nbtOwner2 = new NBTTagCompound();
            nbtOwner2.func_74782_a("SkullOwner", (NBTBase)tagOwner);
            stack.func_77982_d(nbtOwner2);
        } else {
            stack.func_77983_a("BlockEntityTag", (NBTBase)nbt);
            if (addNBTLore) {
                NBTTagCompound tagDisplay = new NBTTagCompound();
                NBTTagList tagLore = new NBTTagList();
                tagLore.func_74742_a((NBTBase)new NBTTagString("(+NBT)"));
                tagDisplay.func_74782_a("Lore", (NBTBase)tagLore);
                stack.func_77983_a("display", (NBTBase)tagDisplay);
            }
        }
        return stack;
    }

    public static ItemStack storeTileEntityInStackWithCachedInventory(ItemStack stack, TileEntity te, boolean addNBTLore, int maxStackEntries) {
        TileUtils.storeTileEntityInStack(stack, te, addNBTLore);
        if (te instanceof TileEntityEnderUtilitiesInventory) {
            NBTTagCompound nbt = NBTUtils.getRootCompoundTag(stack, true);
            ((TileEntityEnderUtilitiesInventory)te).getCachedInventory(nbt, maxStackEntries);
        }
        return stack;
    }

    public static boolean createAndAddTileEntity(World world, BlockPos pos, @Nonnull NBTTagCompound nbt) {
        return TileUtils.createAndAddTileEntity(world, pos, nbt, Rotation.NONE, Mirror.NONE);
    }

    public static boolean createAndAddTileEntity(World world, BlockPos pos, @Nonnull NBTTagCompound nbt, Rotation rotation, Mirror mirror) {
        BlockPos posOrig = null;
        if (nbt.func_150297_b("x", 3) && nbt.func_150297_b("y", 3) && nbt.func_150297_b("z", 3)) {
            posOrig = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        }
        NBTUtils.setPositionInTileEntityNBT(nbt, pos);
        TileEntity te = TileEntity.func_190200_a((World)world, (NBTTagCompound)nbt);
        if (posOrig != null) {
            NBTUtils.setPositionInTileEntityNBT(nbt, posOrig);
        }
        if (te != null) {
            world.func_175690_a(pos, te);
            if (mirror != Mirror.NONE) {
                te.func_189668_a(mirror);
            }
            if (rotation != Rotation.NONE) {
                te.func_189667_a(rotation);
            }
            te.func_70296_d();
            return true;
        }
        return false;
    }
}

