/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.tile;

import com.elytradev.architecture.common.tile.SlotSawbench;
import com.elytradev.architecture.common.tile.SlotSawbenchResult;
import com.elytradev.architecture.common.tile.TileSawbench;
import com.elytradev.architecture.legacy.base.BaseContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ContainerSawbench
extends BaseContainer {
    public static int guWidth = 242;
    public static int guiHeight = 224;
    public static int inputSlotLeft = 12;
    public static int inputSlotTop = 19;
    public static int outputSlotLeft = 12;
    public static int outputSlotTop = 57;
    TileSawbench te;
    BaseContainer.SlotRange sawbenchSlotRange;
    Slot materialSlot;
    Slot resultSlot;

    public ContainerSawbench(EntityPlayer player, TileSawbench te) {
        super(guWidth, guiHeight);
        this.te = te;
        this.sawbenchSlotRange = new BaseContainer.SlotRange(this);
        this.materialSlot = this.func_75146_a(new Slot((IInventory)te, 0, inputSlotLeft, inputSlotTop));
        this.resultSlot = this.func_75146_a(new SlotSawbenchResult(te, 1, outputSlotLeft, outputSlotTop));
        this.sawbenchSlotRange.end();
        this.addPlayerSlots(player, 8, guiHeight - 81);
    }

    public static Container create(EntityPlayer player, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileSawbench) {
            return new ContainerSawbench(player, (TileSawbench)te);
        }
        return null;
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.te.func_70300_a(player);
    }

    @Override
    protected BaseContainer.SlotRange transferSlotRange(int srcSlotIndex, ItemStack stack) {
        if (this.playerSlotRange.contains(srcSlotIndex)) {
            return this.sawbenchSlotRange;
        }
        return this.playerSlotRange;
    }

    @Override
    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack newstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack oldstack = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)oldstack, (ItemStack)newstack)) continue;
            oldstack = newstack.func_190926_b() ? ItemStack.field_190927_a : newstack.func_77946_l();
            this.field_75153_a.set(i, (Object)oldstack);
            for (Object listener : this.field_75149_d) {
                if (listener instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)listener).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, i, newstack));
                    continue;
                }
                ((IContainerListener)listener).func_71111_a((Container)this, i, newstack);
            }
        }
    }

    public void func_75141_a(int i, ItemStack stack) {
        Slot slot = this.func_75139_a(i);
        if (slot instanceof SlotSawbench) {
            ((SlotSawbench)slot).updateFromServer(stack);
        } else {
            super.func_75141_a(i, stack);
        }
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = this.func_75139_a(index);
        if (slot == this.resultSlot) {
            return this.transferStackInResultSlot(player, index);
        }
        return super.func_82846_b(player, index);
    }

    protected ItemStack transferStackInResultSlot(EntityPlayer player, int index) {
        boolean materialWasPending = this.te.pendingMaterialUsage;
        ItemStack origMaterialStack = this.te.usePendingMaterial();
        ItemStack result = super.func_82846_b(player, index);
        if (materialWasPending) {
            this.te.returnUnusedMaterial(origMaterialStack);
        }
        return result;
    }
}

