/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0086\u0002J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u001aR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\""}, d2={"Lcom/teamwizardry/librarianlib/features/math/BoundingBox2D;", "", "minX", "", "minY", "maxX", "maxY", "(DDDD)V", "min", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "max", "(Lcom/teamwizardry/librarianlib/features/math/Vec2d;Lcom/teamwizardry/librarianlib/features/math/Vec2d;)V", "getMax", "()Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "getMin", "pos", "getPos", "size", "getSize", "contains", "", "other", "height", "heightF", "", "heightI", "", "offset", "scale", "amount", "union", "width", "widthF", "widthI", "librarianlib-1.12.2"})
public final class BoundingBox2D {
    @NotNull
    private final Vec2d min;
    @NotNull
    private final Vec2d max;

    @NotNull
    public final BoundingBox2D union(@NotNull BoundingBox2D other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new BoundingBox2D(Math.min(this.min.getX(), other.min.getX()), Math.min(this.min.getY(), other.min.getY()), Math.max(this.max.getX(), other.max.getX()), Math.max(this.max.getY(), other.max.getY()));
    }

    @NotNull
    public final BoundingBox2D offset(@NotNull Vec2d pos2) {
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        return new BoundingBox2D(CommonUtilMethods.plus(this.min, pos2), CommonUtilMethods.plus(this.max, pos2));
    }

    @NotNull
    public final BoundingBox2D scale(double amount) {
        return new BoundingBox2D(CommonUtilMethods.times(this.min, amount), CommonUtilMethods.times(this.max, amount));
    }

    public final boolean contains(@NotNull Vec2d other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.getX() <= this.max.getX() && other.getX() >= this.min.getX() && other.getY() <= this.max.getY() && other.getY() >= this.min.getY();
    }

    public final double height() {
        return this.max.getY() - this.min.getY();
    }

    public final double width() {
        return this.max.getX() - this.min.getX();
    }

    public final float heightF() {
        return this.max.getYf() - this.min.getYf();
    }

    public final float widthF() {
        return this.max.getXf() - this.min.getXf();
    }

    public final int heightI() {
        return this.max.getYi() - this.min.getYi();
    }

    public final int widthI() {
        return this.max.getXi() - this.min.getXi();
    }

    @NotNull
    public final Vec2d getPos() {
        return this.min;
    }

    @NotNull
    public final Vec2d getSize() {
        return CommonUtilMethods.minus(this.max, this.min);
    }

    @NotNull
    public final Vec2d getMin() {
        return this.min;
    }

    @NotNull
    public final Vec2d getMax() {
        return this.max;
    }

    public BoundingBox2D(@NotNull Vec2d min, @NotNull Vec2d max) {
        Intrinsics.checkParameterIsNotNull((Object)min, (String)"min");
        Intrinsics.checkParameterIsNotNull((Object)max, (String)"max");
        this.min = min;
        this.max = max;
    }

    public BoundingBox2D(double minX, double minY, double maxX, double maxY) {
        this(new Vec2d(minX, minY), new Vec2d(maxX, maxY));
    }
}

