/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mmec.common.core;

import com.google.common.base.Predicate;
import com.mojang.util.UUIDTypeAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.mmec.common.MightyEnderChicken;
import me.ichun.mods.mmec.common.core.ChunkLoadHandler;
import me.ichun.mods.mmec.common.core.SoundIndex;
import me.ichun.mods.mmec.common.entity.EntityChickenSpawner;
import me.ichun.mods.mmec.common.entity.EntityEnderChicken;
import me.ichun.mods.mmec.common.packet.PacketPlayClearMusic;
import me.ichun.mods.mmec.common.world.MECSavedData;
import me.ichun.mods.morph.api.MorphApi;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;

public class EventHandlerServer {
    public static final Predicate<Entity> ITEM_ENTITY_CHECKS = ent -> ent instanceof EntityChickenSpawner || ent instanceof EntityEnderChicken;
    public HashSet<EntityItem> itemsToTrackQueue = new HashSet();
    public HashSet<EntityItem> itemsToTrack = new HashSet();
    public HashMap<NetworkRegistry.TargetPoint, Integer> chaosChickenMusic = new HashMap();
    public boolean addedSlowpokeHandler = false;

    @SubscribeEvent
    public void onRegisterSound(RegistryEvent.Register<SoundEvent> event) {
        SoundIndex.init((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (!event.getPlayer().func_130014_f_().field_72995_K) {
            ItemStack is = event.getEntityItem().func_92059_d();
            if ((MightyEnderChicken.config.spawnSpecificDimension == 0 || MightyEnderChicken.config.spawnSpecificDimension == 1 && event.getEntity().field_70170_p.field_73011_w.getDimension() == MightyEnderChicken.config.spawnSpecificDimensionId) && (new ResourceLocation(MightyEnderChicken.config.enderChickenSpawnItem).equals((Object)is.func_77973_b().getRegistryName()) || new ResourceLocation(MightyEnderChicken.config.chaosChickenSpawnItem).equals((Object)is.func_77973_b().getRegistryName())) && is.func_190916_E() == 1) {
                ((WorldServer)event.getEntity().func_130014_f_()).func_152344_a(() -> this.itemsToTrackQueue.add(event.getEntityItem()));
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityEnderChicken && (event.getEntityLiving() instanceof EntityEnderman || event.getEntityLiving() instanceof EntityWither)) {
            event.getEntityLiving().func_70604_c(null);
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onEntityEnterChunk(EntityEvent.EnteringChunk event) {
        if (MightyEnderChicken.config.chickensChunkload == 1) {
            ChunkLoadHandler.checkAndCreateTicket(event);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Iterator<Map.Entry<NetworkRegistry.TargetPoint, Integer>> ite;
            if (iChunUtil.eventHandlerServer.ticks % 23 == 0) {
                this.itemsToTrack.addAll(this.itemsToTrackQueue);
                this.itemsToTrackQueue.clear();
                ite = this.itemsToTrack.iterator();
                while (ite.hasNext()) {
                    AxisAlignedBB aabb;
                    List ents;
                    EntityItem item = (EntityItem)ite.next();
                    if (item.field_70128_L || !item.field_70175_ag || item.func_92059_d().func_190916_E() != 1) {
                        ite.remove();
                        continue;
                    }
                    if (!item.field_70122_E) continue;
                    BlockPos pos = item.func_180425_c().func_177977_b();
                    if (item.func_130014_f_().func_180495_p(pos).func_177230_c() != Blocks.field_150484_ah) continue;
                    boolean spawn = true;
                    block1: for (int i = 0; i <= 1; ++i) {
                        for (int k = 0; k <= 1; ++k) {
                            if (i == 0 || k == 0) continue;
                            BlockPos pos1 = pos.func_177982_a(i, 0, k);
                            if (item.func_130014_f_().func_180495_p(pos1).func_177230_c() == Blocks.field_150343_Z) continue;
                            spawn = false;
                            continue block1;
                        }
                    }
                    if (spawn && !(ents = item.field_70170_p.func_175674_a((Entity)item, aabb = item.func_174813_aQ().func_186662_g(32.0), ITEM_ENTITY_CHECKS)).isEmpty()) {
                        spawn = false;
                    }
                    if (!spawn) continue;
                    boolean isChaos = new ResourceLocation(MightyEnderChicken.config.chaosChickenSpawnItem).equals((Object)item.func_92059_d().func_77973_b().getRegistryName());
                    item.field_70170_p.func_72838_d((Entity)new EntityChickenSpawner(item.field_70170_p, pos.func_177984_a(), item, (float)(isChaos ? MightyEnderChicken.config.scaleChaosChicken : MightyEnderChicken.config.scaleEnderChicken) / 10.0f, isChaos));
                    item.func_70106_y();
                    ite.remove();
                }
            }
            ite = this.chaosChickenMusic.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<NetworkRegistry.TargetPoint, Integer> e = ite.next();
                e.setValue(e.getValue() - 1);
                if (e.getValue() > 0) continue;
                MightyEnderChicken.channel.sendToAllAround((AbstractPacket)new PacketPlayClearMusic(), e.getKey());
                ite.remove();
            }
        }
    }

    public boolean hasKilled(boolean chaos) {
        MECSavedData savedData = (MECSavedData)DimensionManager.getWorld((int)0).func_72943_a(MECSavedData.class, "MECSavedData");
        return savedData != null && (chaos ? savedData.hasKilledCC : savedData.hasKilledEC);
    }

    public void setHasKilled(boolean chaos) {
        WorldServer world = DimensionManager.getWorld((int)0);
        MECSavedData savedData = (MECSavedData)world.func_72943_a(MECSavedData.class, "MECSavedData");
        if (savedData == null) {
            savedData = new MECSavedData("MECSavedData");
            world.func_72823_a("MECSavedData", (WorldSavedData)savedData);
        }
        boolean flag = false;
        if (chaos) {
            if (!savedData.hasKilledCC) {
                savedData.hasKilledCC = true;
                flag = true;
            }
        } else if (!savedData.hasKilledEC) {
            savedData.hasKilledEC = true;
            flag = true;
        }
        if (flag) {
            savedData.func_76185_a();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (Loader.isModLoaded((String)"morph") && !this.addedSlowpokeHandler && (event.player.func_146103_bH().getId().equals(UUIDTypeAdapter.fromString((String)"d2839efc-727a-4263-97ce-3c73cdee5013")) || event.player.func_146103_bH().getId().equals(UUIDTypeAdapter.fromString((String)"5af4ba16-5311-4ae3-9772-c6fb798ac2cf")))) {
            this.addedSlowpokeHandler = true;
            MightyEnderChicken.config.reveal(new String[]{"slowpokeEasterEgg"});
            if (MightyEnderChicken.config.slowpokeEasterEgg == 1) {
                MinecraftForge.EVENT_BUS.register((Object)new SlowpokeChicken());
            }
        }
    }

    public static class SlowpokeChicken {
        public EntityPlayer playerSlowpoke;
        public HashSet<Entity> trackedEntities = new HashSet();

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && (event.player.func_146103_bH().getId().equals(UUIDTypeAdapter.fromString((String)"d2839efc-727a-4263-97ce-3c73cdee5013")) || event.player.func_146103_bH().getId().equals(UUIDTypeAdapter.fromString((String)"5af4ba16-5311-4ae3-9772-c6fb798ac2cf")))) {
                this.playerSlowpoke = event.player;
            }
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                this.trackedEntities.removeIf(ent -> !ent.func_70089_S());
                if (this.playerSlowpoke != null) {
                    for (Entity ent2 : this.trackedEntities) {
                        if (ent2.field_71093_bK != this.playerSlowpoke.field_71093_bK) continue;
                        EntityLivingBase morph = MorphApi.getApiImpl().getMorphEntity(this.playerSlowpoke.func_130014_f_(), this.playerSlowpoke.func_70005_c_(), Side.SERVER);
                        if (this.playerSlowpoke.func_146103_bH().getId().equals(UUIDTypeAdapter.fromString((String)"5af4ba16-5311-4ae3-9772-c6fb798ac2cf"))) {
                            if (morph instanceof EntityWolf) break;
                            MorphApi.getApiImpl().forceMorph((EntityPlayerMP)this.playerSlowpoke, (EntityLivingBase)new EntityWolf(this.playerSlowpoke.field_70170_p));
                            break;
                        }
                        if (morph instanceof EntityChicken) break;
                        MorphApi.getApiImpl().forceMorph((EntityPlayerMP)this.playerSlowpoke, (EntityLivingBase)new EntityChicken(this.playerSlowpoke.field_70170_p));
                        break;
                    }
                }
            }
        }

        @SubscribeEvent
        public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
            if (!event.getWorld().field_72995_K && (event.getEntity() instanceof EntityChickenSpawner || event.getEntity() instanceof EntityEnderChicken)) {
                this.trackedEntities.add(event.getEntity());
            }
        }

        @SubscribeEvent
        public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            if (event.player.func_146103_bH().getId().equals(UUIDTypeAdapter.fromString((String)"d2839efc-727a-4263-97ce-3c73cdee5013"))) {
                this.playerSlowpoke = null;
                this.trackedEntities.clear();
            }
        }
    }

    public static class RealisticDropsCompatibility {
        @SubscribeEvent(priority=EventPriority.LOW)
        public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
            if (!event.getWorld().field_72995_K && EntityItem.class.isAssignableFrom(event.getEntity().getClass())) {
                EntityItem item = (EntityItem)event.getEntity();
                ItemStack is = item.func_92059_d();
                if ((MightyEnderChicken.config.spawnSpecificDimension == 0 || MightyEnderChicken.config.spawnSpecificDimension == 1 && event.getEntity().field_70170_p.field_73011_w.getDimension() == MightyEnderChicken.config.spawnSpecificDimensionId) && (new ResourceLocation(MightyEnderChicken.config.enderChickenSpawnItem).equals((Object)is.func_77973_b().getRegistryName()) || new ResourceLocation(MightyEnderChicken.config.chaosChickenSpawnItem).equals((Object)is.func_77973_b().getRegistryName())) && is.func_190916_E() == 1) {
                    ((WorldServer)event.getEntity().func_130014_f_()).func_152344_a(() -> MightyEnderChicken.eventHandlerServer.itemsToTrackQueue.add(item));
                }
            }
        }
    }
}

