/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.crafting.mana;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.item.IExplodable;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.block.fluid.ModFluids;
import com.teamwizardry.wizardry.crafting.mana.FluidCraftInstance;
import com.teamwizardry.wizardry.crafting.mana.FluidRecipeLoader;
import com.teamwizardry.wizardry.init.ModSounds;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FileUtils;

public class ManaRecipes {
    public static final ManaRecipes INSTANCE = new ManaRecipes();
    public static final HashMap<String, FluidRecipeLoader.FluidCrafter> RECIPE_REGISTRY = new HashMap();
    public static final HashMultimap<Ingredient, FluidRecipeLoader.FluidCrafter> RECIPES = HashMultimap.create();
    public static final String EXPLODABLE = "explodable";

    public void loadRecipes(File directory) {
        FluidRecipeLoader.INSTANCE.setDirectory(directory);
        FluidRecipeLoader.INSTANCE.processRecipes((Map<String, FluidRecipeLoader.FluidCrafter>)RECIPE_REGISTRY, (Multimap<Ingredient, FluidRecipeLoader.FluidCrafter>)RECIPES);
    }

    public static String[] getResourceListing(String mod, String path) {
        ArrayList all = Lists.newArrayList();
        if (CraftingHelper.findFiles((ModContainer)((ModContainer)Loader.instance().getIndexedModList().get(mod)), (String)("assets/" + mod + "/" + path), null, (root, full) -> all.add(root.relativize((Path)full).toString()), (boolean)false, (boolean)false)) {
            return all.toArray(new String[0]);
        }
        return new String[0];
    }

    public void copyMissingRecipes(File directory) {
        for (String recipeName : ManaRecipes.getResourceListing("wizardry", "fluid_recipes")) {
            File file;
            if (recipeName.isEmpty() || (file = new File(directory, recipeName)).exists()) continue;
            InputStream stream = LibrarianLib.PROXY.getResource("wizardry", "fluid_recipes/" + recipeName);
            if (stream == null) {
                Wizardry.logger.fatal("    > SOMETHING WENT WRONG! Could not read recipe " + recipeName + " from mod jar! Report this to the devs on Github!");
                continue;
            }
            try {
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
                Wizardry.logger.info("    > Mana recipe " + recipeName + " copied successfully from mod jar.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void copyAllRecipes(File directory) {
        Map modList = Loader.instance().getIndexedModList();
        for (Map.Entry entry : modList.entrySet()) {
            for (String recipeName : ManaRecipes.getResourceListing((String)entry.getKey(), "fluid_recipes")) {
                if (recipeName.isEmpty()) continue;
                InputStream stream = LibrarianLib.PROXY.getResource((String)entry.getKey(), "fluid_recipes/" + recipeName);
                if (stream == null) {
                    Wizardry.logger.fatal("    > SOMETHING WENT WRONG! Could not read recipe " + recipeName + " from mod jar of '" + (String)entry.getKey() + "'! Report this to the devs on Github!");
                    continue;
                }
                try {
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)new File(directory, recipeName));
                    Wizardry.logger.info("    > Mana recipe " + recipeName + " copied successfully from mod jar.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ExplodableCrafter
    extends FluidCraftInstance {
        public ExplodableCrafter() {
            super(ManaRecipes.EXPLODABLE, 200, ModFluids.MANA.getActual());
        }

        @Override
        public boolean isValid(World world, BlockPos pos, List<EntityItem> items) {
            Block at = world.func_180495_p(pos).func_177230_c();
            return at == this.fluid.getBlock() && items.stream().map(entity -> entity.func_92059_d().func_77973_b()).anyMatch(item -> item instanceof IExplodable);
        }

        @Override
        public void tick(World world, BlockPos pos, List<EntityItem> items) {
            super.tick(world, pos, items);
            EntityItem item = items.stream().filter(entity -> entity.func_92059_d().func_77973_b() instanceof IExplodable).findFirst().orElse(null);
            if (item != null && this.currentDuration % 40 == 0) {
                world.func_184148_a(null, item.field_70165_t, item.field_70163_u, item.field_70161_v, (SoundEvent)ModSounds.BUBBLING, SoundCategory.AMBIENT, 0.7f, RandUtil.nextFloat() * 0.4f + 0.8f);
            }
        }

        @Override
        public void finish(World world, BlockPos pos, List<EntityItem> items) {
            EntityItem item = items.stream().filter(entity -> entity.func_92059_d().func_77973_b() instanceof IExplodable).findFirst().orElse(null);
            if (item != null) {
                ((IExplodable)item.func_92059_d().func_77973_b()).explode((Entity)item);
                world.func_175698_g(pos);
                world.func_72900_e((Entity)item);
                world.func_184148_a(null, item.field_70165_t, item.field_70163_u, item.field_70161_v, (SoundEvent)ModSounds.GLASS_BREAK, SoundCategory.AMBIENT, 0.5f, RandUtil.nextFloat() * 0.4f + 0.8f);
            }
        }
    }
}

