/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity.projectile;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellRingCache;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRange;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.util.PosUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RandUtilSeed;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.entity.projectile.EntitySpellProjectile;
import com.teamwizardry.wizardry.common.module.effects.ModuleEffectLightning;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLightningProjectile
extends EntitySpellProjectile {
    public static final DataParameter<NBTTagCompound> CHILD_RING = EntityDataManager.func_187226_a(EntityLightningProjectile.class, (DataSerializer)DataSerializers.field_192734_n);

    public EntityLightningProjectile(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CHILD_RING, (Object)new NBTTagCompound());
    }

    public EntityLightningProjectile(World world, SpellRing spellRing, SpellRing childRing, SpellData spellData, float dist, float speed, float gravity) {
        super(world, spellRing, spellData, dist, speed, gravity, true);
        this.setChildRing(childRing);
    }

    protected SpellRing getChildRing() {
        NBTTagCompound compound = (NBTTagCompound)this.func_184212_Q().func_187225_a(CHILD_RING);
        return SpellRingCache.INSTANCE.getSpellRingByNBT(compound);
    }

    protected void setChildRing(SpellRing ring) {
        this.func_184212_Q().func_187227_b(CHILD_RING, (Object)ring.serializeNBT());
        this.func_184212_Q().func_187217_b(CHILD_RING);
    }

    @Override
    public void func_70071_h_() {
        double maxPotency;
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        SpellData data = this.getSpellData();
        final SpellRing spellRing = this.getSpellRing();
        SpellRing childRing = this.getChildRing();
        double range = childRing.getAttributeValue(AttributeRegistry.RANGE, data);
        double potency = childRing.getAttributeValue(AttributeRegistry.POTENCY, data);
        double duration = childRing.getAttributeValue(AttributeRegistry.DURATION, data);
        double d = maxPotency = childRing.getModule() != null ? childRing.getModule().getAttributeRanges().get((Object)AttributeRegistry.POTENCY).max : 0.0;
        if (data == null || spellRing == null) {
            this.func_70106_y();
            this.field_70170_p.func_72900_e((Entity)this);
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            ClientRunnable.run((ClientRunnable)new ClientRunnable(){

                @SideOnly(value=Side.CLIENT)
                public void runIfClient() {
                    ParticleBuilder glitter = new ParticleBuilder(10);
                    glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
                    glitter.enableMotionCalculation();
                    glitter.setCollision(true);
                    glitter.setCanBounce(true);
                    glitter.setColorFunction((InterpFunction)new InterpColorHSV(spellRing.getPrimaryColor(), spellRing.getSecondaryColor()));
                    ParticleSpawner.spawn((ParticleBuilder)glitter, (World)EntityLightningProjectile.this.field_70170_p, (InterpFunction)new StaticInterp((Object)EntityLightningProjectile.this.func_174791_d().func_178787_e(new Vec3d(EntityLightningProjectile.this.field_70159_w, EntityLightningProjectile.this.field_70181_x, EntityLightningProjectile.this.field_70179_y))), (int)10, (int)0, (aFloat, particleBuilder) -> {
                        particleBuilder.setScaleFunction((InterpFunction)new InterpScale((float)RandUtil.nextDouble(0.3, 0.8), 0.0f));
                        particleBuilder.setLifetime(RandUtil.nextInt(30, 40));
                        particleBuilder.setMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01)));
                        particleBuilder.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(5.0E-4, 0.003), 0.0));
                    });
                    glitter.disableMotionCalculation();
                    glitter.setMotion(Vec3d.field_186680_a);
                    ParticleSpawner.spawn((ParticleBuilder)glitter, (World)EntityLightningProjectile.this.field_70170_p, (InterpFunction)new StaticInterp((Object)EntityLightningProjectile.this.func_174791_d()), (int)2, (int)0, (aFloat, particleBuilder) -> {
                        particleBuilder.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(2.0f, 3.0f), 0.0f));
                        particleBuilder.setLifetime(RandUtil.nextInt(5, 10));
                    });
                }
            });
        } else {
            Vec3d dir = data.getData(SpellData.DefaultKeys.LOOK);
            if (dir == null) {
                return;
            }
            RandUtilSeed rand = new RandUtilSeed(RandUtil.nextLong(100L, 100000L));
            float u = rand.nextFloat();
            float v = rand.nextFloat();
            float pitch = (float)(180.0 * Math.acos(2.0f * u - 1.0f) / Math.PI);
            float yaw = (float)(Math.PI * 2 * (double)v);
            Vec3d to = dir.func_178789_a(pitch).func_178785_b(yaw).func_72432_b().func_186678_a(rand.nextDouble(maxPotency * 5.0) < potency ? range : 0.5).func_178787_e(this.func_174791_d());
            ModuleEffectLightning.doLightning(rand.nextLong(100L, 100000L), this.field_70170_p, data.getCaster(), this.func_174791_d(), to, range, potency, duration);
        }
    }

    @Override
    protected void goBoom(SpellRing spellRing, SpellData data) {
        SpellRing childRing = this.getChildRing();
        if (childRing == null || childRing.getModule() == null) {
            return;
        }
        double range = childRing.getAttributeValue(AttributeRegistry.RANGE, data);
        double potency = childRing.getAttributeValue(AttributeRegistry.POTENCY, data);
        double duration = childRing.getAttributeValue(AttributeRegistry.DURATION, data);
        AttributeRange potencyRange = childRing.getModule().getAttributeRanges().get(AttributeRegistry.POTENCY);
        Vec3d origin = this.func_174791_d();
        Entity caster = data.getCaster();
        int i = 0;
        while ((double)i < potency) {
            RandUtilSeed rand = new RandUtilSeed(RandUtil.nextLong(100L, 100000L));
            Vec3d dir = PosUtils.vecFromRotations(rand.nextFloat(0.0f, 180.0f), rand.nextFloat(0.0f, 360.0f));
            Vec3d pos = dir.func_186678_a(range).func_178787_e(origin);
            ModuleEffectLightning.doLightning(rand.nextLong(100L, 100000L), this.field_70170_p, caster, origin, pos, range, potency, duration);
            i += (int)potencyRange.min >> 2;
        }
        super.goBoom(spellRing, data);
    }

    @Override
    public void readCustomNBT(@Nonnull NBTTagCompound compound) {
        super.readCustomNBT(compound);
        if (compound.func_74764_b("child_ring")) {
            this.setChildRing(SpellRingCache.INSTANCE.getSpellRingByNBT(compound.func_74775_l("child_ring")));
        }
    }

    @Override
    public void writeCustomNBT(@Nonnull NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        compound.func_74782_a("child_ring", (NBTBase)this.getChildRing().serializeNBT());
    }
}

